/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.util;

import java.net.URI;
import java.util.function.Function;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkProtectedApi;
import net.snowflake.client.jdbc.internal.amazonaws.util.BoundedCache;

@SdkProtectedApi
public final class SdkUri {
    private static volatile SdkUri instance;
    private final BoundedCache<String, URI> cache = BoundedCache.builder().mappingFunction(new Function<String, URI>(){

        @Override
        public URI apply(String s2) {
            return URI.create(s2);
        }
    }).build();
    private final String HTTPS_PREFIX = "https://";
    private final String HTTP_PREFIX = "http://";

    private SdkUri() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SdkUri getInstance() {
        if (instance != null) return instance;
        Class<SdkUri> clazz = SdkUri.class;
        synchronized (SdkUri.class) {
            if (instance != null) return instance;
            instance = new SdkUri();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public URI create(String s2) {
        if (!this.isAccountIdUri(s2)) {
            return URI.create(s2);
        }
        return this.cache.get(s2);
    }

    private boolean isAccountIdUri(String s2) {
        int firstCharAfterScheme = 0;
        int maxIntSizeBase10 = 10;
        if (s2.startsWith("https://")) {
            firstCharAfterScheme = "https://".length();
        } else if (s2.startsWith("http://")) {
            firstCharAfterScheme = "http://".length();
        }
        if (s2.length() > firstCharAfterScheme + maxIntSizeBase10) {
            return Character.isDigit(s2.charAt(firstCharAfterScheme)) && Character.isDigit(s2.charAt(firstCharAfterScheme + maxIntSizeBase10));
        }
        return false;
    }
}

