#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkAccousticUtilities_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkBandFiltering_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDSPTableFFT_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMeanPowerSpectralDensity_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMergeReduceTables_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMultiDimensionBrowser_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkProjectSpectrumMagnitude_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSoundQuantitiesCalculator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSpectrogramFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTemporalMultiplexing_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkDSPFiltersPluginCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkAccousticUtilities_Init(csi);
  vtkBandFiltering_Init(csi);
  vtkDSPTableFFT_Init(csi);
  vtkMeanPowerSpectralDensity_Init(csi);
  vtkMergeReduceTables_Init(csi);
  vtkMultiDimensionBrowser_Init(csi);
  vtkProjectSpectrumMagnitude_Init(csi);
  vtkSoundQuantitiesCalculator_Init(csi);
  vtkSpectrogramFilter_Init(csi);
  vtkTemporalMultiplexing_Init(csi);
}
