/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	dynamic "github.com/traefik/traefik/v3/pkg/config/dynamic"
	v1 "k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1"
)

// MiddlewareSpecApplyConfiguration represents a declarative configuration of the MiddlewareSpec type for use
// with apply.
type MiddlewareSpecApplyConfiguration struct {
	AddPrefix         *dynamic.AddPrefix                `json:"addPrefix,omitempty"`
	StripPrefix       *dynamic.StripPrefix              `json:"stripPrefix,omitempty"`
	StripPrefixRegex  *dynamic.StripPrefixRegex         `json:"stripPrefixRegex,omitempty"`
	ReplacePath       *dynamic.ReplacePath              `json:"replacePath,omitempty"`
	ReplacePathRegex  *dynamic.ReplacePathRegex         `json:"replacePathRegex,omitempty"`
	Chain             *ChainApplyConfiguration          `json:"chain,omitempty"`
	IPWhiteList       *dynamic.IPWhiteList              `json:"ipWhiteList,omitempty"`
	IPAllowList       *dynamic.IPAllowList              `json:"ipAllowList,omitempty"`
	Headers           *dynamic.Headers                  `json:"headers,omitempty"`
	Errors            *ErrorPageApplyConfiguration      `json:"errors,omitempty"`
	RateLimit         *RateLimitApplyConfiguration      `json:"rateLimit,omitempty"`
	RedirectRegex     *dynamic.RedirectRegex            `json:"redirectRegex,omitempty"`
	RedirectScheme    *dynamic.RedirectScheme           `json:"redirectScheme,omitempty"`
	BasicAuth         *BasicAuthApplyConfiguration      `json:"basicAuth,omitempty"`
	DigestAuth        *DigestAuthApplyConfiguration     `json:"digestAuth,omitempty"`
	ForwardAuth       *ForwardAuthApplyConfiguration    `json:"forwardAuth,omitempty"`
	InFlightReq       *dynamic.InFlightReq              `json:"inFlightReq,omitempty"`
	Buffering         *dynamic.Buffering                `json:"buffering,omitempty"`
	CircuitBreaker    *CircuitBreakerApplyConfiguration `json:"circuitBreaker,omitempty"`
	Compress          *CompressApplyConfiguration       `json:"compress,omitempty"`
	PassTLSClientCert *dynamic.PassTLSClientCert        `json:"passTLSClientCert,omitempty"`
	Retry             *RetryApplyConfiguration          `json:"retry,omitempty"`
	ContentType       *dynamic.ContentType              `json:"contentType,omitempty"`
	GrpcWeb           *dynamic.GrpcWeb                  `json:"grpcWeb,omitempty"`
	Plugin            map[string]v1.JSON                `json:"plugin,omitempty"`
}

// MiddlewareSpecApplyConfiguration constructs a declarative configuration of the MiddlewareSpec type for use with
// apply.
func MiddlewareSpec() *MiddlewareSpecApplyConfiguration {
	return &MiddlewareSpecApplyConfiguration{}
}

// WithAddPrefix sets the AddPrefix field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AddPrefix field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithAddPrefix(value dynamic.AddPrefix) *MiddlewareSpecApplyConfiguration {
	b.AddPrefix = &value
	return b
}

// WithStripPrefix sets the StripPrefix field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the StripPrefix field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithStripPrefix(value dynamic.StripPrefix) *MiddlewareSpecApplyConfiguration {
	b.StripPrefix = &value
	return b
}

// WithStripPrefixRegex sets the StripPrefixRegex field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the StripPrefixRegex field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithStripPrefixRegex(value dynamic.StripPrefixRegex) *MiddlewareSpecApplyConfiguration {
	b.StripPrefixRegex = &value
	return b
}

// WithReplacePath sets the ReplacePath field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ReplacePath field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithReplacePath(value dynamic.ReplacePath) *MiddlewareSpecApplyConfiguration {
	b.ReplacePath = &value
	return b
}

// WithReplacePathRegex sets the ReplacePathRegex field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ReplacePathRegex field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithReplacePathRegex(value dynamic.ReplacePathRegex) *MiddlewareSpecApplyConfiguration {
	b.ReplacePathRegex = &value
	return b
}

// WithChain sets the Chain field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Chain field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithChain(value *ChainApplyConfiguration) *MiddlewareSpecApplyConfiguration {
	b.Chain = value
	return b
}

// WithIPWhiteList sets the IPWhiteList field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IPWhiteList field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithIPWhiteList(value dynamic.IPWhiteList) *MiddlewareSpecApplyConfiguration {
	b.IPWhiteList = &value
	return b
}

// WithIPAllowList sets the IPAllowList field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IPAllowList field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithIPAllowList(value dynamic.IPAllowList) *MiddlewareSpecApplyConfiguration {
	b.IPAllowList = &value
	return b
}

// WithHeaders sets the Headers field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Headers field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithHeaders(value dynamic.Headers) *MiddlewareSpecApplyConfiguration {
	b.Headers = &value
	return b
}

// WithErrors sets the Errors field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Errors field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithErrors(value *ErrorPageApplyConfiguration) *MiddlewareSpecApplyConfiguration {
	b.Errors = value
	return b
}

// WithRateLimit sets the RateLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RateLimit field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithRateLimit(value *RateLimitApplyConfiguration) *MiddlewareSpecApplyConfiguration {
	b.RateLimit = value
	return b
}

// WithRedirectRegex sets the RedirectRegex field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RedirectRegex field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithRedirectRegex(value dynamic.RedirectRegex) *MiddlewareSpecApplyConfiguration {
	b.RedirectRegex = &value
	return b
}

// WithRedirectScheme sets the RedirectScheme field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RedirectScheme field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithRedirectScheme(value dynamic.RedirectScheme) *MiddlewareSpecApplyConfiguration {
	b.RedirectScheme = &value
	return b
}

// WithBasicAuth sets the BasicAuth field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BasicAuth field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithBasicAuth(value *BasicAuthApplyConfiguration) *MiddlewareSpecApplyConfiguration {
	b.BasicAuth = value
	return b
}

// WithDigestAuth sets the DigestAuth field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DigestAuth field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithDigestAuth(value *DigestAuthApplyConfiguration) *MiddlewareSpecApplyConfiguration {
	b.DigestAuth = value
	return b
}

// WithForwardAuth sets the ForwardAuth field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ForwardAuth field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithForwardAuth(value *ForwardAuthApplyConfiguration) *MiddlewareSpecApplyConfiguration {
	b.ForwardAuth = value
	return b
}

// WithInFlightReq sets the InFlightReq field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the InFlightReq field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithInFlightReq(value dynamic.InFlightReq) *MiddlewareSpecApplyConfiguration {
	b.InFlightReq = &value
	return b
}

// WithBuffering sets the Buffering field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Buffering field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithBuffering(value dynamic.Buffering) *MiddlewareSpecApplyConfiguration {
	b.Buffering = &value
	return b
}

// WithCircuitBreaker sets the CircuitBreaker field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CircuitBreaker field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithCircuitBreaker(value *CircuitBreakerApplyConfiguration) *MiddlewareSpecApplyConfiguration {
	b.CircuitBreaker = value
	return b
}

// WithCompress sets the Compress field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Compress field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithCompress(value *CompressApplyConfiguration) *MiddlewareSpecApplyConfiguration {
	b.Compress = value
	return b
}

// WithPassTLSClientCert sets the PassTLSClientCert field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PassTLSClientCert field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithPassTLSClientCert(value dynamic.PassTLSClientCert) *MiddlewareSpecApplyConfiguration {
	b.PassTLSClientCert = &value
	return b
}

// WithRetry sets the Retry field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Retry field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithRetry(value *RetryApplyConfiguration) *MiddlewareSpecApplyConfiguration {
	b.Retry = value
	return b
}

// WithContentType sets the ContentType field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ContentType field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithContentType(value dynamic.ContentType) *MiddlewareSpecApplyConfiguration {
	b.ContentType = &value
	return b
}

// WithGrpcWeb sets the GrpcWeb field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the GrpcWeb field is set to the value of the last call.
func (b *MiddlewareSpecApplyConfiguration) WithGrpcWeb(value dynamic.GrpcWeb) *MiddlewareSpecApplyConfiguration {
	b.GrpcWeb = &value
	return b
}

// WithPlugin puts the entries into the Plugin field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Plugin field,
// overwriting an existing map entries in Plugin field with the same key.
func (b *MiddlewareSpecApplyConfiguration) WithPlugin(entries map[string]v1.JSON) *MiddlewareSpecApplyConfiguration {
	if b.Plugin == nil && len(entries) > 0 {
		b.Plugin = make(map[string]v1.JSON, len(entries))
	}
	for k, v := range entries {
		b.Plugin[k] = v
	}
	return b
}
