/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	dynamic "github.com/traefik/traefik/v3/pkg/config/dynamic"
)

// TLSClientConfigApplyConfiguration represents a declarative configuration of the TLSClientConfig type for use
// with apply.
type TLSClientConfigApplyConfiguration struct {
	ServerName          *string                    `json:"serverName,omitempty"`
	InsecureSkipVerify  *bool                      `json:"insecureSkipVerify,omitempty"`
	RootCAs             []RootCAApplyConfiguration `json:"rootCAs,omitempty"`
	RootCAsSecrets      []string                   `json:"rootCAsSecrets,omitempty"`
	CertificatesSecrets []string                   `json:"certificatesSecrets,omitempty"`
	PeerCertURI         *string                    `json:"peerCertURI,omitempty"`
	Spiffe              *dynamic.Spiffe            `json:"spiffe,omitempty"`
}

// TLSClientConfigApplyConfiguration constructs a declarative configuration of the TLSClientConfig type for use with
// apply.
func TLSClientConfig() *TLSClientConfigApplyConfiguration {
	return &TLSClientConfigApplyConfiguration{}
}

// WithServerName sets the ServerName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServerName field is set to the value of the last call.
func (b *TLSClientConfigApplyConfiguration) WithServerName(value string) *TLSClientConfigApplyConfiguration {
	b.ServerName = &value
	return b
}

// WithInsecureSkipVerify sets the InsecureSkipVerify field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the InsecureSkipVerify field is set to the value of the last call.
func (b *TLSClientConfigApplyConfiguration) WithInsecureSkipVerify(value bool) *TLSClientConfigApplyConfiguration {
	b.InsecureSkipVerify = &value
	return b
}

// WithRootCAs adds the given value to the RootCAs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the RootCAs field.
func (b *TLSClientConfigApplyConfiguration) WithRootCAs(values ...*RootCAApplyConfiguration) *TLSClientConfigApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithRootCAs")
		}
		b.RootCAs = append(b.RootCAs, *values[i])
	}
	return b
}

// WithRootCAsSecrets adds the given value to the RootCAsSecrets field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the RootCAsSecrets field.
func (b *TLSClientConfigApplyConfiguration) WithRootCAsSecrets(values ...string) *TLSClientConfigApplyConfiguration {
	for i := range values {
		b.RootCAsSecrets = append(b.RootCAsSecrets, values[i])
	}
	return b
}

// WithCertificatesSecrets adds the given value to the CertificatesSecrets field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the CertificatesSecrets field.
func (b *TLSClientConfigApplyConfiguration) WithCertificatesSecrets(values ...string) *TLSClientConfigApplyConfiguration {
	for i := range values {
		b.CertificatesSecrets = append(b.CertificatesSecrets, values[i])
	}
	return b
}

// WithPeerCertURI sets the PeerCertURI field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PeerCertURI field is set to the value of the last call.
func (b *TLSClientConfigApplyConfiguration) WithPeerCertURI(value string) *TLSClientConfigApplyConfiguration {
	b.PeerCertURI = &value
	return b
}

// WithSpiffe sets the Spiffe field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Spiffe field is set to the value of the last call.
func (b *TLSClientConfigApplyConfiguration) WithSpiffe(value dynamic.Spiffe) *TLSClientConfigApplyConfiguration {
	b.Spiffe = &value
	return b
}
