/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.IndexShardState;
import org.opensearch.index.shard.ReleasableRetryableRefreshListener;
import org.opensearch.indices.replication.checkpoint.SegmentReplicationCheckpointPublisher;

public class CheckpointRefreshListener
extends ReleasableRetryableRefreshListener {
    protected static Logger logger = LogManager.getLogger(CheckpointRefreshListener.class);
    private final IndexShard shard;
    private final SegmentReplicationCheckpointPublisher publisher;

    public CheckpointRefreshListener(IndexShard shard, SegmentReplicationCheckpointPublisher publisher) {
        this.shard = shard;
        this.publisher = publisher;
    }

    public void beforeRefresh() throws IOException {
    }

    @Override
    protected boolean performAfterRefreshWithPermit(boolean didRefresh) {
        if (didRefresh && this.shard.state() == IndexShardState.STARTED && this.shard.getReplicationTracker().isPrimaryMode() && !this.shard.indexSettings.isAssignedOnRemoteNode()) {
            this.publisher.publish(this.shard, this.shard.getLatestReplicationCheckpoint());
        }
        return true;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

