/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.percolator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.opensearch.common.document.DocumentField;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.percolator.PercolateQuery;
import org.opensearch.search.SearchHit;
import org.opensearch.search.fetch.FetchContext;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.search.fetch.FetchSubPhaseProcessor;
import org.opensearch.search.fetch.subphase.highlight.HighlightField;
import org.opensearch.search.fetch.subphase.highlight.HighlightPhase;
import org.opensearch.search.fetch.subphase.highlight.Highlighter;
import org.opensearch.search.fetch.subphase.highlight.SearchHighlightContext;
import org.opensearch.search.lookup.SourceLookup;

final class PercolatorHighlightSubFetchPhase
implements FetchSubPhase {
    private final HighlightPhase highlightPhase;

    PercolatorHighlightSubFetchPhase(Map<String, Highlighter> highlighters) {
        this.highlightPhase = new HighlightPhase(highlighters);
    }

    public FetchSubPhaseProcessor getProcessor(final FetchContext fetchContext) {
        if (fetchContext.highlight() == null) {
            return null;
        }
        final List<PercolateQuery> percolateQueries = PercolatorHighlightSubFetchPhase.locatePercolatorQuery(fetchContext.query());
        if (percolateQueries.isEmpty()) {
            return null;
        }
        return new FetchSubPhaseProcessor(){
            LeafReaderContext ctx;
            final /* synthetic */ PercolatorHighlightSubFetchPhase this$0;
            {
                this.this$0 = this$0;
            }

            public void setNextReader(LeafReaderContext readerContext) {
                this.ctx = readerContext;
            }

            public void process(FetchSubPhase.HitContext hit) throws IOException {
                boolean singlePercolateQuery = percolateQueries.size() == 1;
                for (PercolateQuery percolateQuery : percolateQueries) {
                    DocumentField field;
                    String fieldName = singlePercolateQuery ? "_percolator_document_slot" : "_percolator_document_slot_" + percolateQuery.getName();
                    IndexSearcher percolatorIndexSearcher = percolateQuery.getPercolatorIndexSearcher();
                    PercolateQuery.QueryStore queryStore = percolateQuery.getQueryStore();
                    LeafReaderContext percolatorLeafReaderContext = (LeafReaderContext)percolatorIndexSearcher.getIndexReader().leaves().get(0);
                    Query query = (Query)queryStore.getQueries(this.ctx).apply((Object)hit.docId());
                    if (query == null || (field = hit.hit().field(fieldName)) == null) continue;
                    for (Object matchedSlot : field.getValues()) {
                        int slot = (Integer)matchedSlot;
                        BytesReference document = percolateQuery.getDocuments().get(slot);
                        FetchSubPhase.HitContext subContext = new FetchSubPhase.HitContext(new SearchHit(slot, "unknown", Collections.emptyMap(), Collections.emptyMap()), percolatorLeafReaderContext, slot, new SourceLookup());
                        subContext.sourceLookup().setSource(document);
                        SearchHighlightContext highlight = new SearchHighlightContext(fetchContext.highlight().fields(), true);
                        FetchSubPhaseProcessor processor = this.this$0.highlightPhase.getProcessor(fetchContext, highlight, query);
                        processor.process(subContext);
                        for (Map.Entry entry : subContext.hit().getHighlightFields().entrySet()) {
                            Object hlFieldName;
                            if (percolateQuery.getDocuments().size() == 1) {
                                hlFieldName = singlePercolateQuery ? (String)entry.getKey() : percolateQuery.getName() + "_" + (String)entry.getKey();
                                hit.hit().getHighlightFields().put(hlFieldName, new HighlightField((String)hlFieldName, ((HighlightField)entry.getValue()).fragments()));
                                continue;
                            }
                            hlFieldName = singlePercolateQuery ? slot + "_" + (String)entry.getKey() : percolateQuery.getName() + "_" + slot + "_" + (String)entry.getKey();
                            hit.hit().getHighlightFields().put(hlFieldName, new HighlightField((String)hlFieldName, ((HighlightField)entry.getValue()).fragments()));
                        }
                    }
                }
            }
        };
    }

    static List<PercolateQuery> locatePercolatorQuery(Query query) {
        if (query == null) {
            return Collections.emptyList();
        }
        final ArrayList<PercolateQuery> queries = new ArrayList<PercolateQuery>();
        query.visit(new QueryVisitor(){

            public void visitLeaf(Query query) {
                if (query instanceof PercolateQuery) {
                    PercolateQuery percolateQuery = (PercolateQuery)query;
                    queries.add(percolateQuery);
                }
            }
        });
        return queries;
    }
}

