/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.search.SearchPhaseExecutionException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.ShardSearchFailure;
import org.opensearch.action.search.TransportSearchAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.breaker.CircuitBreakingException;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.RollupSearchResult;
import org.opensearch.indexmanagement.rollup.RollupSearchService;
import org.opensearch.indexmanagement.rollup.model.ContinuousMetadata;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.model.RollupMetadata;
import org.opensearch.indexmanagement.rollup.settings.RollupSettings;
import org.opensearch.indexmanagement.rollup.util.RollupUtilsKt;
import org.opensearch.search.aggregations.MultiBucketConsumerService;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0086@\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\u00100\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/opensearch/indexmanagement/rollup/RollupSearchService;", "", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "client", "Lorg/opensearch/transport/client/Client;", "<init>", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/transport/client/Client;)V", "getClient", "()Lorg/opensearch/transport/client/Client;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "retrySearchPolicy", "Lorg/opensearch/action/bulk/BackoffPolicy;", "cancelAfterTimeInterval", "Lorg/opensearch/common/unit/TimeValue;", "shouldProcessRollup", "", "rollup", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "metadata", "Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;", "hasNextFullWindow", "executeCompositeSearch", "Lorg/opensearch/indexmanagement/rollup/RollupSearchResult;", "job", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCancelAfterTimeInterval", "", "givenInterval", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nRollupSearchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollupSearchService.kt\norg/opensearch/indexmanagement/rollup/RollupSearchService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,165:1\n19938#2,7:166\n*S KotlinDebug\n*F\n+ 1 RollupSearchService.kt\norg/opensearch/indexmanagement/rollup/RollupSearchService\n*L\n129#1:166,7\n*E\n"})
public final class RollupSearchService {
    @NotNull
    private final Client client;
    private final Logger logger;
    private volatile BackoffPolicy retrySearchPolicy;
    private volatile TimeValue cancelAfterTimeInterval;

    public RollupSearchService(@NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.logger = LogManager.getLogger(this.getClass());
        TimeValue timeValue = (TimeValue)RollupSettings.Companion.getROLLUP_SEARCH_BACKOFF_MILLIS().get(settings);
        Object object = RollupSettings.Companion.getROLLUP_SEARCH_BACKOFF_COUNT().get(settings);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.retrySearchPolicy = BackoffPolicy.constantBackoff((TimeValue)timeValue, (int)((Number)object).intValue());
        this.cancelAfterTimeInterval = (TimeValue)TransportSearchAction.SEARCH_CANCEL_AFTER_TIME_INTERVAL_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(RollupSettings.Companion.getROLLUP_SEARCH_BACKOFF_MILLIS(), RollupSettings.Companion.getROLLUP_SEARCH_BACKOFF_COUNT(), (arg_0, arg_1) -> RollupSearchService._init_$lambda$0(this, arg_0, arg_1));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(TransportSearchAction.SEARCH_CANCEL_AFTER_TIME_INTERVAL_SETTING, arg_0 -> RollupSearchService._init_$lambda$1(this, arg_0));
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    public final boolean shouldProcessRollup(@NotNull Rollup rollup2, @Nullable RollupMetadata metadata2) {
        Intrinsics.checkNotNullParameter((Object)rollup2, (String)"rollup");
        if (!rollup2.getEnabled()) {
            return false;
        }
        if (metadata2 == null) {
            return true;
        }
        if (metadata2.getStatus() == RollupMetadata.Status.RETRY) {
            return true;
        }
        RollupMetadata.Status[] statusArray = new RollupMetadata.Status[]{RollupMetadata.Status.STOPPED, RollupMetadata.Status.FAILED};
        if (CollectionsKt.listOf((Object[])statusArray).contains((Object)metadata2.getStatus())) {
            return false;
        }
        if (metadata2.getAfterKey() != null) {
            return true;
        }
        if (!rollup2.getContinuous()) {
            statusArray = new RollupMetadata.Status[]{RollupMetadata.Status.INIT, RollupMetadata.Status.STARTED};
            if (CollectionsKt.listOf((Object[])statusArray).contains((Object)metadata2.getStatus())) {
                return true;
            }
            this.logger.debug("Non-continuous job [" + rollup2.getId() + "] is not processing next window [" + metadata2 + "]");
            return false;
        }
        return this.hasNextFullWindow(rollup2, metadata2);
    }

    private final boolean hasNextFullWindow(Rollup rollup2, RollupMetadata metadata2) {
        Instant instant = Instant.now();
        ContinuousMetadata continuousMetadata = metadata2.getContinuous();
        Intrinsics.checkNotNull((Object)continuousMetadata);
        Long l = rollup2.getDelay();
        return instant.isAfter(continuousMetadata.getNextWindowEndTime().plusMillis(l != null ? l : 0L));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object executeCompositeSearch(@NotNull Rollup job, @NotNull RollupMetadata metadata, @NotNull Continuation<? super RollupSearchResult> $completion) {
        if (!($completion instanceof executeCompositeSearch.1)) ** GOTO lbl-1000
        var16_4 = $completion;
        if ((var16_4.label & -2147483648) != 0) {
            var16_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ RollupSearchService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.executeCompositeSearch(null, null, (Continuation<? super RollupSearchResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                retryCount = new Ref.IntRef();
                v0 = this.retrySearchPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"retrySearchPolicy");
                v1 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"logger");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)job);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)metadata);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)retryCount);
                $continuation.label = 1;
                v2 = OpenSearchExtensionsKt.retry$default(v0, v1, null, (Function2)new Function2<TimeValue, Continuation<? super SearchResponse>, Object>(retryCount, this, job, metadata, null){
                    float F$0;
                    int label;
                    final /* synthetic */ Ref.IntRef $retryCount;
                    final /* synthetic */ RollupSearchService this$0;
                    final /* synthetic */ Rollup $job;
                    final /* synthetic */ RollupMetadata $metadata;
                    {
                        this.$retryCount = $retryCount;
                        this.this$0 = $receiver;
                        this.$job = $job;
                        this.$metadata = $metadata;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                float decay;
                                ResultKt.throwOnFailure((Object)$result);
                                float f = 2.0f;
                                int n = this.$retryCount.element;
                                this.$retryCount.element = n + 1;
                                this.F$0 = decay = (float)Math.pow(f, n);
                                this.label = 1;
                                Object object2 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.this$0.getClient(), (arg_0, arg_1) -> executeCompositeSearch.2.invokeSuspend$lambda$0(this.$job, decay, this.this$0, this.$retryCount, this.$metadata, arg_0, arg_1), (Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                float decay = this.F$0;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(TimeValue p1, Continuation<? super SearchResponse> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$0(Rollup $job, float $decay, RollupSearchService this$0, Ref.IntRef $retryCount, RollupMetadata $metadata, Client $this$suspendUntil, ActionListener listener) {
                        int pageSize = Math.max(1, $job.getPageSize() / (int)$decay);
                        if ($decay > 1.0f) {
                            RollupSearchService.access$getLogger$p(this$0).warn("Composite search failed for rollup, retrying [#" + ($retryCount.element - 1) + "] - reducing page size of composite aggregation from " + $job.getPageSize() + " to " + pageSize);
                        }
                        SearchRequest searchRequest = RollupUtilsKt.getRollupSearchRequest(Rollup.copy$default($job, null, 0L, 0L, false, 0L, null, null, null, null, null, null, null, null, null, pageSize, null, false, null, null, null, 1032191, null), $metadata);
                        TimeValue cancelTimeoutTimeValue = TimeValue.timeValueMinutes((long)RollupSearchService.access$getCancelAfterTimeInterval(this$0, RollupSearchService.access$getCancelAfterTimeInterval$p(this$0).getMinutes()));
                        searchRequest.setCancelAfterTimeInterval(cancelTimeoutTimeValue);
                        $this$suspendUntil.search(searchRequest, listener);
                        return Unit.INSTANCE;
                    }
                }, (Continuation)$continuation, 2, null);
                ** if (v2 != var18_6) goto lbl26
lbl25:
                // 1 sources

                return var18_6;
lbl26:
                // 1 sources

                ** GOTO lbl35
            }
            case 1: {
                retryCount = (Ref.IntRef)$continuation.L$2;
                metadata = (RollupMetadata)$continuation.L$1;
                job = (Rollup)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl35:
                    // 2 sources

                    var17_8 = (SearchResponse)v2;
                    var4_7 = new RollupSearchResult.Success(var17_8);
                }
                catch (SearchPhaseExecutionException e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    v3 = e.shardFailures();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"shardFailures(...)");
                    if (((Object[])v3).length == 0) {
                        v4 = ExceptionsHelper.unwrapCause((Throwable)e);
                        Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type java.lang.Exception");
                        v5 = new RollupSearchResult.Failure(null, (Exception)v4, 1, null);
                    } else {
                        v6 = e.shardFailures();
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"shardFailures(...)");
                        $this$reduce$iv = v6;
                        $i$f$reduce = false;
                        if ($this$reduce$iv.length == 0) {
                            throw new UnsupportedOperationException("Empty array can't be reduced.");
                        }
                        accumulator$iv = $this$reduce$iv[0];
                        index$iv = 1;
                        var11_19 = ArraysKt.getLastIndex((Object[])$this$reduce$iv);
                        if (index$iv <= var11_19) {
                            while (true) {
                                var12_20 = (ShardSearchFailure)$this$reduce$iv[index$iv];
                                s1 = (ShardSearchFailure)accumulator$iv;
                                $i$a$-reduce-RollupSearchService$executeCompositeSearch$shardFailure$1 = false;
                                v7 /* !! */  = accumulator$iv = s1.status().getStatus() > s2.status().getStatus() ? s1 : s2;
                                if (index$iv == var11_19) break;
                                ++index$iv;
                            }
                        }
                        shardFailure = (ShardSearchFailure)accumulator$iv;
                        v8 = ExceptionsHelper.unwrapCause((Throwable)shardFailure.getCause());
                        Intrinsics.checkNotNull((Object)v8, (String)"null cannot be cast to non-null type java.lang.Exception");
                        v5 = new RollupSearchResult.Failure(null, (Exception)v8, 1, null);
                    }
                    var4_7 = v5;
                }
                catch (RemoteTransportException e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    v9 = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)v9, (String)"null cannot be cast to non-null type java.lang.Exception");
                    var4_7 = new RollupSearchResult.Failure(null, (Exception)v9, 1, null);
                }
                catch (CircuitBreakingException e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    var4_7 = new RollupSearchResult.Failure(null, (Exception)e, 1, null);
                }
                catch (MultiBucketConsumerService.TooManyBucketsException e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    var4_7 = new RollupSearchResult.Failure(null, (Exception)e, 1, null);
                }
                catch (OpenSearchSecurityException e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    var4_7 = new RollupSearchResult.Failure("Cannot search data in source index/s - missing required index permissions: " + e.getLocalizedMessage(), (Exception)e);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    var4_7 = new RollupSearchResult.Failure(null, e, 1, null);
                }
                return var4_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final long getCancelAfterTimeInterval(long givenInterval) {
        if (givenInterval == -1L) {
            return givenInterval;
        }
        return Math.max(this.cancelAfterTimeInterval.minutes(), 10L);
    }

    private static final void _init_$lambda$0(RollupSearchService this$0, TimeValue millis, Integer count) {
        Intrinsics.checkNotNull((Object)count);
        this$0.retrySearchPolicy = BackoffPolicy.constantBackoff((TimeValue)millis, (int)count);
    }

    private static final void _init_$lambda$1(RollupSearchService this$0, TimeValue it) {
        this$0.cancelAfterTimeInterval = it;
    }

    public static final /* synthetic */ Logger access$getLogger$p(RollupSearchService $this) {
        return $this.logger;
    }

    public static final /* synthetic */ long access$getCancelAfterTimeInterval(RollupSearchService $this, long givenInterval) {
        return $this.getCancelAfterTimeInterval(givenInterval);
    }

    public static final /* synthetic */ TimeValue access$getCancelAfterTimeInterval$p(RollupSearchService $this) {
        return $this.cancelAfterTimeInterval;
    }
}

