/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util.tokens.impl;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.Arrays;
import org.tribuo.util.tokens.impl.SplitFunctionTokenizer;

public class SplitCharactersTokenizer
extends SplitFunctionTokenizer {
    public static final char[] DEFAULT_SPLIT_CHARACTERS = new char[]{'*', '(', ')', '&', '[', ']', '{', '}', '`', '\'', '|', ';', ':', '\\', '!', '-', '?'};
    public static final char[] DEFAULT_SPLIT_EXCEPTING_IN_DIGITS_CHARACTERS = new char[]{'.', ',', '/'};
    @Config(description="The characters to split on.")
    private char[] splitCharacters = DEFAULT_SPLIT_CHARACTERS;
    @Config(description="The characters to split on unless we're in a number.")
    private char[] splitXDigitsCharacters = DEFAULT_SPLIT_EXCEPTING_IN_DIGITS_CHARACTERS;

    public SplitCharactersTokenizer() {
        this.postConfig();
    }

    public void postConfig() {
        this.splitFunction = new SplitCharactersSplitterFunction(this.splitCharacters, this.splitXDigitsCharacters);
    }

    public SplitCharactersTokenizer(char[] splitCharacters, char[] splitXDigitsCharacters) {
        this.splitCharacters = splitCharacters;
        this.splitXDigitsCharacters = splitXDigitsCharacters;
        this.postConfig();
    }

    public static SplitCharactersTokenizer createWhitespaceTokenizer() {
        return new SplitCharactersTokenizer(new char[0], new char[0]);
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "Tokenizer");
    }

    @Deprecated
    public boolean isSplitCharacter(char c) {
        return SplitCharactersTokenizer.isCharacter(c, this.splitCharacters) || Character.isWhitespace(c);
    }

    @Deprecated
    public boolean isSplitXDigitCharacter(char c) {
        return SplitCharactersTokenizer.isCharacter(c, this.splitXDigitsCharacters);
    }

    private static boolean isCharacter(char c, char[] chars) {
        if (chars == null) {
            return false;
        }
        for (char ch : chars) {
            if (ch != c) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public char[] getSplitCharacters() {
        return Arrays.copyOf(this.splitCharacters, this.splitCharacters.length);
    }

    @Deprecated
    public char[] getSplitXDigitsCharacters() {
        return Arrays.copyOf(this.splitXDigitsCharacters, this.splitXDigitsCharacters.length);
    }

    @Override
    public SplitCharactersTokenizer clone() {
        return new SplitCharactersTokenizer(this.splitCharacters, this.splitXDigitsCharacters);
    }

    public static class SplitCharactersSplitterFunction
    implements SplitFunctionTokenizer.SplitFunction {
        private final char[] splitCharacters;
        private final char[] splitXDigitsCharacters;

        public SplitCharactersSplitterFunction(char[] splitCharacters, char[] splitXDigitsCharacters) {
            this.splitCharacters = splitCharacters;
            this.splitXDigitsCharacters = splitXDigitsCharacters;
        }

        @Override
        public SplitFunctionTokenizer.SplitResult apply(int codepoint, int index, CharSequence cs) {
            if (this.isSplitCharacter((char)codepoint)) {
                return SplitFunctionTokenizer.SplitResult.SPLIT_AT;
            }
            if (!(!this.isSplitXDigitCharacter((char)codepoint) || index != 0 && index != cs.length() - 1 && Character.isDigit(cs.charAt(index - 1)) && Character.isDigit(cs.charAt(index + 1)))) {
                return SplitFunctionTokenizer.SplitResult.SPLIT_AT;
            }
            return SplitFunctionTokenizer.SplitResult.NO_SPLIT_WORD;
        }

        public boolean isSplitCharacter(char c) {
            return SplitCharactersTokenizer.isCharacter(c, this.splitCharacters) || Character.isWhitespace(c);
        }

        public boolean isSplitXDigitCharacter(char c) {
            return SplitCharactersTokenizer.isCharacter(c, this.splitXDigitsCharacters);
        }
    }
}

