/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.command;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.ComplementDate;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandPrintBetween
extends SingleLineCommand2<GanttDiagram> {
    private static final ComplementDate pattern = ComplementDate.any();

    public CommandPrintBetween() {
        super(CommandPrintBetween.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandPrintBetween.class.getName(), RegexLeaf.start(), new RegexLeaf("print"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("between"), RegexLeaf.spaceOneOrMore(), pattern.toRegex("START"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("and"), RegexLeaf.spaceOneOrMore(), pattern.toRegex("END"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(GanttDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        Day start = pattern.getMe(diagram, arg, "START").get();
        Day end = pattern.getMe(diagram, arg, "END").get();
        diagram.setPrintInterval(start, end);
        return CommandExecutionResult.ok();
    }
}

