﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot-managed-integrations/IoTManagedIntegrationsRequest.h>
#include <aws/iot-managed-integrations/IoTManagedIntegrations_EXPORTS.h>
#include <aws/iot-managed-integrations/model/DeliveryDestinationType.h>

#include <utility>

namespace Aws {
namespace IoTManagedIntegrations {
namespace Model {

/**
 */
class UpdateDestinationRequest : public IoTManagedIntegrationsRequest {
 public:
  AWS_IOTMANAGEDINTEGRATIONS_API UpdateDestinationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateDestination"; }

  AWS_IOTMANAGEDINTEGRATIONS_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The name of the customer-managed destination.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UpdateDestinationRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the customer-managed destination.</p>
   */
  inline const Aws::String& GetDeliveryDestinationArn() const { return m_deliveryDestinationArn; }
  inline bool DeliveryDestinationArnHasBeenSet() const { return m_deliveryDestinationArnHasBeenSet; }
  template <typename DeliveryDestinationArnT = Aws::String>
  void SetDeliveryDestinationArn(DeliveryDestinationArnT&& value) {
    m_deliveryDestinationArnHasBeenSet = true;
    m_deliveryDestinationArn = std::forward<DeliveryDestinationArnT>(value);
  }
  template <typename DeliveryDestinationArnT = Aws::String>
  UpdateDestinationRequest& WithDeliveryDestinationArn(DeliveryDestinationArnT&& value) {
    SetDeliveryDestinationArn(std::forward<DeliveryDestinationArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The destination type for the customer-managed destination.</p>
   */
  inline DeliveryDestinationType GetDeliveryDestinationType() const { return m_deliveryDestinationType; }
  inline bool DeliveryDestinationTypeHasBeenSet() const { return m_deliveryDestinationTypeHasBeenSet; }
  inline void SetDeliveryDestinationType(DeliveryDestinationType value) {
    m_deliveryDestinationTypeHasBeenSet = true;
    m_deliveryDestinationType = value;
  }
  inline UpdateDestinationRequest& WithDeliveryDestinationType(DeliveryDestinationType value) {
    SetDeliveryDestinationType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the delivery destination role.</p>
   */
  inline const Aws::String& GetRoleArn() const { return m_roleArn; }
  inline bool RoleArnHasBeenSet() const { return m_roleArnHasBeenSet; }
  template <typename RoleArnT = Aws::String>
  void SetRoleArn(RoleArnT&& value) {
    m_roleArnHasBeenSet = true;
    m_roleArn = std::forward<RoleArnT>(value);
  }
  template <typename RoleArnT = Aws::String>
  UpdateDestinationRequest& WithRoleArn(RoleArnT&& value) {
    SetRoleArn(std::forward<RoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the customer-managed destination.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  UpdateDestinationRequest& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::String m_deliveryDestinationArn;

  DeliveryDestinationType m_deliveryDestinationType{DeliveryDestinationType::NOT_SET};

  Aws::String m_roleArn;

  Aws::String m_description;
  bool m_nameHasBeenSet = false;
  bool m_deliveryDestinationArnHasBeenSet = false;
  bool m_deliveryDestinationTypeHasBeenSet = false;
  bool m_roleArnHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTManagedIntegrations
}  // namespace Aws
