/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.launcher;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.equinox.launcher.JNIBridge;

public class Main {
    private boolean debug = false;
    private String bootLocation = null;
    private URL installLocation = null;
    private URL configurationLocation = null;
    private String framework = "org.eclipse.osgi";
    private String devClassPath = null;
    private Properties devClassPathProps = null;
    private boolean inDevelopmentMode = false;
    private String os = null;
    private String ws = null;
    private String arch = null;
    private String library = null;
    private String exitData = null;
    private String vm = null;
    private List<String> vmargs;
    private List<String> commands;
    private List<String> extensionPaths = null;
    private JNIBridge bridge = null;
    private boolean showSplash = false;
    private String splashLocation = null;
    private String endSplash = null;
    private boolean initialize = false;
    private boolean splashDown = false;
    private final Thread splashHandler = new SplashHandler();
    private static final String SPLASH_HANDLE = "org.eclipse.equinox.launcher.splash.handle";
    private static final String SPLASH_LOCATION = "org.eclipse.equinox.launcher.splash.location";
    private static final String FRAMEWORK = "-framework";
    private static final String INSTALL = "-install";
    private static final String INITIALIZE = "-initialize";
    private static final String VM = "-vm";
    private static final String VMARGS = "-vmargs";
    private static final String DEBUG = "-debug";
    private static final String DEV = "-dev";
    private static final String CONFIGURATION = "-configuration";
    private static final String NOSPLASH = "-nosplash";
    private static final String SHOWSPLASH = "-showsplash";
    private static final String EXITDATA = "-exitdata";
    private static final String NAME = "-name";
    private static final String LAUNCHER = "-launcher";
    private static final String PROTECT = "-protect";
    private static final String PROTECT_MASTER = "master";
    private static final String PROTECT_BASE = "base";
    private static final String LIBRARY = "--launcher.library";
    private static final String APPEND_VMARGS = "--launcher.appendvmargs";
    private static final String OVERRIDE_VMARGS = "--launcher.overridevmargs";
    private static final String NL = "-nl";
    private static final String ENDSPLASH = "-endsplash";
    private static final String[] SPLASH_IMAGES = new String[]{"splash.png", "splash.jpg", "splash.jpeg", "splash.gif", "splash.bmp"};
    private static final String CLEAN = "-clean";
    private static final String NOEXIT = "-noexit";
    private static final String OS = "-os";
    private static final String WS = "-ws";
    private static final String ARCH = "-arch";
    private static final String STARTUP = "-startup";
    private static final String OSGI = "org.eclipse.osgi";
    private static final String STARTER = "org.eclipse.core.runtime.adaptor.EclipseStarter";
    private static final String PLATFORM_URL = "platform:/base/";
    private static final String ECLIPSE_PROPERTIES = "eclipse.properties";
    private static final String FILE_SCHEME = "file:";
    private static final String REFERENCE_SCHEME = "reference:";
    private static final String JAR_SCHEME = "jar:";
    private static final String CONFIG_DIR = "configuration/";
    private static final String CONFIG_FILE = "config.ini";
    private static final String CONFIG_FILE_TEMP_SUFFIX = ".tmp";
    private static final String CONFIG_FILE_BAK_SUFFIX = ".bak";
    private static final String ECLIPSE = "eclipse";
    private static final String PRODUCT_SITE_MARKER = ".eclipseproduct";
    private static final String PRODUCT_SITE_ID = "id";
    private static final String PRODUCT_SITE_VERSION = "version";
    private static final String PROP_USER_HOME = "user.home";
    private static final String PROP_USER_DIR = "user.dir";
    private static final String PROP_INSTALL_AREA = "osgi.install.area";
    private static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    private static final String PROP_CONFIG_AREA_DEFAULT = "osgi.configuration.area.default";
    private static final String PROP_BASE_CONFIG_AREA = "osgi.baseConfiguration.area";
    private static final String PROP_SHARED_CONFIG_AREA = "osgi.sharedConfiguration.area";
    private static final String PROP_CONFIG_CASCADED = "osgi.configuration.cascaded";
    protected static final String PROP_FRAMEWORK = "osgi.framework";
    private static final String PROP_SPLASHPATH = "osgi.splashPath";
    private static final String PROP_SPLASHLOCATION = "osgi.splashLocation";
    private static final String PROP_CLASSPATH = "osgi.frameworkClassPath";
    private static final String PROP_EXTENSIONS = "osgi.framework.extensions";
    private static final String PROP_FRAMEWORK_SYSPATH = "osgi.syspath";
    private static final String PROP_FRAMEWORK_SHAPE = "osgi.framework.shape";
    private static final String PROP_LOGFILE = "osgi.logfile";
    private static final String PROP_REQUIRED_JAVA_VERSION = "osgi.requiredJavaVersion";
    private static final String PROP_PARENT_CLASSLOADER = "osgi.parentClassloader";
    private static final String PROP_FRAMEWORK_PARENT_CLASSLOADER = "osgi.frameworkParentClassloader";
    private static final String PROP_NL = "osgi.nl";
    private static final String PROP_NOSHUTDOWN = "osgi.noShutdown";
    private static final String PROP_DEBUG = "osgi.debug";
    private static final String PROP_OS = "osgi.os";
    private static final String PROP_WS = "osgi.ws";
    private static final String PROP_ARCH = "osgi.arch";
    private static final String PROP_EXITCODE = "eclipse.exitcode";
    private static final String PROP_EXITDATA = "eclipse.exitdata";
    private static final String PROP_LAUNCHER = "eclipse.launcher";
    private static final String PROP_LAUNCHER_NAME = "eclipse.launcher.name";
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    private static final String PROP_ECLIPSESECURITY = "eclipse.security";
    private static final String READ_ONLY_AREA_SUFFIX = ".readOnly";
    private static final String NONE = "@none";
    private static final String NO_DEFAULT = "@noDefault";
    private static final String USER_HOME = "@user.home";
    private static final String USER_DIR = "@user.dir";
    private static final String INSTALL_HASH_PLACEHOLDER = "@install.hash";
    private static final String LAUNCHER_DIR = "@launcher.dir";
    private static final String PARENT_CLASSLOADER_APP = "app";
    private static final String PARENT_CLASSLOADER_EXT = "ext";
    private static final String PARENT_CLASSLOADER_CURRENT = "current";
    private static final String SESSION = "!SESSION";
    private static final String ENTRY = "!ENTRY";
    private static final String MESSAGE = "!MESSAGE";
    private static final String STACK = "!STACK";
    private static final int ERROR = 4;
    private static final String PLUGIN_ID = "org.eclipse.equinox.launcher";
    private File logFile = null;
    private BufferedWriter log = null;
    private boolean newSession = true;
    private boolean protectBase = false;
    private static final String VARIABLE_DELIM_STRING = "$";
    private static final char VARIABLE_DELIM_CHAR = '$';
    private static final long NO_TIMESTAMP = -1L;
    private static final String BASE_TIMESTAMP_FILE_CONFIGINI = ".baseConfigIniTimestamp";
    private static final String KEY_CONFIGINI_TIMESTAMP = "configIniTimestamp";
    private static final String PROP_IGNORE_USER_CONFIGURATION = "eclipse.ignoreUserConfiguration";
    private static final Set<PosixFilePermission> PERMISSION_755 = PosixFilePermissions.fromString("rwxr-xr-x");
    private static final Pattern COMMA = Pattern.compile(",");

    private String getWS() {
        String osName;
        if (this.ws != null) {
            return this.ws;
        }
        String osgiWs = System.getProperty(PROP_WS);
        if (osgiWs != null) {
            this.ws = osgiWs;
            return this.ws;
        }
        return switch (osName = this.getOS()) {
            case "win32" -> "win32";
            case "linux" -> "gtk";
            case "macosx" -> "cocoa";
            default -> "unknown";
        };
    }

    private String getOS() {
        String osName;
        if (this.os != null) {
            return this.os;
        }
        String osgiOs = System.getProperty(PROP_OS);
        if (osgiOs != null) {
            this.os = osgiOs;
            return this.os;
        }
        return switch (osName = System.getProperty("os.name").toLowerCase(Locale.ROOT)) {
            case "linux" -> "linux";
            default -> osName.startsWith("win32".substring(0, 3)) ? "win32" : (osName.startsWith("macosx".substring(0, 3)) ? "macosx" : "unknown");
        };
    }

    private String getArch() {
        if (this.arch != null) {
            return this.arch;
        }
        String osgiArch = System.getProperty(PROP_ARCH);
        if (osgiArch != null) {
            this.arch = osgiArch;
            return this.arch;
        }
        String name = System.getProperty("os.arch");
        if (name.equalsIgnoreCase("amd64")) {
            return "x86_64";
        }
        return name;
    }

    private void setupJNI(List<URL> defaultPath) {
        if (this.bridge != null) {
            return;
        }
        String libPath = null;
        if (this.library != null) {
            File lib = new File(this.library);
            if (lib.isDirectory()) {
                libPath = this.searchFor(ECLIPSE, lib.getAbsolutePath());
            } else if (lib.exists()) {
                libPath = lib.getAbsolutePath();
            }
        }
        if (libPath == null) {
            String fragmentName = String.join((CharSequence)".", PLUGIN_ID, this.getWS(), this.getOS(), this.getArch());
            libPath = this.getLibraryPath(fragmentName, defaultPath);
        }
        this.library = libPath;
        if (this.library != null) {
            this.bridge = new JNIBridge(this.library);
        }
    }

    private String getLibraryPath(String fragmentName, List<URL> defaultPath) {
        File location;
        String devPathList;
        List<String> locations;
        Stream<Object> searchPath = Stream.empty();
        if (this.inDevelopmentMode && this.devClassPathProps != null && !(locations = this.getArrayFromList(devPathList = this.devClassPathProps.getProperty(PLUGIN_ID))).isEmpty() && (location = new File(locations.get(0))).isAbsolute()) {
            searchPath = Stream.of(location.getParent());
        }
        if (this.bootLocation != null && defaultPath != null && !defaultPath.isEmpty()) {
            searchPath = Stream.concat(searchPath, IntStream.range(0, defaultPath.size()).map(i -> defaultPath.size() - 1 - i).mapToObj(defaultPath::get).map(url -> new File(url.getFile()).getParent()));
        }
        searchPath = Stream.concat(searchPath, Stream.of(this.getInstallLocation().getFile() + "/plugins/"));
        return searchPath.map(dir -> this.getLibraryFromFragment(fragmentName, (String)dir)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private String getLibraryFromFragment(String fragmentName, String dir) {
        block18: {
            File frag;
            String fragment = this.searchFor(fragmentName, dir);
            if (fragment == null) {
                return null;
            }
            if (fragment.startsWith(FILE_SCHEME)) {
                fragment = fragment.substring(5);
            }
            if (!(frag = new File(fragment)).exists()) {
                return null;
            }
            if (frag.isDirectory()) {
                return this.searchFor(ECLIPSE, fragment);
            }
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (ZipFile fragmentJar = new ZipFile(frag);){
                    Optional<String> entry = fragmentJar.stream().map(ZipEntry::getName).filter(n -> n.startsWith("eclipse_")).findFirst();
                    if (!entry.isPresent()) break block18;
                    String lib = this.extractFromJAR(fragment, entry.get());
                    if (!this.getOS().equals("win32")) {
                        try {
                            Files.setPosixFilePermissions(Paths.get(lib, new String[0]), PERMISSION_755);
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    return lib;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.log("Exception opening JAR file: " + fragment);
                this.log(e);
                return null;
            }
        }
        return null;
    }

    private void basicRun(String[] args) throws Exception {
        System.setProperty("eclipse.startTime", Long.toString(System.currentTimeMillis()));
        this.commands = List.of(args);
        String[] passThruArgs = (String[])this.processCommandLine(this.commands).toArray(String[]::new);
        if (!this.debug) {
            this.debug = System.getProperty(PROP_DEBUG) != null;
        }
        this.setupVMProperties();
        this.processConfiguration();
        if (this.protectBase && System.getProperty(PROP_SHARED_CONFIG_AREA) == null) {
            System.err.println("This application is configured to run in a cascaded mode only.");
            System.setProperty(PROP_EXITCODE, Integer.toString(14));
            return;
        }
        this.getInstallLocation();
        List<URL> bootPath = this.getBootPath(this.bootLocation);
        this.setupJNI(bootPath);
        if (!this.checkVersion(System.getProperty("java.version"), System.getProperty(PROP_REQUIRED_JAVA_VERSION))) {
            return;
        }
        if (!this.checkConfigurationLocation(this.configurationLocation)) {
            return;
        }
        URL[] bootPathURLs = (URL[])bootPath.toArray(URL[]::new);
        this.setSecurityPolicy(bootPathURLs);
        this.handleSplash();
        this.invokeFramework(passThruArgs, bootPathURLs);
    }

    private void setSecurityPolicy(URL[] bootPath) {
        String eclipseSecurity = System.getProperty(PROP_ECLIPSESECURITY);
        if (eclipseSecurity != null) {
            ProtectionDomain domain = Main.class.getProtectionDomain();
            CodeSource source = null;
            if (domain != null) {
                source = Main.class.getProtectionDomain().getCodeSource();
            }
            if (domain == null || source == null) {
                this.log("Can not automatically set the security manager. Please use a policy file.");
                return;
            }
            ArrayList<URL> rootURLs = new ArrayList<URL>(bootPath.length + 1);
            rootURLs.add(source.getLocation());
            Collections.addAll(rootURLs, bootPath);
            EclipsePolicy eclipsePolicy = new EclipsePolicy(Policy.getPolicy(), rootURLs);
            Policy.setPolicy(eclipsePolicy);
        }
    }

    private void invokeFramework(String[] passThruArgs, URL[] bootPath) throws Exception {
        String type = PARENT_CLASSLOADER_EXT;
        type = System.getProperty(PROP_PARENT_CLASSLOADER, type);
        type = System.getProperty(PROP_FRAMEWORK_PARENT_CLASSLOADER, type);
        ClassLoader parent = null;
        if (PARENT_CLASSLOADER_APP.equalsIgnoreCase(type)) {
            parent = ClassLoader.getSystemClassLoader();
        } else if (PARENT_CLASSLOADER_EXT.equalsIgnoreCase(type)) {
            ClassLoader appCL = ClassLoader.getSystemClassLoader();
            if (appCL != null) {
                parent = appCL.getParent();
            }
        } else if (PARENT_CLASSLOADER_CURRENT.equalsIgnoreCase(type)) {
            parent = this.getClass().getClassLoader();
        }
        StartupClassLoader loader = new StartupClassLoader(bootPath, parent);
        Class<?> clazz = loader.loadClass(STARTER);
        Method method = clazz.getDeclaredMethod("run", String[].class, Runnable.class);
        try {
            method.invoke(clazz, passThruArgs, this.splashHandler);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            if (throwable instanceof Error) {
                Error error = (Error)throwable;
                throw error;
            }
            Throwable throwable2 = e.getTargetException();
            if (throwable2 instanceof Exception) {
                Exception exception = (Exception)throwable2;
                throw exception;
            }
            throw e;
        }
    }

    private boolean checkVersion(String availableVersion, String requiredVersion) {
        if (requiredVersion == null || availableVersion == null) {
            return true;
        }
        try {
            boolean compatible;
            String delimiter = ". _-";
            Identifier required = Identifier.create(requiredVersion, delimiter);
            Identifier available = Identifier.create(availableVersion, delimiter);
            boolean bl = compatible = Identifier.MAIN_VERSION.compare(available, required) >= 0;
            if (!compatible) {
                System.setProperty(PROP_EXITCODE, "14");
                System.setProperty(PROP_EXITDATA, "<title>Incompatible JVM</title>Version " + availableVersion + " of the JVM is not suitable for this product. Version: " + requiredVersion + " or greater is required.");
            }
            return compatible;
        }
        catch (NumberFormatException | SecurityException e) {
            return true;
        }
    }

    private boolean checkConfigurationLocation(URL locationUrl) {
        if (locationUrl == null || !"file".equals(locationUrl.getProtocol())) {
            return true;
        }
        if (Boolean.parseBoolean(System.getProperty("osgi.configuration.area.readOnly"))) {
            return true;
        }
        File configDir = new File(locationUrl.getFile()).getAbsoluteFile();
        if (!configDir.exists()) {
            configDir.mkdirs();
            if (!configDir.exists()) {
                System.setProperty(PROP_EXITCODE, "15");
                System.setProperty(PROP_EXITDATA, "<title>Invalid Configuration Location</title>The configuration area at '" + String.valueOf(configDir) + "' could not be created.  Please choose a writable location using the '-configuration' command line option.");
                return false;
            }
        }
        if (!Main.canWrite(configDir, this.getOS())) {
            System.setProperty(PROP_EXITCODE, "15");
            System.setProperty(PROP_EXITDATA, "<title>Invalid Configuration Location</title>The configuration area at '" + String.valueOf(configDir) + "' is not writable.  Please choose a writable location using the '-configuration' command line option.");
            return false;
        }
        return true;
    }

    private String decode(String urlString) {
        try {
            if (urlString.indexOf(43) >= 0) {
                int len = urlString.length();
                StringBuilder buf = new StringBuilder(len);
                int i = 0;
                while (i < len) {
                    char c = urlString.charAt(i);
                    if (c == '+') {
                        buf.append("%2B");
                    } else {
                        buf.append(c);
                    }
                    ++i;
                }
                urlString = buf.toString();
            }
            return URLDecoder.decode(urlString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private List<String> getArrayFromList(String prop) {
        if (prop == null || prop.isBlank()) {
            return List.of();
        }
        return COMMA.splitAsStream(prop).map(String::trim).filter(s -> !s.isEmpty()).toList();
    }

    private List<URL> getDevPath(URL base) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>(5);
        if (this.inDevelopmentMode) {
            this.addDevEntries(base, result, OSGI);
        }
        this.addBaseJars(base, result);
        return result;
    }

    private URL constructURL(URL url, String name) {
        String externalForm = url.toExternalForm();
        if (externalForm.endsWith(".jar")) {
            try {
                return new URL(JAR_SCHEME + String.valueOf(url) + "!/" + name);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        try {
            return new URL(url, name);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private void readFrameworkExtensions(URL base, List<URL> result) throws IOException {
        List<String> extensions = this.getArrayFromList(System.getProperty(PROP_EXTENSIONS));
        String parent = new File(base.getFile()).getParent();
        ArrayList<String> extensionResults = new ArrayList<String>(extensions.size());
        for (String extension : extensions) {
            Properties extensionProperties;
            URL extensionURL;
            String path;
            block11: {
                path = this.searchForBundle(extension, parent);
                if (path == null) {
                    this.log("Could not find extension: " + extension);
                    continue;
                }
                if (this.debug) {
                    System.out.println("Loading extension: " + extension);
                }
                extensionURL = null;
                if (this.installLocation.getProtocol().equals("file")) {
                    extensionResults.add(path);
                    extensionURL = new File(path).toURL();
                } else {
                    extensionURL = new URL(this.installLocation.getProtocol(), this.installLocation.getHost(), this.installLocation.getPort(), path);
                }
                extensionProperties = null;
                try {
                    extensionProperties = this.loadProperties(this.constructURL(extensionURL, ECLIPSE_PROPERTIES));
                }
                catch (IOException e) {
                    if (!this.debug) break block11;
                    System.out.println("\teclipse.properties not found");
                }
            }
            String extensionClassPath = null;
            if (extensionProperties != null) {
                extensionClassPath = extensionProperties.getProperty(PROP_CLASSPATH);
            } else {
                extensionProperties = new Properties();
            }
            List<String> entries = extensionClassPath == null || extensionClassPath.isEmpty() ? List.of("") : this.getArrayFromList(extensionClassPath);
            Object qualifiedPath = System.getProperty(PROP_CLASSPATH) == null ? "." : "";
            for (String entry : entries) {
                qualifiedPath = (String)qualifiedPath + ", file:" + path + entry;
            }
            extensionProperties.put(PROP_CLASSPATH, qualifiedPath);
            this.mergeWithSystemProperties(extensionProperties, null);
            if (!this.inDevelopmentMode) continue;
            String name = extension;
            if (name.startsWith(REFERENCE_SCHEME)) {
                name = new File(path).getName();
            }
            this.addDevEntries(extensionURL, result, name);
        }
        this.extensionPaths = extensionResults;
    }

    private void addBaseJars(URL base, List<URL> result) throws IOException {
        File fwkFile;
        boolean fwkIsDirectory;
        String baseJarList = System.getProperty(PROP_CLASSPATH);
        if (baseJarList == null) {
            this.readFrameworkExtensions(base, result);
            baseJarList = System.getProperty(PROP_CLASSPATH);
        }
        if (fwkIsDirectory = (fwkFile = new File(base.getFile())).isDirectory()) {
            System.setProperty(PROP_FRAMEWORK_SHAPE, "folder");
        } else {
            System.setProperty(PROP_FRAMEWORK_SHAPE, "jar");
        }
        Object fwkPath = new File(new File(base.getFile()).getParent()).getAbsolutePath();
        if (Character.isUpperCase(((String)fwkPath).charAt(0))) {
            fwkPath = Character.toLowerCase(((String)fwkPath).charAt(0)) + ((String)fwkPath).substring(1);
        }
        System.setProperty(PROP_FRAMEWORK_SYSPATH, (String)fwkPath);
        List<String> baseJars = this.getArrayFromList(baseJarList);
        if (baseJars.isEmpty()) {
            if (!this.inDevelopmentMode && new File(base.getFile()).isDirectory()) {
                throw new IOException("Unable to initialize osgi.frameworkClassPath");
            }
            this.addEntry(base, result);
            return;
        }
        for (String string : baseJars) {
            try {
                if (string.equals(".")) {
                    this.addEntry(base, result);
                }
                URL url = null;
                url = string.startsWith(FILE_SCHEME) ? new File(string.substring(5)).toURL() : new URL(string);
                this.addEntry(url, result);
            }
            catch (MalformedURLException e) {
                this.addEntry(new URL(base, string), result);
            }
        }
    }

    private void addEntry(URL url, List<URL> result) {
        if (new File(url.getFile()).exists()) {
            result.add(url);
        }
    }

    private void addDevEntries(URL base, List<URL> result, String symbolicName) throws MalformedURLException {
        if (this.devClassPathProps == null) {
            return;
        }
        String devPathList = this.devClassPathProps.getProperty(symbolicName);
        if (devPathList == null) {
            devPathList = this.devClassPathProps.getProperty("*");
        }
        List<String> locations = this.getArrayFromList(devPathList);
        for (String location : locations) {
            URL url;
            File path = new File(location);
            if (path.isAbsolute()) {
                url = path.toURL();
            } else {
                char lastChar = location.charAt(location.length() - 1);
                url = location.endsWith(".jar") || lastChar == '/' || lastChar == '\\' ? new URL(base, location) : new URL(base, location + "/");
            }
            this.addEntry(url, result);
        }
    }

    private List<URL> getBootPath(String base) throws IOException {
        URL url = null;
        if (base != null) {
            url = Main.buildURL(base, true);
        } else {
            url = this.getInstallLocation();
            String pluginsLocation = new File(url.getFile(), "plugins").toString();
            String path = this.searchFor(this.framework, pluginsLocation);
            if (path == null) {
                throw new FileNotFoundException(String.format("Could not find framework under %s", pluginsLocation));
            }
            url = url.getProtocol().equals("file") ? new File(path).toURL() : new URL(url.getProtocol(), url.getHost(), url.getPort(), path);
        }
        if (System.getProperty(PROP_FRAMEWORK) == null) {
            System.setProperty(PROP_FRAMEWORK, url.toExternalForm());
        }
        if (this.debug) {
            System.out.println("Framework located:\n    " + url.toExternalForm());
        }
        List<URL> result = this.getDevPath(url);
        if (this.debug) {
            System.out.println("Framework classpath:");
            for (URL devPath : result) {
                System.out.println("    " + devPath.toExternalForm());
            }
        }
        return result;
    }

    private String searchFor(String target, String start) {
        File root = Main.resolveFile(new File(start));
        String[] candidates = root.list();
        if (candidates == null) {
            return null;
        }
        ArrayList<String> matches = new ArrayList<String>(2);
        String[] stringArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            String candidate = stringArray[n2];
            if (this.isMatchingCandidate(target, candidate, root)) {
                matches.add(candidate);
            }
            ++n2;
        }
        return this.findMax(target, matches).map(name -> {
            File candidate = new File(root, (String)name);
            return candidate.getAbsolutePath().replace(File.separatorChar, '/') + (candidate.isDirectory() ? "/" : "");
        }).orElse(null);
    }

    /*
     * Unable to fully structure code
     */
    private boolean isMatchingCandidate(String target, String candidate, File root) {
        if (candidate.equals(target)) {
            return true;
        }
        if (!candidate.startsWith(target + "_")) {
            return false;
        }
        targetLength = target.length();
        lastUnderscore = candidate.lastIndexOf(95);
        candidateFile = new File(root, candidate);
        if (candidateFile.isFile() && (candidate.endsWith(".jar") || candidate.endsWith(".zip"))) {
            extension = candidate.lastIndexOf(46);
            candidate = candidate.substring(0, extension);
        }
        if ((lastDot = candidate.lastIndexOf(46)) >= targetLength) ** GOTO lbl14
        return false;
lbl-1000:
        // 1 sources

        {
            lastUnderscore = candidate.lastIndexOf(95, lastUnderscore - 1);
lbl14:
            // 2 sources

            ** while (lastUnderscore > lastDot)
        }
lbl15:
        // 1 sources

        return lastUnderscore == targetLength;
    }

    private String searchForBundle(String target, String start) {
        if (target.startsWith(REFERENCE_SCHEME)) {
            File child;
            if (!(target = target.substring(REFERENCE_SCHEME.length())).startsWith(FILE_SCHEME)) {
                throw new IllegalArgumentException("Bundle URL is invalid: " + target);
            }
            target = target.substring(FILE_SCHEME.length());
            File fileLocation = child = new File(target);
            if (!child.isAbsolute()) {
                File parent = Main.resolveFile(new File(start));
                fileLocation = new File(parent, child.getPath());
            }
            return this.searchFor(fileLocation.getName(), fileLocation.getParentFile().getAbsolutePath());
        }
        return this.searchFor(target, start);
    }

    private Optional<String> findMax(String prefix, List<String> candidates) {
        return candidates.stream().map(name -> {
            String version = "";
            if (prefix == null) {
                version = name;
            } else if (name.startsWith(prefix + "_")) {
                version = name.substring(prefix.length() + 1);
            }
            Identifier currentVersion = this.getVersionElements(version);
            return Map.entry(name, currentVersion);
        }).max(Comparator.comparing(Map.Entry::getValue, Identifier.FULL_VERSION)).map(Map.Entry::getKey);
    }

    private Identifier getVersionElements(String version) {
        if (version.endsWith(".jar")) {
            version = version.substring(0, version.length() - 4);
        }
        try {
            return Identifier.create(version, ".");
        }
        catch (NumberFormatException e) {
            return new Identifier(0, 0, 0, "");
        }
    }

    private static URL buildURL(String spec, boolean trailingSlash) {
        if (spec == null) {
            return null;
        }
        if (File.separatorChar == '\\') {
            spec = spec.trim();
        }
        boolean isFile = spec.startsWith(FILE_SCHEME);
        try {
            if (isFile) {
                File toAdjust = Main.toFileURL(spec);
                if ((toAdjust = Main.resolveFile(toAdjust)).isDirectory()) {
                    return Main.adjustTrailingSlash(toAdjust.toURL(), trailingSlash);
                }
                return toAdjust.toURL();
            }
            return new URL(spec);
        }
        catch (MalformedURLException e) {
            if (isFile) {
                return null;
            }
            try {
                File toAdjust = new File(spec);
                if (toAdjust.isDirectory()) {
                    return Main.adjustTrailingSlash(toAdjust.toURL(), trailingSlash);
                }
                return toAdjust.toURL();
            }
            catch (MalformedURLException e1) {
                return null;
            }
        }
    }

    private static File toFileURL(String spec) {
        try {
            return new File(new URI(spec));
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            return new File(spec.substring(5));
        }
    }

    private static File resolveFile(File toAdjust) {
        String installArea;
        if (!toAdjust.isAbsolute() && (installArea = System.getProperty(PROP_INSTALL_AREA)) != null) {
            if (installArea.startsWith(FILE_SCHEME)) {
                toAdjust = new File(installArea.substring(5), toAdjust.getPath());
            } else if (new File(installArea).exists()) {
                toAdjust = new File(installArea, toAdjust.getPath());
            }
        }
        return toAdjust;
    }

    private static URL adjustTrailingSlash(URL url, boolean trailingSlash) throws MalformedURLException {
        Object file = url.getFile();
        if (trailingSlash == ((String)file).endsWith("/")) {
            return url;
        }
        file = trailingSlash ? (String)file + "/" : ((String)file).substring(0, ((String)file).length() - 1);
        return new URL(url.getProtocol(), url.getHost(), (String)file);
    }

    private URL buildLocation(String property) {
        URL result = null;
        Object location = System.getProperty(property);
        System.clearProperty(property);
        try {
            if (location == null) {
                return null;
            }
            if (((String)location).equalsIgnoreCase(NONE)) {
                return null;
            }
            if (((String)location).equalsIgnoreCase(NO_DEFAULT)) {
                result = Main.buildURL((String)location, true);
            } else {
                if (((String)location).startsWith(USER_HOME)) {
                    base = this.substituteVar((String)location, USER_HOME, PROP_USER_HOME);
                    location = new File(base).getAbsolutePath();
                } else if (((String)location).startsWith(USER_DIR)) {
                    base = this.substituteVar((String)location, USER_DIR, PROP_USER_DIR);
                    location = new File(base).getAbsolutePath();
                }
                int idx = ((String)location).indexOf(INSTALL_HASH_PLACEHOLDER);
                if (idx == 0) {
                    throw new RuntimeException("The location cannot start with '@install.hash': " + (String)location);
                }
                if (idx > 0) {
                    location = ((String)location).substring(0, idx) + this.getInstallDirHash() + ((String)location).substring(idx + INSTALL_HASH_PLACEHOLDER.length());
                }
                result = Main.buildURL((String)location, true);
            }
        }
        finally {
            if (result != null) {
                System.setProperty(property, result.toExternalForm());
            }
        }
        return result;
    }

    private String substituteVar(String source, String var, String prop) {
        String value = System.getProperty(prop, "");
        return value + source.substring(var.length());
    }

    private String computeDefaultConfigurationLocation() {
        File installDir;
        URL install = this.getInstallLocation();
        if (this.protectBase) {
            return this.computeDefaultUserAreaLocation(CONFIG_DIR);
        }
        if (install.getProtocol().equals("file") && Main.canWrite(installDir = new File(install.getFile()), this.getOS())) {
            return installDir.getAbsolutePath() + File.separator + CONFIG_DIR;
        }
        return this.computeDefaultUserAreaLocation(CONFIG_DIR);
    }

    private static boolean canWrite(File installDir, String os) {
        if (!installDir.isDirectory()) {
            return false;
        }
        if (Files.isWritable(installDir.toPath())) {
            return true;
        }
        File fileTest = null;
        try {
            try {
                fileTest = File.createTempFile("writableArea", ".dll", installDir);
            }
            catch (IOException e) {
                if (fileTest != null) {
                    fileTest.delete();
                }
                return false;
            }
        }
        finally {
            if (fileTest != null) {
                fileTest.delete();
            }
        }
        return true;
    }

    private String computeDefaultUserAreaLocation(String pathAppendage) {
        URL installURL = this.getInstallLocation();
        if (installURL == null) {
            return null;
        }
        File installDir = new File(installURL.getFile());
        String installDirHash = this.getInstallDirHash();
        if (this.protectBase && "macosx".equals(this.getOS())) {
            this.initializeBridgeEarly();
            String macConfiguration = this.computeConfigurationLocationForMacOS();
            if (macConfiguration != null) {
                return macConfiguration;
            }
            if (this.debug) {
                System.out.println("Computation of Mac specific configuration folder failed.");
            }
        }
        Object appName = ".eclipse";
        File eclipseProduct = new File(installDir, PRODUCT_SITE_MARKER);
        if (eclipseProduct.exists()) {
            Properties props = new Properties();
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (FileInputStream inStream = new FileInputStream(eclipseProduct);){
                    String appVersion;
                    props.load(inStream);
                    String appId = props.getProperty(PRODUCT_SITE_ID);
                    if (appId == null || appId.isBlank()) {
                        appId = ECLIPSE;
                    }
                    if ((appVersion = props.getProperty(PRODUCT_SITE_VERSION)) == null || appVersion.isBlank()) {
                        appVersion = "";
                    }
                    appName = (String)appName + File.separator + appId + "_" + appVersion + "_" + installDirHash;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                appName = (String)appName + File.separator + installDirHash;
            }
        } else {
            appName = (String)appName + File.separator + installDirHash;
        }
        appName = (String)appName + "_" + this.OS_WS_ARCHToString();
        String userHome = System.getProperty(PROP_USER_HOME);
        return new File(userHome, (String)appName + "/" + pathAppendage).getAbsolutePath();
    }

    private String computeConfigurationLocationForMacOS() {
        if (this.bridge != null) {
            String folder = this.bridge.getOSRecommendedFolder();
            if (this.debug) {
                System.out.println("App folder provided by MacOS is: " + folder);
            }
            if (folder != null) {
                return folder + "/configuration/";
            }
        }
        return null;
    }

    private String OS_WS_ARCHToString() {
        return this.getOS() + "_" + this.getWS() + "_" + this.getArch();
    }

    private void initializeBridgeEarly() {
        this.setupJNI(null);
    }

    private String getInstallDirHash() {
        int hashCode;
        URL installURL = this.getInstallLocation();
        if (installURL == null) {
            return "";
        }
        File installDir = new File(installURL.getFile());
        try {
            hashCode = installDir.getCanonicalPath().hashCode();
        }
        catch (IOException ioe) {
            hashCode = installDir.getAbsolutePath().hashCode();
        }
        if (hashCode < 0) {
            hashCode = -hashCode;
        }
        return String.valueOf(hashCode);
    }

    public static void main(String argString) {
        Main.main(argString.split(" "));
    }

    public static void main(String[] args) {
        int result = 0;
        try {
            try {
                result = new Main().run(args);
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (!Boolean.getBoolean(PROP_NOSHUTDOWN) || result == 23) {
                    System.exit(result);
                }
            }
        }
        finally {
            if (!Boolean.getBoolean(PROP_NOSHUTDOWN) || result == 23) {
                System.exit(result);
            }
        }
    }

    public int run(String[] args) {
        int result;
        block9: {
            result = 0;
            try {
                try {
                    this.basicRun(args);
                    String exitCode = System.getProperty(PROP_EXITCODE);
                    try {
                        result = exitCode == null ? 0 : Integer.parseInt(exitCode);
                    }
                    catch (NumberFormatException e) {
                        result = 17;
                    }
                }
                catch (Throwable e) {
                    if (!"13".equals(System.getProperty(PROP_EXITCODE))) {
                        this.log("Exception launching the Eclipse Platform:");
                        this.log(e);
                        Object message = "An error has occurred";
                        message = this.logFile == null ? (String)message + " and could not be logged: \n" + e.getMessage() : (String)message + ".  See the log file\n" + this.logFile.getAbsolutePath();
                        System.setProperty(PROP_EXITDATA, (String)message);
                    } else {
                        this.log("Are you trying to start an 64/32-bit Eclipse on a 32/64-JVM? These must be the same, as Eclipse uses native code.");
                    }
                    result = 13;
                    this.takeDownSplash();
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.takeDownSplash();
                throw throwable;
            }
            this.takeDownSplash();
        }
        System.setProperty(PROP_EXITCODE, Integer.toString(result));
        this.setExitData();
        return result;
    }

    private void setExitData() {
        String data = System.getProperty(PROP_EXITDATA);
        if (data == null) {
            return;
        }
        if (this.bridge == null || this.bridge.isLibraryLoadedByJava() && this.exitData == null) {
            System.out.println(data);
        } else {
            this.bridge.setExitData(this.exitData, data);
        }
    }

    private List<String> processCommandLine(List<String> argsList) {
        ArrayDeque<String> args = new ArrayDeque<String>(argsList);
        ArrayList<String> passThrough = new ArrayList<String>();
        while (!args.isEmpty()) {
            boolean processed;
            String key = (String)args.remove();
            if (!key.startsWith("-")) {
                passThrough.add(key);
                continue;
            }
            switch (key.toLowerCase(Locale.ROOT)) {
                case "-debug": {
                    this.debug = true;
                    passThrough.add(key);
                    boolean bl = true;
                    break;
                }
                case "-nosplash": {
                    this.splashDown = true;
                    boolean bl = true;
                    break;
                }
                case "-noexit": {
                    System.setProperty(PROP_NOSHUTDOWN, "true");
                    boolean bl = true;
                    break;
                }
                case "--launcher.overridevmargs": 
                case "--launcher.appendvmargs": {
                    boolean bl = true;
                    break;
                }
                case "-initialize": {
                    this.initialize = true;
                    passThrough.add(key);
                    boolean bl = true;
                    break;
                }
                case "-dev": {
                    this.inDevelopmentMode = true;
                    passThrough.add(key);
                    Main.consumeParameter(args, arg -> {
                        this.devClassPathProps = this.processDevArg((String)arg);
                        if (this.devClassPathProps != null) {
                            this.devClassPath = this.devClassPathProps.getProperty(OSGI);
                            if (this.devClassPath == null) {
                                this.devClassPath = this.devClassPathProps.getProperty("*");
                            }
                        }
                        passThrough.add((String)arg);
                    });
                    boolean bl = true;
                    break;
                }
                case "-showsplash": {
                    this.showSplash = true;
                    Main.consumeParameter(args, arg -> {
                        this.splashLocation = arg;
                    });
                    boolean bl = true;
                    break;
                }
                case "-protect": {
                    String arg2 = (String)args.remove();
                    if (arg2.equals(PROTECT_MASTER) || arg2.equals(PROTECT_BASE)) {
                        this.protectBase = true;
                    }
                    boolean bl = true;
                    break;
                }
                case "-vmargs": {
                    this.vmargs = new ArrayList<String>(args);
                    args.clear();
                    boolean bl = true;
                    break;
                }
                case "-framework": {
                    boolean bl = Main.consumeParameter(args, arg -> {
                        this.framework = arg;
                    });
                    break;
                }
                case "-os": {
                    boolean bl = Main.consumeParameter(args, arg -> {
                        this.os = arg;
                        passThrough.addAll(List.of(key, arg));
                    });
                    break;
                }
                case "-ws": {
                    boolean bl = Main.consumeParameter(args, arg -> {
                        this.ws = arg;
                        passThrough.addAll(List.of(key, arg));
                    });
                    break;
                }
                case "-arch": {
                    boolean bl = Main.consumeParameter(args, arg -> {
                        this.arch = arg;
                        passThrough.addAll(List.of(key, arg));
                    });
                    break;
                }
                case "-install": {
                    boolean bl = Main.consumeParameter(args, arg -> System.setProperty(PROP_INSTALL_AREA, arg));
                    break;
                }
                case "-configuration": {
                    boolean bl = Main.consumeParameter(args, arg -> System.setProperty(PROP_CONFIG_AREA, arg));
                    break;
                }
                case "-exitdata": {
                    boolean bl = Main.consumeParameter(args, arg -> {
                        this.exitData = arg;
                    });
                    break;
                }
                case "-name": {
                    boolean bl = Main.consumeParameter(args, arg -> System.setProperty(PROP_LAUNCHER_NAME, arg));
                    break;
                }
                case "-startup": {
                    boolean bl = Main.consumeParameter(args, arg -> {});
                    break;
                }
                case "-launcher": {
                    boolean bl = Main.consumeParameter(args, arg -> System.setProperty(PROP_LAUNCHER, arg));
                    break;
                }
                case "--launcher.library": {
                    boolean bl = Main.consumeParameter(args, arg -> {
                        this.library = arg;
                    });
                    break;
                }
                case "-endsplash": {
                    boolean bl = Main.consumeParameter(args, arg -> {
                        this.endSplash = arg;
                    });
                    break;
                }
                case "-vm": {
                    boolean bl = Main.consumeParameter(args, arg -> {
                        this.vm = arg;
                    });
                    break;
                }
                case "-nl": {
                    boolean bl = Main.consumeParameter(args, arg -> System.setProperty(PROP_NL, arg));
                    break;
                }
                default: {
                    boolean bl = processed = false;
                }
            }
            if (processed) continue;
            passThrough.add(key);
        }
        return passThrough;
    }

    private static boolean consumeParameter(Queue<String> arguments, Consumer<String> consumer) {
        if (!arguments.isEmpty() && !arguments.peek().startsWith("-")) {
            consumer.accept(arguments.remove());
            return true;
        }
        return false;
    }

    private Properties processDevArg(String arg) {
        if (arg == null) {
            return null;
        }
        try {
            URL location = new URL(arg);
            return this.load(location, null);
        }
        catch (MalformedURLException e) {
            Properties result = new Properties();
            result.put("*", arg);
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }

    private URL getConfigurationLocation() {
        if (this.configurationLocation != null) {
            return this.configurationLocation;
        }
        this.configurationLocation = this.buildLocation(PROP_CONFIG_AREA);
        if (this.configurationLocation == null) {
            this.configurationLocation = this.buildLocation(PROP_CONFIG_AREA_DEFAULT);
            if (this.configurationLocation == null) {
                this.configurationLocation = Main.buildURL(this.computeDefaultConfigurationLocation(), true);
            }
        }
        if (this.configurationLocation != null) {
            System.setProperty(PROP_CONFIG_AREA, this.configurationLocation.toExternalForm());
        }
        if (this.debug) {
            System.out.println("Configuration location:\n    " + String.valueOf(this.configurationLocation));
        }
        return this.configurationLocation;
    }

    private void processConfiguration() {
        Properties configuration;
        URL baseConfigurationLocation = null;
        Properties baseConfiguration = null;
        if (System.getProperty(PROP_CONFIG_AREA) == null) {
            this.ensureAbsolute(PROP_BASE_CONFIG_AREA);
            String baseLocation = System.getProperty(PROP_BASE_CONFIG_AREA);
            if (baseLocation != null) {
                baseConfigurationLocation = Main.buildURL(baseLocation, true);
            }
            if (baseConfigurationLocation == null) {
                try {
                    baseConfigurationLocation = new URL(this.getInstallLocation(), CONFIG_DIR);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if ((baseConfiguration = this.loadConfiguration(baseConfigurationLocation)) != null) {
                String location = baseConfiguration.getProperty(PROP_CONFIG_AREA);
                if (location != null) {
                    System.setProperty(PROP_CONFIG_AREA, location);
                }
                if ((location = baseConfiguration.getProperty(PROP_INSTALL_AREA)) != null && System.getProperty(PROP_INSTALL_AREA) == null) {
                    System.setProperty(PROP_INSTALL_AREA, location);
                }
            }
        }
        if ((configuration = baseConfiguration) == null || !this.getConfigurationLocation().equals(baseConfigurationLocation)) {
            configuration = this.loadConfiguration(this.getConfigurationLocation());
        }
        if (configuration != null && "false".equalsIgnoreCase(configuration.getProperty(PROP_CONFIG_CASCADED))) {
            System.clearProperty(PROP_SHARED_CONFIG_AREA);
            configuration.remove(PROP_SHARED_CONFIG_AREA);
            this.mergeWithSystemProperties(configuration, null);
        } else {
            this.ensureAbsolute(PROP_SHARED_CONFIG_AREA);
            URL sharedConfigURL = this.buildLocation(PROP_SHARED_CONFIG_AREA);
            if (sharedConfigURL == null) {
                try {
                    sharedConfigURL = new URL(this.getInstallLocation(), CONFIG_DIR);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (sharedConfigURL != null) {
                if (sharedConfigURL.equals(this.getConfigurationLocation())) {
                    System.clearProperty(PROP_SHARED_CONFIG_AREA);
                    this.mergeWithSystemProperties(configuration, null);
                } else {
                    Properties sharedConfiguration = baseConfiguration;
                    if (!sharedConfigURL.equals(baseConfigurationLocation)) {
                        sharedConfiguration = this.loadConfiguration(sharedConfigURL);
                    }
                    long sharedConfigTimestamp = this.getCurrentConfigIniBaseTimestamp(sharedConfigURL);
                    long lastKnownBaseTimestamp = this.getLastKnownConfigIniBaseTimestamp();
                    if (this.debug) {
                        System.out.println("Timestamps found: \n\t config.ini in the base: " + sharedConfigTimestamp + "\n\t remembered " + lastKnownBaseTimestamp);
                    }
                    if (lastKnownBaseTimestamp == sharedConfigTimestamp || lastKnownBaseTimestamp == -1L) {
                        this.mergeWithSystemProperties(configuration, null);
                    } else {
                        configuration = null;
                        System.setProperty(PROP_IGNORE_USER_CONFIGURATION, Boolean.TRUE.toString());
                    }
                    this.mergeWithSystemProperties(sharedConfiguration, configuration);
                    System.setProperty(PROP_SHARED_CONFIG_AREA, sharedConfigURL.toExternalForm());
                    if (this.debug) {
                        System.out.println("Shared configuration location:\n    " + sharedConfigURL.toExternalForm());
                    }
                }
            }
        }
        String urlString = System.getProperty(PROP_FRAMEWORK, null);
        if (urlString != null) {
            urlString = this.resolve(urlString);
            this.getInstallLocation();
            URL url = Main.buildURL(urlString, true);
            urlString = url.toExternalForm();
            System.setProperty(PROP_FRAMEWORK, urlString);
            this.bootLocation = urlString;
        }
    }

    private long getCurrentConfigIniBaseTimestamp(URL url) {
        try {
            url = new URL(url, CONFIG_FILE);
        }
        catch (MalformedURLException e1) {
            return -1L;
        }
        URLConnection connection = null;
        try {
            connection = url.openConnection();
        }
        catch (IOException e) {
            return -1L;
        }
        return connection.getLastModified();
    }

    private long getLastKnownConfigIniBaseTimestamp() {
        Properties result;
        if (this.debug) {
            System.out.println("Loading timestamp file from:\n\t " + String.valueOf(this.getConfigurationLocation()) + "   .baseConfigIniTimestamp");
        }
        try {
            result = this.load(this.getConfigurationLocation(), BASE_TIMESTAMP_FILE_CONFIGINI);
        }
        catch (IOException e) {
            if (this.debug) {
                System.out.println("\tNo timestamp file found");
            }
            return -1L;
        }
        String timestamp = result.getProperty(KEY_CONFIGINI_TIMESTAMP);
        return Long.parseLong(timestamp);
    }

    private void ensureAbsolute(String locationProperty) {
        String propertyValue = System.getProperty(locationProperty);
        if (propertyValue == null) {
            return;
        }
        URL locationURL = null;
        try {
            locationURL = new URL(propertyValue);
        }
        catch (MalformedURLException e) {
            return;
        }
        String locationPath = locationURL.getPath();
        if (locationPath.startsWith("/")) {
            return;
        }
        URL installURL = this.getInstallLocation();
        if (!locationURL.getProtocol().equals(installURL.getProtocol())) {
            return;
        }
        try {
            URL absoluteURL = new URL(installURL, locationPath);
            System.setProperty(locationProperty, absoluteURL.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private URL getInstallLocation() {
        if (this.installLocation != null) {
            return this.installLocation;
        }
        String installArea = System.getProperty(PROP_INSTALL_AREA);
        if (installArea != null) {
            if (installArea.startsWith(LAUNCHER_DIR)) {
                String launcher = System.getProperty(PROP_LAUNCHER);
                if (launcher == null) {
                    throw new IllegalStateException("Install location depends on launcher, but launcher is not defined");
                }
                installArea = installArea.replace(LAUNCHER_DIR, new File(launcher).getParent());
            }
            this.installLocation = Main.buildURL(installArea, true);
            if (this.installLocation == null) {
                throw new IllegalStateException("Install location is invalid: " + installArea);
            }
            System.setProperty(PROP_INSTALL_AREA, this.installLocation.toExternalForm());
            if (this.debug) {
                System.out.println("Install location:\n    " + String.valueOf(this.installLocation));
            }
            return this.installLocation;
        }
        ProtectionDomain domain = Main.class.getProtectionDomain();
        CodeSource source = null;
        URL result = null;
        if (domain != null) {
            source = domain.getCodeSource();
        }
        if (source == null || domain == null) {
            if (this.debug) {
                System.out.println("CodeSource location is null. Defaulting the install location to file:startup.jar");
            }
            try {
                result = new URL("file:startup.jar");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (source != null) {
            result = source.getLocation();
        }
        Object path = this.decode(result.getFile());
        File file = new File((String)path);
        path = file.toString().replace('\\', '/');
        if (File.separatorChar == '\\' && Character.isUpperCase(((String)path).charAt(0))) {
            path = Character.toLowerCase(((String)path).charAt(0)) + ((String)path).substring(1);
        }
        if (((String)path).toLowerCase(Locale.ROOT).endsWith(".jar")) {
            path = ((String)path).substring(0, ((String)path).lastIndexOf(47) + 1);
        }
        if (((String)path).toLowerCase(Locale.ROOT).endsWith("/plugins/")) {
            path = ((String)path).substring(0, ((String)path).length() - "/plugins/".length());
        }
        try {
            try {
                path = new File((String)path).toURL().getFile();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            this.installLocation = new URL(result.getProtocol(), result.getHost(), result.getPort(), (String)path);
            System.setProperty(PROP_INSTALL_AREA, this.installLocation.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (this.debug) {
            System.out.println("Install location:\n    " + String.valueOf(this.installLocation));
        }
        return this.installLocation;
    }

    private Properties loadConfiguration(URL url) {
        Properties result;
        block6: {
            result = null;
            try {
                url = new URL(url, CONFIG_FILE);
            }
            catch (MalformedURLException e) {
                return null;
            }
            try {
                if (this.debug) {
                    System.out.print("Configuration file:\n    " + String.valueOf(url));
                }
                result = this.loadProperties(url);
                if (this.debug) {
                    System.out.println(" loaded");
                }
            }
            catch (IOException e) {
                if (!this.debug) break block6;
                System.out.println(" not found or not read");
            }
        }
        return this.substituteVars(result);
    }

    private Properties loadProperties(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        Properties result = null;
        IOException originalException = null;
        try {
            result = this.load(url, null);
        }
        catch (IOException e1) {
            originalException = e1;
            try {
                result = this.load(url, CONFIG_FILE_TEMP_SUFFIX);
            }
            catch (IOException e2) {
                try {
                    result = this.load(url, CONFIG_FILE_BAK_SUFFIX);
                }
                catch (IOException e3) {
                    throw originalException;
                }
            }
        }
        return result;
    }

    private Properties load(URL url, String suffix) throws IOException {
        if (suffix != null && !suffix.equals("")) {
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile() + suffix);
        }
        Properties props = new Properties();
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream is = this.getStream(url);){
            props.load(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return props;
    }

    private InputStream getStream(URL location) throws IOException {
        File f;
        if ("file".equalsIgnoreCase(location.getProtocol()) && (f = new File(location.getPath())).exists()) {
            return new FileInputStream(f);
        }
        return location.openStream();
    }

    private void handleSplash() {
        if (this.initialize || this.splashDown || this.bridge == null) {
            this.showSplash = false;
            this.endSplash = null;
            return;
        }
        if (this.showSplash || this.endSplash != null) {
            try {
                Runtime.getRuntime().addShutdownHook(this.splashHandler);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.endSplash != null) {
            this.showSplash = false;
            return;
        }
        if (!this.showSplash) {
            return;
        }
        this.splashLocation = this.getSplashLocation();
        if (this.debug) {
            System.out.println("Splash location:\n    " + this.splashLocation);
        }
        if (this.splashLocation == null) {
            return;
        }
        this.bridge.setLauncherInfo(System.getProperty(PROP_LAUNCHER), System.getProperty(PROP_LAUNCHER_NAME));
        this.bridge.showSplash(this.splashLocation);
        long handle = this.bridge.getSplashHandle();
        if (handle != 0L && handle != -1L) {
            System.setProperty(SPLASH_HANDLE, String.valueOf(handle));
            System.setProperty(SPLASH_LOCATION, this.splashLocation);
            this.bridge.updateSplash();
        } else {
            this.splashDown = true;
        }
    }

    private void takeDownSplash() {
        if (this.splashDown || this.bridge == null) {
            return;
        }
        this.splashDown = this.bridge.takeDownSplash();
        System.clearProperty(SPLASH_HANDLE);
        try {
            Runtime.getRuntime().removeShutdownHook(this.splashHandler);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getSplashLocation() {
        if (this.splashLocation != null && !Character.isDigit(this.splashLocation.charAt(0)) && new File(this.splashLocation).exists()) {
            System.setProperty(PROP_SPLASHLOCATION, this.splashLocation);
            return this.splashLocation;
        }
        String result = System.getProperty(PROP_SPLASHLOCATION);
        if (result != null) {
            return result;
        }
        String splashPath = System.getProperty(PROP_SPLASHPATH);
        if (splashPath != null) {
            List<String> entries = this.getArrayFromList(splashPath);
            ArrayList<String> paths = new ArrayList<String>(entries.size());
            for (String e : entries) {
                String entry = this.resolve(e);
                if (entry != null && entry.startsWith(FILE_SCHEME)) {
                    File entryFile = new File(entry.substring(5).replace('/', File.separatorChar));
                    if ((entry = this.searchFor(entryFile.getName(), entryFile.getParent())) == null) continue;
                    paths.add(entry);
                    continue;
                }
                this.log("Invalid splash path entry: " + e);
            }
            result = this.searchForSplash(paths);
            if (result != null) {
                System.setProperty(PROP_SPLASHLOCATION, result);
                return result;
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private String searchForSplash(List<String> searchPath) {
        if (searchPath.isEmpty()) {
            return null;
        }
        String locale = System.getProperty(PROP_NL);
        if (locale == null) {
            locale = Locale.getDefault().toString();
        }
        List<String> nlVariants = Main.buildNLVariants(locale);
        for (String nlVariant : nlVariants) {
            for (String string : searchPath) {
                void var6_11;
                String string2;
                Object result;
                void var6_9;
                if (string.startsWith(FILE_SCHEME)) {
                    String string3 = string.substring(5);
                }
                if (this.isJAR((String)var6_9)) {
                    result = this.extractFromJAR((String)var6_9, nlVariant);
                    if (result == null) continue;
                    return result;
                }
                if (!var6_9.endsWith(File.separator)) {
                    String string4 = (String)var6_9 + File.separator;
                }
                if (!((File)(result = new File(string2 = (String)var6_11 + nlVariant))).exists()) continue;
                return ((File)result).getAbsolutePath();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String extractFromJAR(String jarPath, String jarEntry) {
        String configLocation = System.getProperty(PROP_CONFIG_AREA);
        if (configLocation == null) {
            this.log("Configuration area not set yet. Unable to extract " + jarEntry + " from JAR'd plug-in: " + jarPath);
            return null;
        }
        URL configURL = Main.buildURL(configLocation, false);
        if (configURL == null) {
            return null;
        }
        File splash = new File(configURL.getPath(), PLUGIN_ID);
        File jarFile = new File(jarPath);
        String cache = jarFile.getName();
        if (cache.endsWith(".jar")) {
            cache = cache.substring(0, cache.length() - 4);
        }
        splash = new File(splash, cache);
        if ((splash = new File(splash, jarEntry)).exists()) {
            boolean clean = this.commands.stream().anyMatch(CLEAN::equalsIgnoreCase);
            if (!clean) return splash.getAbsolutePath();
            splash.delete();
        }
        try {
            Throwable clean = null;
            Object var9_12 = null;
            try (ZipFile file = new ZipFile(jarPath);){
                String string;
                ZipEntry entry = file.getEntry(jarEntry.replace(File.separatorChar, '/'));
                if (entry == null) {
                    return null;
                }
                Path outputFile = splash.toPath();
                Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
                try {
                    Throwable throwable = null;
                    Object var14_20 = null;
                    try (InputStream input = file.getInputStream(entry);){
                        Files.copy(input, outputFile, new CopyOption[0]);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.log("Exception opening splash: " + entry.getName() + " in JAR file: " + jarPath);
                    this.log(e);
                    if (file == null) return null;
                    file.close();
                    return null;
                }
                if (splash.exists()) {
                    string = splash.getAbsolutePath();
                    return string;
                }
                string = null;
                return string;
            }
            catch (Throwable throwable) {
                if (clean == null) {
                    clean = throwable;
                    throw clean;
                }
                if (clean == throwable) throw clean;
                clean.addSuppressed(throwable);
                throw clean;
            }
        }
        catch (IOException e) {
            this.log("Exception looking for " + jarEntry + " in JAR file: " + jarPath);
            this.log(e);
            return null;
        }
    }

    private boolean isJAR(String path) {
        return new File(path).isFile();
    }

    private static List<String> buildNLVariants(String locale) {
        String name;
        int n;
        int n2;
        String[] stringArray;
        String nl = locale;
        ArrayList<String> result = new ArrayList<String>(4);
        while (true) {
            stringArray = SPLASH_IMAGES;
            n2 = SPLASH_IMAGES.length;
            n = 0;
            while (n < n2) {
                name = stringArray[n];
                result.add("nl" + File.separatorChar + nl.replace('_', File.separatorChar) + File.separatorChar + name);
                ++n;
            }
            int lastSeparator = nl.lastIndexOf(95);
            if (lastSeparator == -1) break;
            nl = nl.substring(0, lastSeparator);
        }
        stringArray = SPLASH_IMAGES;
        n2 = SPLASH_IMAGES.length;
        n = 0;
        while (n < n2) {
            name = stringArray[n];
            result.add(name);
            ++n;
        }
        return result;
    }

    private String resolve(String urlString) {
        if (urlString.startsWith(REFERENCE_SCHEME)) {
            urlString = urlString.substring(10);
        }
        if (urlString.startsWith(PLATFORM_URL)) {
            String path = urlString.substring(PLATFORM_URL.length());
            return String.valueOf(this.getInstallLocation()) + path;
        }
        return urlString;
    }

    private synchronized void log(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            try {
                this.openLogFile();
                try {
                    if (this.newSession) {
                        this.log.write(SESSION);
                        this.log.write(32);
                        String timestamp = new Date().toString();
                        this.log.write(timestamp);
                        this.log.write(32);
                        int i = SESSION.length() + timestamp.length();
                        while (i < 78) {
                            this.log.write(45);
                            ++i;
                        }
                        this.log.newLine();
                        this.newSession = false;
                    }
                    this.write(obj);
                }
                finally {
                    if (this.logFile == null) {
                        if (this.log != null) {
                            this.log.flush();
                        }
                    } else {
                        this.closeLogFile();
                    }
                }
            }
            catch (Exception e) {
                System.err.println("An exception occurred while writing to the platform log:");
                e.printStackTrace(System.err);
                System.err.println("Logging to the console instead.");
                try {
                    this.log = this.logForStream(System.err);
                    this.write(obj);
                    this.log.flush();
                }
                catch (Exception e2) {
                    System.err.println("An exception occurred while logging to the console:");
                    e2.printStackTrace(System.err);
                }
                this.log = null;
            }
        }
        finally {
            this.log = null;
        }
    }

    private void write(Object obj) throws IOException {
        if (obj == null) {
            return;
        }
        if (obj instanceof Throwable) {
            Throwable throwable = (Throwable)obj;
            this.log.write(STACK);
            this.log.newLine();
            throwable.printStackTrace(new PrintWriter(this.log));
        } else {
            this.log.write(ENTRY);
            this.log.write(32);
            this.log.write(PLUGIN_ID);
            this.log.write(32);
            this.log.write(String.valueOf(4));
            this.log.write(32);
            this.log.write(String.valueOf(0));
            this.log.write(32);
            this.log.write(this.getDate(new Date()));
            this.log.newLine();
            this.log.write(MESSAGE);
            this.log.write(32);
            this.log.write(String.valueOf(obj));
        }
        this.log.newLine();
    }

    private String getDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        StringBuilder sb = new StringBuilder();
        this.appendPaddedInt(c.get(1), 4, sb).append('-');
        this.appendPaddedInt(c.get(2) + 1, 2, sb).append('-');
        this.appendPaddedInt(c.get(5), 2, sb).append(' ');
        this.appendPaddedInt(c.get(11), 2, sb).append(':');
        this.appendPaddedInt(c.get(12), 2, sb).append(':');
        this.appendPaddedInt(c.get(13), 2, sb).append('.');
        this.appendPaddedInt(c.get(14), 3, sb);
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    private StringBuilder appendPaddedInt(int value, int pad, StringBuilder buffer) {
        if (--pad == 0) {
            return buffer.append(value);
        }
        padding = (int)Math.pow(10.0, pad);
        if (value < padding) ** GOTO lbl9
        return buffer.append(value);
lbl-1000:
        // 1 sources

        {
            buffer.append('0');
            padding /= 10;
lbl9:
            // 2 sources

            ** while (padding > value && padding > 1)
        }
lbl10:
        // 1 sources

        buffer.append(value);
        return buffer;
    }

    private void computeLogFileLocation() {
        String logFileProp = System.getProperty(PROP_LOGFILE);
        if (logFileProp != null) {
            if (this.logFile == null || !logFileProp.equals(this.logFile.getAbsolutePath())) {
                this.logFile = new File(logFileProp);
                new File(this.logFile.getParent()).mkdirs();
            }
            return;
        }
        URL base = Main.buildURL(System.getProperty(PROP_CONFIG_AREA), false);
        if (base == null) {
            return;
        }
        this.logFile = new File(base.getPath(), System.currentTimeMillis() + ".log");
        new File(this.logFile.getParent()).mkdirs();
        System.setProperty(PROP_LOGFILE, this.logFile.getAbsolutePath());
    }

    private void openLogFile() throws IOException {
        this.computeLogFileLocation();
        try {
            this.log = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile.getAbsolutePath(), true), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            this.logFile = null;
            throw e;
        }
    }

    private BufferedWriter logForStream(OutputStream output) {
        return new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
    }

    private void closeLogFile() throws IOException {
        try {
            if (this.log != null) {
                this.log.flush();
                this.log.close();
            }
        }
        finally {
            this.log = null;
        }
    }

    private void mergeWithSystemProperties(Properties source, Properties userConfiguration) {
        String EXT_OVERRIDE_USER = ".override.user";
        if (source == null) {
            return;
        }
        Enumeration<Object> e = source.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.equals(PROP_CLASSPATH)) {
                Object destinationClasspath = System.getProperty(PROP_CLASSPATH);
                String sourceClasspath = source.getProperty(PROP_CLASSPATH);
                destinationClasspath = destinationClasspath == null ? sourceClasspath : (String)destinationClasspath + sourceClasspath;
                System.setProperty(PROP_CLASSPATH, (String)destinationClasspath);
                continue;
            }
            String value = source.getProperty(key);
            if (userConfiguration != null && !key.endsWith(".override.user")) {
                boolean shouldOverride;
                String overrideKey = key + ".override.user";
                boolean bl = shouldOverride = System.getProperty(overrideKey) != null || source.getProperty(overrideKey) != null;
                if (shouldOverride && !userConfiguration.contains(key)) {
                    System.setProperty(key, value);
                    continue;
                }
            }
            if (System.getProperty(key) != null) continue;
            System.setProperty(key, value);
        }
    }

    private void setupVMProperties() {
        if (this.vm != null) {
            System.setProperty(PROP_VM, this.vm);
        }
        this.setMultiValueProperty(PROP_VMARGS, this.vmargs);
        this.setMultiValueProperty(PROP_COMMANDS, this.commands);
    }

    private void setMultiValueProperty(String property, List<String> values) {
        if (values != null) {
            StringBuilder result = new StringBuilder(300);
            for (String value : values) {
                if (value == null) continue;
                result.append(value);
                result.append('\n');
            }
            System.setProperty(property, result.toString());
        }
    }

    private Properties substituteVars(Properties result) {
        if (result == null) {
            return null;
        }
        Enumeration<Object> eKeys = result.keys();
        while (eKeys.hasMoreElements()) {
            String key;
            String value;
            Object object = eKeys.nextElement();
            if (!(object instanceof String) || (value = result.getProperty(key = (String)object)) == null) continue;
            result.put(key, Main.substituteVars(value));
        }
        return result;
    }

    private static String substituteVars(String path) {
        StringBuilder buf = new StringBuilder(path.length());
        StringTokenizer st = new StringTokenizer(path, VARIABLE_DELIM_STRING, true);
        boolean varStarted = false;
        String var = null;
        while (st.hasMoreElements()) {
            String tok = st.nextToken();
            if (VARIABLE_DELIM_STRING.equals(tok)) {
                if (!varStarted) {
                    varStarted = true;
                    var = "";
                    continue;
                }
                String prop = null;
                if (var != null && !var.isEmpty()) {
                    prop = System.getProperty(var);
                }
                if (prop == null) {
                    prop = System.getenv(var);
                }
                if (prop != null) {
                    buf.append(prop);
                } else {
                    buf.append('$');
                    buf.append(var == null ? "" : var);
                    buf.append('$');
                }
                varStarted = false;
                var = null;
                continue;
            }
            if (!varStarted) {
                buf.append(tok);
                continue;
            }
            var = tok;
        }
        if (var != null) {
            buf.append('$').append(var);
        }
        return buf.toString();
    }

    private class EclipsePolicy
    extends Policy {
        private Policy policy;
        private List<URL> urls;
        private PermissionCollection allPermissions;
        Permission allPermission = new AllPermission();

        EclipsePolicy(Policy policy, List<URL> urls) {
            this.policy = policy;
            this.urls = urls;
            this.allPermissions = new PermissionCollection(){
                private static final long serialVersionUID = 3258131349494708277L;

                @Override
                public void add(Permission permission) {
                }

                @Override
                public boolean implies(Permission permission) {
                    return true;
                }

                @Override
                public Enumeration<Permission> elements() {
                    return Collections.enumeration(Collections.singleton(EclipsePolicy.this.allPermission));
                }
            };
        }

        @Override
        public PermissionCollection getPermissions(CodeSource codesource) {
            if (this.contains(codesource)) {
                return this.allPermissions;
            }
            return this.policy == null ? this.allPermissions : this.policy.getPermissions(codesource);
        }

        @Override
        public PermissionCollection getPermissions(ProtectionDomain domain) {
            if (this.contains(domain.getCodeSource())) {
                return this.allPermissions;
            }
            return this.policy == null ? this.allPermissions : this.policy.getPermissions(domain);
        }

        @Override
        public boolean implies(ProtectionDomain domain, Permission permission) {
            if (this.contains(domain.getCodeSource())) {
                return true;
            }
            return this.policy == null ? true : this.policy.implies(domain, permission);
        }

        @Override
        public void refresh() {
            if (this.policy != null) {
                this.policy.refresh();
            }
        }

        private boolean contains(CodeSource codeSource) {
            if (codeSource == null) {
                return false;
            }
            URL location = codeSource.getLocation();
            if (location == null) {
                return false;
            }
            for (URL url : this.urls) {
                if (url != location) continue;
                return true;
            }
            return false;
        }
    }

    private record Identifier(int major, int minor, int service, String qualifier) {
        private static final Comparator<Identifier> MAIN_VERSION = Comparator.comparingInt(Identifier::major).thenComparingInt(Identifier::minor).thenComparingInt(Identifier::service);
        private static final Comparator<Identifier> FULL_VERSION = MAIN_VERSION.thenComparing(Identifier::qualifier);

        static Identifier create(String versionString, String delimiter) {
            StringTokenizer tokenizer = new StringTokenizer(versionString, delimiter);
            int major = 0;
            int minor = 0;
            int service = 0;
            String qualifier = "";
            if (tokenizer.hasMoreTokens()) {
                major = Integer.parseInt(tokenizer.nextToken());
            }
            try {
                if (tokenizer.hasMoreTokens()) {
                    minor = Integer.parseInt(tokenizer.nextToken());
                }
                if (tokenizer.hasMoreTokens()) {
                    service = Integer.parseInt(tokenizer.nextToken());
                }
                if (tokenizer.hasMoreTokens()) {
                    qualifier = tokenizer.nextToken();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new Identifier(major, minor, service, qualifier);
        }
    }

    public final class SplashHandler
    extends Thread {
        @Override
        public void run() {
            Main.this.takeDownSplash();
        }

        public void updateSplash() {
            if (Main.this.bridge != null && !Main.this.splashDown) {
                Main.this.bridge.updateSplash();
            }
        }
    }

    public class StartupClassLoader
    extends URLClassLoader {
        public StartupClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        protected String findLibrary(String name) {
            if (Main.this.extensionPaths == null) {
                return super.findLibrary(name);
            }
            String libName = System.mapLibraryName(name);
            for (String extensionPath : Main.this.extensionPaths) {
                File libFile = new File(extensionPath, libName);
                if (!libFile.isFile()) continue;
                return libFile.getAbsolutePath();
            }
            return super.findLibrary(name);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        @Override
        protected URL findResource(String moduleName, String name) {
            return this.findResource(name);
        }

        @Override
        protected Class<?> findClass(String moduleName, String name) {
            try {
                return this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }
}

