/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.wizard;

import java.time.Duration;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskImpl;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class EditTaskConfigurationDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.EditTaskConfigurationDialog";
    private TaskImpl task;
    private final DBPProject project;
    private final DBTTaskType taskType;
    private final Map<String, Object> state;
    private final Duration maxExecutionTime;
    private Combo taskLabelCombo;
    private Text taskDescriptionText;
    private Combo taskFoldersCombo;

    public EditTaskConfigurationDialog(@NotNull Shell parentShell, @NotNull DBTTask task) {
        super(parentShell, NLS.bind((String)"%s [%s]", (Object)TaskUIMessages.edit_task_config_dialog_title_edit_task, (Object)task.getName()), (DBPImage)Objects.requireNonNullElse(task.getType().getIcon(), DBIcon.TREE_TASK));
        this.task = (TaskImpl)task;
        this.project = task.getProject();
        this.taskType = task.getType();
        this.state = task.getProperties();
        this.maxExecutionTime = task.getMaxExecutionTime();
    }

    public EditTaskConfigurationDialog(@NotNull Shell parentShell, @NotNull DBPProject project, @NotNull DBTTaskType taskType, @NotNull Duration maxExecutionTime) {
        super(parentShell, TaskUIMessages.edit_task_config_dialog_title_create_task, (DBPImage)DBIcon.TREE_TASK);
        this.task = null;
        this.project = project;
        this.taskType = taskType;
        this.state = new LinkedHashMap<String, Object>();
        this.maxExecutionTime = maxExecutionTime;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        composite.setLayoutData((Object)new GridData(1808));
        Composite formPanel = UIUtils.createComposite((Composite)composite, (int)2);
        formPanel.setLayoutData((Object)new GridData(1808));
        ModifyListener modifyListener = e -> this.updateButtons();
        UIUtils.createLabelText((Composite)formPanel, (String)TaskUIMessages.edit_task_config_dialog_label_type, (String)(this.taskType.getCategory().getName() + " / " + this.taskType.getName()), (int)2056);
        boolean taskSaved = this.task != null && !CommonUtils.isEmpty((String)this.task.getId());
        this.taskLabelCombo = UIUtils.createLabelCombo((Composite)formPanel, (String)TaskUIMessages.edit_task_config_dialog_label_name, (String)"", (int)(0x800 | (taskSaved ? 8 : 0)));
        ((GridData)this.taskLabelCombo.getLayoutData()).widthHint = 300;
        if (this.task != null) {
            this.taskLabelCombo.setText(this.task.getName());
        } else {
            DBTTask[] allTasks;
            this.taskLabelCombo.add("");
            DBTTaskManager taskManager = this.project.getTaskManager();
            DBTTask[] dBTTaskArray = allTasks = taskManager.getAllTaskByType(this.taskType);
            int n = allTasks.length;
            int n2 = 0;
            while (n2 < n) {
                DBTTask tc = dBTTaskArray[n2];
                this.taskLabelCombo.add(tc.getName());
                ++n2;
            }
            UIUtils.createControlLabel((Composite)formPanel, (String)TaskUIMessages.edit_task_config_dialog_task_folders_label_name);
            this.taskFoldersCombo = new Combo(formPanel, 12);
            this.taskFoldersCombo.setLayoutData((Object)new GridData(768));
            Object[] tasksFolders = taskManager.getTasksFolders();
            if (!ArrayUtils.isEmpty((Object[])tasksFolders)) {
                this.taskFoldersCombo.add("");
                Object[] objectArray = tasksFolders;
                int n3 = tasksFolders.length;
                n = 0;
                while (n < n3) {
                    Object taskFolder = objectArray[n];
                    this.taskFoldersCombo.add(taskFolder.getName());
                    ++n;
                }
            }
        }
        this.taskLabelCombo.addModifyListener(modifyListener);
        if (taskSaved) {
            this.taskLabelCombo.setEnabled(false);
        }
        this.taskDescriptionText = UIUtils.createLabelText((Composite)formPanel, (String)TaskUIMessages.edit_task_config_dialog_label_descr, (String)(this.task == null ? "" : CommonUtils.notEmpty((String)this.task.getDescription())), (int)2562);
        ((GridData)this.taskDescriptionText.getLayoutData()).heightHint = this.taskDescriptionText.getLineHeight() * 5;
        this.taskDescriptionText.addModifyListener(modifyListener);
        UIUtils.asyncExec(() -> {
            boolean bl = this.taskLabelCombo.setFocus();
        });
        return composite;
    }

    private boolean isTaskEditor() {
        return this.task != null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateButtons();
    }

    private void updateButtons() {
        boolean isReady = !this.taskLabelCombo.getText().isEmpty();
        this.getButton(0).setEnabled(isReady);
    }

    protected void okPressed() {
        DBTTaskManager taskManager = this.project.getTaskManager();
        try {
            if (this.task == null) {
                this.task = (TaskImpl)taskManager.createTask(this.taskType, this.taskLabelCombo.getText(), this.taskDescriptionText.getText(), this.taskFoldersCombo.getText(), this.state);
            }
            this.task.setName(this.taskLabelCombo.getText());
            this.task.setDescription(this.taskDescriptionText.getText());
            this.task.setUpdateTime(new Date());
            this.task.setProperties(this.state);
            this.task.setMaxExecutionTime(this.maxExecutionTime);
            taskManager.updateTaskConfiguration((DBTTask)this.task);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Create task", "Error creating data transfer task", (Throwable)e);
            return;
        }
        super.okPressed();
    }

    public DBTTask getTask() {
        return this.task;
    }
}

