/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.internal.texteditor.EditPosition;
import org.eclipse.ui.internal.texteditor.HistoryTracker;
import org.eclipse.ui.internal.texteditor.codemining.CodeMiningProviderRegistry;
import org.eclipse.ui.internal.texteditor.quickdiff.QuickDiffExtensionsRegistry;
import org.eclipse.ui.internal.texteditor.spelling.SpellingEngineRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public final class TextEditorPlugin
extends AbstractUIPlugin
implements IRegistryChangeListener {
    public static final int EDIT_LOCATION_HISTORY_SIZE = 15;
    private static TextEditorPlugin fgPlugin;
    TraversalDirection fEditHistoryTraversalDirection = TraversalDirection.NONE;
    private HistoryTracker<EditPosition> fEditPositionHistory = new HistoryTracker<EditPosition>(15, EditPosition.class, (a, b) -> b.getPosition().isDeleted || b.getPosition().isDeleted || EditPosition.areCoLocated(a, b), false);
    private Set<IAction> fEditPositionDependentActions;
    private QuickDiffExtensionsRegistry fQuickDiffExtensionRegistry;
    private SpellingEngineRegistry fSpellingEngineRegistry;
    private CodeMiningProviderRegistry fCodeMiningProviderRegistry;
    public static final String PLUGIN_ID = "org.eclipse.ui.workbench.texteditor";
    public static final String REFERENCE_PROVIDER_EXTENSION_POINT = "quickDiffReferenceProvider";

    public TextEditorPlugin() {
        Assert.isTrue((fgPlugin == null ? 1 : 0) != 0);
        fgPlugin = this;
    }

    public static TextEditorPlugin getDefault() {
        return fgPlugin;
    }

    public TraversalDirection getEditHistoryTraversalDirection() {
        return this.fEditHistoryTraversalDirection;
    }

    public void setEditHistoryTraversalDirection(TraversalDirection direction) {
        this.fEditHistoryTraversalDirection = direction;
    }

    public HistoryTracker<EditPosition> getEditPositionHistory() {
        return this.fEditPositionHistory;
    }

    public void setEditPositionHistory(HistoryTracker<EditPosition> editPositionHistory) {
        this.fEditPositionHistory = editPositionHistory;
    }

    public EditPosition getLastEditPosition() {
        return this.fEditPositionHistory.getCurrentBrowsePoint();
    }

    public EditPosition getNextEditPosition() {
        return this.fEditPositionHistory.getNext();
    }

    public EditPosition backtrackEditPosition() {
        return this.fEditPositionHistory.browseBackward();
    }

    public EditPosition advanceEditPosition() {
        return this.fEditPositionHistory.browseForward();
    }

    public void enableLastEditPositionDependentActions() {
        EditPosition last = this.fEditPositionHistory.getCurrentBrowsePoint();
        if (last != null && this.getDependentActions() != null) {
            Iterator<IAction> iter = this.getDependentActions().iterator();
            while (iter.hasNext()) {
                iter.next().setEnabled(true);
            }
            this.setDependentActions(null);
        }
    }

    public void addLastEditPositionDependentAction(IAction action) {
        if (!this.fEditPositionHistory.isEmpty()) {
            return;
        }
        this.addDependentAction(action);
    }

    public void removeLastEditPositionDependentAction(IAction action) {
        if (!this.fEditPositionHistory.isEmpty()) {
            return;
        }
        this.removeDependentAction(action);
    }

    private Set<IAction> getDependentActions() {
        return this.fEditPositionDependentActions;
    }

    private void setDependentActions(Set<IAction> actions) {
        this.fEditPositionDependentActions = actions;
    }

    public void addDependentAction(IAction action) {
        if (this.getDependentActions() == null) {
            this.setDependentActions(new HashSet<IAction>());
        }
        this.getDependentActions().add(action);
    }

    public void removeDependentAction(IAction action) {
        if (this.getDependentActions() != null) {
            this.getDependentActions().remove(action);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fQuickDiffExtensionRegistry = new QuickDiffExtensionsRegistry();
        this.fSpellingEngineRegistry = new SpellingEngineRegistry();
        this.fCodeMiningProviderRegistry = new CodeMiningProviderRegistry();
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this, PLUGIN_ID);
    }

    public void stop(BundleContext context) throws Exception {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
        this.fQuickDiffExtensionRegistry = null;
        this.fSpellingEngineRegistry = null;
        this.fCodeMiningProviderRegistry = null;
        super.stop(context);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        if (this.fQuickDiffExtensionRegistry != null && event.getExtensionDeltas(PLUGIN_ID, REFERENCE_PROVIDER_EXTENSION_POINT).length > 0) {
            this.fQuickDiffExtensionRegistry.reloadExtensions();
        }
        if (this.fSpellingEngineRegistry != null && event.getExtensionDeltas(PLUGIN_ID, "spellingEngine").length > 0) {
            this.fSpellingEngineRegistry.reloadExtensions();
        }
        if (this.fCodeMiningProviderRegistry != null && event.getExtensionDeltas(PLUGIN_ID, "codeMiningProviders").length > 0) {
            this.fCodeMiningProviderRegistry.reloadExtensions();
        }
    }

    public QuickDiffExtensionsRegistry getQuickDiffExtensionRegistry() {
        return this.fQuickDiffExtensionRegistry;
    }

    public SpellingEngineRegistry getSpellingEngineRegistry() {
        return this.fSpellingEngineRegistry;
    }

    public CodeMiningProviderRegistry getCodeMiningProviderRegistry() {
        return this.fCodeMiningProviderRegistry;
    }

    public static enum TraversalDirection {
        NONE,
        BACKWARD,
        FORWARD;

    }
}

