/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.syntaxpane;

import de.sciss.syntaxpane.SyntaxDocument;
import de.sciss.syntaxpane.SyntaxStyle;
import de.sciss.syntaxpane.SyntaxStyles;
import de.sciss.syntaxpane.Token;
import de.sciss.syntaxpane.TokenType;
import de.sciss.syntaxpane.util.Configuration;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.WrappedPlainView;

public class WrappedSyntaxView
extends WrappedPlainView {
    public static final String PROPERTY_RIGHT_MARGIN_COLOR = "RightMarginColor";
    public static final String PROPERTY_RIGHT_MARGIN_COLUMN = "RightMarginColumn";
    public static final String PROPERTY_SINGLE_COLOR_SELECT = "SingleColorSelect";
    private static final Logger log = Logger.getLogger(WrappedSyntaxView.class.getName());
    private boolean singleColorSelect;
    private int rightMarginColumn;
    private Color rightMarginColor;
    private SyntaxStyles styles;
    private SyntaxStyle defaultStyle;
    private static RenderingHints sysHints = null;

    public WrappedSyntaxView(Element element, Configuration config) {
        super(element, true);
        this.configure(config);
    }

    public void reconfigure(Configuration config) {
        this.configure(config);
    }

    private void configure(Configuration config) {
        this.singleColorSelect = config.getBoolean(PROPERTY_SINGLE_COLOR_SELECT, false);
        this.rightMarginColor = new Color(config.getInteger(PROPERTY_RIGHT_MARGIN_COLOR, 0xFF7777));
        this.rightMarginColumn = config.getInteger(PROPERTY_RIGHT_MARGIN_COLUMN, 0);
        this.styles = SyntaxStyles.read(config);
        this.defaultStyle = this.styles.getStyle(TokenType.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int drawUnselectedText(Graphics graphics, int x, int y, int p0, int p1) {
        WrappedSyntaxView.setRenderingHits((Graphics2D)graphics);
        Font saveFont = graphics.getFont();
        Color saveColor = graphics.getColor();
        SyntaxDocument doc = (SyntaxDocument)this.getDocument();
        Segment segment = this.getLineBuffer();
        if (this.rightMarginColumn > 0) {
            int m_x = this.rightMarginColumn * graphics.getFontMetrics().charWidth('m');
            int h = graphics.getFontMetrics().getHeight();
            graphics.setColor(this.rightMarginColor);
            graphics.drawLine(m_x, y, m_x, y - h);
        }
        try {
            Iterator<Token> i = doc.getTokens(p0, p1);
            int start = p0;
            while (i.hasNext()) {
                Token t = i.next();
                if (start < t.start) {
                    doc.getText(start, t.start - start, segment);
                    x = this.defaultStyle.drawText(segment, x, y, graphics, this, start);
                }
                int l = t.length;
                int s = t.start;
                if (s < p0) {
                    l -= p0 - s;
                    s = p0;
                }
                if (s + l > p1) {
                    l = p1 - s;
                }
                doc.getText(s, l, segment);
                x = this.styles.drawText(segment, x, y, graphics, this, t);
                start = t.end();
            }
            if (start < p1) {
                doc.getText(start, p1 - start, segment);
                x = this.defaultStyle.drawText(segment, x, y, graphics, this, start);
            }
        }
        catch (BadLocationException ex) {
            log.log(Level.SEVERE, "Requested: " + ex.offsetRequested(), ex);
        }
        finally {
            graphics.setFont(saveFont);
            graphics.setColor(saveColor);
        }
        return x;
    }

    @Override
    protected int drawSelectedText(Graphics graphics, int x, int y, int p0, int p1) throws BadLocationException {
        if (this.singleColorSelect) {
            if (this.rightMarginColumn > 0) {
                int m_x = this.rightMarginColumn * graphics.getFontMetrics().charWidth('m');
                int h = graphics.getFontMetrics().getHeight();
                graphics.setColor(this.rightMarginColor);
                graphics.drawLine(m_x, y, m_x, y - h);
            }
            return super.drawSelectedText(graphics, x, y, p0, p1);
        }
        return this.drawUnselectedText(graphics, x, y, p0, p1);
    }

    public static void setRenderingHits(Graphics2D g2d) {
        g2d.addRenderingHints(sysHints);
    }

    static {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Map map = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
            sysHints = new RenderingHints(map);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

