/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.add;

import docking.wizard.WizardModel;
import docking.wizard.WizardStep;
import ghidra.feature.vt.api.main.VTProgramCorrelatorFactory;
import ghidra.feature.vt.gui.wizard.add.AddToSessionData;
import ghidra.feature.vt.gui.wizard.session.SummaryPanel;
import ghidra.framework.model.DomainFile;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import java.util.List;
import javax.swing.JComponent;

public class SummaryStep
extends WizardStep<AddToSessionData> {
    private SummaryPanel summaryPanel = new SummaryPanel();

    protected SummaryStep(WizardModel<AddToSessionData> model) {
        super(model, "Summary", new HelpLocation("VersionTrackingPlugin", "New_Session_Summary_Panel"));
    }

    public void initialize(AddToSessionData data) {
        String sourceAddressesInfo;
        StringBuilder label = new StringBuilder();
        StringBuilder summary = new StringBuilder();
        label.append("<html>");
        summary.append("<html>");
        label.append("Operation:");
        summary.append("Add to Version Tracking Session");
        label.append("<br>");
        summary.append("<br>");
        String sessionName = data.getSession().getName();
        label.append("Session Name:");
        summary.append(sessionName);
        label.append("<br>");
        summary.append("<br>");
        String sourceProgramName = null;
        String destinationProgramName = null;
        DomainFile sourceProgram = data.getSourceFile();
        sourceProgramName = sourceProgram.getName();
        DomainFile destinationProgram = data.getDestinationFile();
        destinationProgramName = destinationProgram.getName();
        label.append("Source Program:");
        summary.append(HTMLUtilities.escapeHTML((String)sourceProgramName));
        label.append("<br>");
        summary.append("<br>");
        label.append("Destination Program:");
        summary.append(HTMLUtilities.escapeHTML((String)destinationProgramName));
        label.append("<br>");
        summary.append("<br>");
        String correlatorLabel = "";
        String correlatorName = null;
        List<VTProgramCorrelatorFactory> correlators = data.getCorrelators();
        for (VTProgramCorrelatorFactory correlatorFactory : correlators) {
            correlatorName = correlatorFactory.getName();
            label.append(correlatorLabel + "Program Correlator:");
            summary.append(correlatorName == null ? "(null)" : correlatorName);
            label.append("<br>");
            summary.append("<br>");
        }
        boolean excludeAcceptedMatches = data.shouldExcludeAcceptedMatches();
        label.append("Exclude Accepted Matches:");
        summary.append(excludeAcceptedMatches ? "Yes" : "No");
        label.append("<br>");
        summary.append("<br>");
        AddToSessionData.AddressSetChoice sourceAddressSetChoice = data.getSourceAddressSetChoice();
        AddToSessionData.AddressSetChoice destinationAddressSetChoice = data.getDestinationAddressSetChoice();
        String string = sourceAddressSetChoice == AddToSessionData.AddressSetChoice.MANUALLY_DEFINED ? "Manually Defined" : (sourceAddressesInfo = sourceAddressSetChoice == AddToSessionData.AddressSetChoice.SELECTION ? "Source Tool Selection" : "Entire Source Program");
        String destinationAddressesInfo = destinationAddressSetChoice == AddToSessionData.AddressSetChoice.MANUALLY_DEFINED ? "Manually Defined" : (destinationAddressSetChoice == AddToSessionData.AddressSetChoice.SELECTION ? "Destination Tool Selection" : "Entire Destination Program");
        label.append("Source Address Set:");
        summary.append(sourceAddressesInfo);
        label.append("<br>");
        summary.append("<br>");
        label.append("Destination Address Set:");
        summary.append(destinationAddressesInfo);
        label.append("<br>");
        summary.append("<br>");
        label.append("</html>");
        summary.append("</html>");
        this.summaryPanel.initialize(label.toString(), summary.toString());
    }

    public boolean isValid() {
        return true;
    }

    public boolean canFinish(AddToSessionData data) {
        return true;
    }

    public boolean apply(AddToSessionData data) {
        return true;
    }

    public void populateData(AddToSessionData data) {
    }

    public JComponent getComponent() {
        return this.summaryPanel;
    }
}

