/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.grammars;

import ghidra.app.plugin.assembler.sleigh.grammars.AbstractAssemblyProduction;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammarException;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblySentential;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNonTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyTerminal;
import ghidra.generic.util.datastruct.TreeSetValuedTreeMap;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.MultiValuedMap;

public abstract class AbstractAssemblyGrammar<NT extends AssemblyNonTerminal, P extends AbstractAssemblyProduction<NT>>
implements Iterable<P> {
    protected final MultiValuedMap<String, P> productions = new TreeSetValuedTreeMap();
    protected final List<P> prodList = new ArrayList<P>();
    protected final Map<String, NT> nonterminals = new TreeMap<String, NT>();
    protected final Map<String, AssemblyTerminal> terminals = new TreeMap<String, AssemblyTerminal>();
    protected final Map<String, AssemblySymbol> symbols = new TreeMap<String, AssemblySymbol>();
    protected String startName;

    protected abstract P newProduction(NT var1, AssemblySentential<NT> var2);

    public void addProduction(NT lhs, AssemblySentential<NT> rhs) {
        P prod = this.newProduction(lhs, rhs);
        this.addProduction(prod);
    }

    public void addProduction(P prod) {
        String lname = ((AbstractAssemblyProduction)prod).getName();
        if (this.productions.put((Object)lname, prod)) {
            ((AbstractAssemblyProduction)prod).idx = this.prodList.size();
            this.prodList.add(prod);
        }
        Object lhs = ((AbstractAssemblyProduction)prod).getLHS();
        if (this.startName == null) {
            this.setStart((AssemblyNonTerminal)lhs);
        }
        String lhsName = ((AssemblySymbol)lhs).getName();
        this.symbols.put(lhsName, (AssemblySymbol)lhs);
        this.nonterminals.put(lhsName, lhs);
        for (AssemblySymbol sym : ((AbstractAssemblyProduction)prod).getRHS()) {
            String name;
            if (sym instanceof AssemblyNonTerminal) {
                AssemblyNonTerminal nt = (AssemblyNonTerminal)sym;
                name = nt.getName();
                this.symbols.put(name, nt);
                this.nonterminals.put(name, nt);
                continue;
            }
            AssemblyTerminal t = (AssemblyTerminal)sym;
            name = t.getName();
            this.symbols.put(name, t);
            this.terminals.put(name, t);
        }
    }

    protected boolean isPureRecursive(P prod) {
        if (((AbstractAssemblyProduction)prod).getRHS().size() != 1) {
            return false;
        }
        return ((AssemblySymbol)((AbstractAssemblyProduction)prod).getLHS()).equals(((AbstractAssemblyProduction)prod).getRHS().getSymbol(0));
    }

    public void setStart(AssemblyNonTerminal nt) {
        this.setStartName(nt == null ? null : nt.getName());
    }

    public void setStartName(String startName) {
        this.startName = startName;
    }

    public NT getStart() {
        return (NT)((AssemblyNonTerminal)this.nonterminals.get(this.startName));
    }

    public String getStartName() {
        return this.startName;
    }

    public NT getNonTerminal(String name) {
        return (NT)((AssemblyNonTerminal)this.nonterminals.get(name));
    }

    public AssemblyTerminal getTerminal(String name) {
        return this.terminals.get(name);
    }

    public void combine(AbstractAssemblyGrammar<NT, P> that) {
        for (AbstractAssemblyProduction prod : that.prodList) {
            this.addProduction(prod);
        }
    }

    public void print(PrintStream out) {
        for (AbstractAssemblyProduction prod : this.prodList) {
            out.println(prod);
        }
    }

    public void verify() throws AssemblyGrammarException {
        if (!this.productions.containsKey((Object)this.startName)) {
            throw new AssemblyGrammarException("Start symbol has no defining production");
        }
        for (AbstractAssemblyProduction prod : this.productions.values()) {
            for (AssemblySymbol sym : prod.getRHS()) {
                AssemblyNonTerminal nt;
                if (!(sym instanceof AssemblyNonTerminal) || this.productions.containsKey((Object)(nt = (AssemblyNonTerminal)sym).getName())) continue;
                throw new AssemblyGrammarException("Grammar has non-terminal '" + nt.getName() + "' without a defining production");
            }
        }
    }

    @Override
    public Iterator<P> iterator() {
        return Collections.unmodifiableList(this.prodList).iterator();
    }

    public Collection<NT> nonTerminals() {
        return Collections.unmodifiableCollection(this.nonterminals.values());
    }

    public Collection<AssemblyTerminal> terminals() {
        return Collections.unmodifiableCollection(this.terminals.values());
    }

    public Collection<P> productionsOf(String name) {
        if (!this.productions.containsKey((Object)name)) {
            return Collections.emptySet();
        }
        return this.productions.get((Object)name);
    }

    public Collection<P> productionsOf(AssemblyNonTerminal nt) {
        return this.productionsOf(nt.getName());
    }

    public boolean contains(String name) {
        return this.symbols.containsKey(name);
    }
}

