/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query;

import generic.lsh.vector.LSHVector;
import generic.lsh.vector.LSHVectorFactory;
import generic.lsh.vector.VectorCompare;
import generic.lsh.vector.WeightedLSHCosineVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.NonThreadedXmlPullParserImpl;
import ghidra.xml.XmlPullParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.Iterator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class CompareSignatures {
    private DescriptionManager manager = new DescriptionManager();
    private LSHVectorFactory vectorFactory;

    public CompareSignatures(LSHVectorFactory vFactory) {
        this.vectorFactory = vFactory;
    }

    private boolean isFileSignatures(File file) {
        if (file == null) {
            return false;
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = in.readLine();
            in.close();
            if (line == null) {
                return false;
            }
            if (line.contains("<description>")) {
                return true;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    private void readFiles(File directory) {
        File[] filelist;
        ErrorHandler handler = SpecXmlUtils.getXmlHandler();
        for (File element : filelist = directory.listFiles()) {
            if (!this.isFileSignatures(element)) continue;
            try {
                NonThreadedXmlPullParserImpl parser = new NonThreadedXmlPullParserImpl(element, handler, false);
                this.manager.restoreXml((XmlPullParser)parser, this.vectorFactory);
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (LSHException e) {
                e.printStackTrace();
            }
        }
    }

    private void printResultRow(PrintStream out, double sim, double signif, FunctionDescription func1, FunctionDescription func2) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        out.print(nf.format(sim));
        out.print("  ");
        out.print(nf.format(signif));
        out.print("  ");
        ExecutableRecord exerec = func1.getExecutableRecord();
        out.print(exerec.getNameExec());
        out.print(':');
        out.print(func1.getFunctionName());
        out.print("  ");
        exerec = func2.getExecutableRecord();
        out.print(exerec.getNameExec());
        out.print(':');
        out.println(func2.getFunctionName());
    }

    private void compareSignatures(PrintStream out, double simthresh, double signifthresh) {
        VectorCompare veccompare = new VectorCompare();
        Iterator<FunctionDescription> iter1 = this.manager.listAllFunctions();
        while (iter1.hasNext()) {
            FunctionDescription func1 = iter1.next();
            LSHVector vec1 = func1.getSignatureRecord().getLSHVector();
            Iterator<FunctionDescription> iter2 = this.manager.listFunctionsAfter(func1);
            while (iter2.hasNext()) {
                double signif;
                FunctionDescription func2 = iter2.next();
                LSHVector vec2 = func2.getSignatureRecord().getLSHVector();
                double res = vec1.compare(vec2, veccompare);
                if (!(res > simthresh) || !((signif = this.vectorFactory.calculateSignificance(veccompare)) > signifthresh)) continue;
                this.printResultRow(out, res, signif, func1, func2);
            }
        }
    }

    public void run(String[] args) {
        if (args == null || args.length < 1) {
            System.out.println("Require signature directory path");
        }
        File directory = new File(args[0]);
        double simthresh = 0.7;
        double signifthresh = 4.0;
        this.readFiles(directory);
        try {
            if (args.length > 1) {
                File outfile = new File(args[1]);
                PrintStream out = new PrintStream(new FileOutputStream(outfile));
                this.compareSignatures(out, simthresh, signifthresh);
                out.close();
            } else {
                this.compareSignatures(System.out, simthresh, signifthresh);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        WeightedLSHCosineVectorFactory vFactory = new WeightedLSHCosineVectorFactory();
        CompareSignatures comp = new CompareSignatures((LSHVectorFactory)vFactory);
        comp.run(args);
    }
}

