/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.db;

import ghidra.feature.fid.db.FidDB;
import ghidra.feature.fid.db.FidFile;
import ghidra.feature.fid.db.FidQueryCloseListener;
import ghidra.feature.fid.db.FunctionRecord;
import ghidra.feature.fid.db.LibraryRecord;
import ghidra.feature.fid.hash.FidHashQuad;
import ghidra.program.model.lang.Language;
import ghidra.util.exception.VersionException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class FidQueryService
implements Closeable {
    List<FidDB> fidDbList = new ArrayList<FidDB>();
    List<FidQueryCloseListener> listeners = new ArrayList<FidQueryCloseListener>();

    FidQueryService(Set<FidFile> fidFiles, Language language, boolean openForUpdate) throws VersionException, IOException {
        for (FidFile fidFile : fidFiles) {
            if (!fidFile.isActive() || language != null && !fidFile.canProcessLanguage(language)) continue;
            this.fidDbList.add(fidFile.getFidDB(openForUpdate));
        }
    }

    public void addCloseListener(FidQueryCloseListener listener) {
        this.listeners.add(listener);
    }

    public void removeCloseListener(FidQueryCloseListener listener) {
        this.listeners.remove(listener);
    }

    public FunctionRecord getFunctionByID(long functionID) {
        for (FidDB fidDb : this.fidDbList) {
            FunctionRecord functionRecord = fidDb.getFunctionByID(functionID);
            if (functionRecord == null) continue;
            return functionRecord;
        }
        return null;
    }

    public boolean getSuperiorFullRelation(FunctionRecord superiorFunction, FidHashQuad inferiorFunction) {
        for (FidDB fidDb : this.fidDbList) {
            if (!fidDb.getSuperiorFullRelation(superiorFunction, inferiorFunction)) continue;
            return true;
        }
        return false;
    }

    public boolean getInferiorFullRelation(FidHashQuad superiorFunction, FunctionRecord inferiorFunction) {
        for (FidDB fidDb : this.fidDbList) {
            if (!fidDb.getInferiorFullRelation(superiorFunction, inferiorFunction)) continue;
            return true;
        }
        return false;
    }

    public LibraryRecord getLibraryForFunction(FunctionRecord functionRecord) {
        for (FidDB fidDb : this.fidDbList) {
            LibraryRecord libraryRecord = fidDb.getLibraryForFunction(functionRecord);
            if (libraryRecord == null) continue;
            return libraryRecord;
        }
        return null;
    }

    public Long findFullHashValueAtOrAfter(long value) {
        Long minimumValue = null;
        for (FidDB fidDb : this.fidDbList) {
            Long fullHashValue = fidDb.findFullHashValueAtOrAfter(value);
            if (fullHashValue == null || minimumValue != null && fullHashValue >= minimumValue) continue;
            minimumValue = fullHashValue;
        }
        return minimumValue;
    }

    public List<FunctionRecord> findFunctionsBySpecificHash(long specificHash) {
        ArrayList<FunctionRecord> result = new ArrayList<FunctionRecord>();
        for (FidDB fidDb : this.fidDbList) {
            List<FunctionRecord> list = fidDb.findFunctionsBySpecificHash(specificHash);
            if (list == null) continue;
            result.addAll(list);
        }
        return result;
    }

    public List<FunctionRecord> findFunctionsByFullHash(long fullHash) {
        ArrayList<FunctionRecord> result = new ArrayList<FunctionRecord>();
        for (FidDB fidDb : this.fidDbList) {
            List<FunctionRecord> list = fidDb.findFunctionsByFullHash(fullHash);
            if (list == null) continue;
            result.addAll(list);
        }
        return result;
    }

    public List<FunctionRecord> findFunctionsByNameSubstring(String name) {
        ArrayList<FunctionRecord> result = new ArrayList<FunctionRecord>();
        for (FidDB fidDb : this.fidDbList) {
            List<FunctionRecord> list = fidDb.findFunctionsByNameSubstring(name);
            if (list == null) continue;
            result.addAll(list);
        }
        return result;
    }

    public List<FunctionRecord> findFunctionsByDomainPathSubstring(String domainPath) {
        ArrayList<FunctionRecord> result = new ArrayList<FunctionRecord>();
        for (FidDB fidDb : this.fidDbList) {
            List<FunctionRecord> list = fidDb.findFunctionsByDomainPathSubstring(domainPath);
            if (list == null) continue;
            result.addAll(list);
        }
        return result;
    }

    @Override
    public void close() {
        List<FidQueryCloseListener> currentListeners = this.listeners;
        this.listeners = new ArrayList<FidQueryCloseListener>();
        for (FidQueryCloseListener listener : currentListeners) {
            listener.fidQueryClosed(this);
        }
        this.listeners.clear();
        for (FidDB fidDb : this.fidDbList) {
            fidDb.close();
        }
    }
}

