/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.control.GraphMouseListener;
import org.jungrapht.visualization.layout.model.LayoutModel;

public class MouseListenerTranslator<V, E>
extends MouseAdapter {
    private VisualizationViewer<V, E> visualizationViewer;
    private GraphMouseListener<V> graphMouseListener;

    public MouseListenerTranslator(GraphMouseListener<V> graphMouseListener, VisualizationViewer<V, E> visualizationViewer) {
        this.graphMouseListener = graphMouseListener;
        this.visualizationViewer = visualizationViewer;
    }

    private V getVertex(Point2D point) {
        GraphElementAccessor pickSupport = this.visualizationViewer.getPickSupport();
        LayoutModel layoutModel = this.visualizationViewer.getVisualizationModel().getLayoutModel();
        Object v = null;
        if (pickSupport != null) {
            v = pickSupport.getVertex(layoutModel, point.getX(), point.getY());
        }
        return (V)v;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        V v = this.getVertex(e.getPoint());
        if (v != null) {
            this.graphMouseListener.graphClicked(v, e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        V v = this.getVertex(e.getPoint());
        if (v != null) {
            this.graphMouseListener.graphPressed(v, e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        V v = this.getVertex(e.getPoint());
        if (v != null) {
            this.graphMouseListener.graphReleased(v, e);
        }
    }
}

