/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import docking.DialogComponentProvider;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import ghidra.app.cmd.memory.MoveBlockListener;
import ghidra.app.cmd.memory.MoveBlockTask;
import ghidra.app.plugin.core.memory.MoveBlockModel;
import ghidra.app.util.AddressInput;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import ghidra.util.layout.PairLayout;
import ghidra.util.task.Task;
import ghidra.util.task.TaskBuilder;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MoveBlockDialog
extends DialogComponentProvider
implements MoveBlockListener {
    private JLabel origStartLabel;
    private JLabel origEndLabel;
    private JLabel lengthLabel;
    private JLabel blockNameLabel;
    private AddressInput newStartField;
    private AddressInput newEndField;
    private boolean changing;
    private MoveBlockModel model;
    private PluginTool tool;

    MoveBlockDialog(MoveBlockModel model, PluginTool tool) {
        super("Move Memory Block");
        this.model = model;
        this.tool = tool;
        this.setHelpLocation(new HelpLocation("MemoryMapPlugin", "Move Block"));
        model.setMoveBlockListener(this);
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
    }

    @Override
    public void moveBlockCompleted(MoveBlockTask task) {
        this.setCursor(Cursor.getDefaultCursor());
        boolean success = task.wasSuccessful();
        this.setOkEnabled(success);
        this.setStatusText(task.getStatusMessage());
        Swing.runLater(() -> {
            if (success) {
                this.close();
                this.model.dispose();
            }
        });
    }

    @Override
    public void stateChanged() {
        Address newEnd;
        Address newStart;
        this.setOkEnabled(false);
        this.changing = true;
        if (!this.isVisible()) {
            Program program = this.model.getProgram();
            this.newStartField.setProgram(program);
            this.newEndField.setProgram(program);
        }
        if ((newStart = this.model.getNewStartAddress()) != null && !newStart.equals((Object)this.newStartField.getAddress())) {
            this.newStartField.setAddress(newStart);
        }
        if ((newEnd = this.model.getNewEndAddress()) != null && !newEnd.equals((Object)this.newEndField.getAddress())) {
            this.newEndField.setAddress(newEnd);
        }
        this.changing = false;
        String message = this.model.getMessage();
        this.setStatusText(message);
        if (!this.isVisible()) {
            this.blockNameLabel.setText(this.model.getName());
            this.origStartLabel.setText(this.model.getStartAddress().toString());
            this.origEndLabel.setText(this.model.getEndAddress().toString());
            this.lengthLabel.setText(this.model.getLengthString());
            this.tool.showDialog((DialogComponentProvider)this);
        } else if (message.length() == 0) {
            this.setOkEnabled(true);
        }
    }

    protected void okCallback() {
        this.setOkEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        MoveBlockTask task = this.model.makeTask();
        TaskBuilder.withTask((Task)task).setParent((Component)this.getComponent()).launchModal();
    }

    protected void cancelCallback() {
        this.close();
        this.model.dispose();
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(2, 10, 150));
        panel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 20));
        this.blockNameLabel = new GDLabel(".text");
        this.blockNameLabel.setName("blockName");
        this.origStartLabel = new GDLabel("1001000");
        this.origStartLabel.setName("origStart");
        this.origEndLabel = new GDLabel("1002000");
        this.origEndLabel.setName("origEnd");
        this.lengthLabel = new GDLabel("4096 (0x1000)");
        this.lengthLabel.setName("length");
        this.newStartField = new AddressInput(this.model.getProgram(), this::startChanged);
        this.newStartField.setName("newStart");
        this.newEndField = new AddressInput(this.model.getProgram(), this::endChanged);
        this.newEndField.setName("newEnd");
        panel.add((Component)new GLabel("Name:", 4));
        panel.add(this.blockNameLabel);
        panel.add((Component)new GLabel("Start Address:", 4));
        panel.add(this.origStartLabel);
        panel.add((Component)new GLabel("End Address:", 4));
        panel.add(this.origEndLabel);
        panel.add((Component)new GLabel("Length:", 4));
        panel.add(this.lengthLabel);
        panel.add((Component)new GLabel("New Start Address:", 4));
        panel.add(this.newStartField);
        panel.add((Component)new GLabel("New End Address:", 4));
        panel.add(this.newEndField);
        return panel;
    }

    private void startChanged(Address address) {
        if (this.changing) {
            return;
        }
        if (address != null) {
            this.model.setNewStartAddress(address);
        } else {
            this.setStatusText("Invalid Address");
            this.setOkEnabled(false);
        }
    }

    private void endChanged(Address address) {
        if (this.changing) {
            return;
        }
        if (address != null) {
            this.model.setNewEndAddress(address);
        } else {
            this.setStatusText("Invalid Address");
            this.setOkEnabled(false);
        }
    }
}

