/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.utils;

import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.ref.Cleaner;

public class ManagedDomainObject
implements AutoCloseable {
    public static final Cleaner CLEANER = Cleaner.create();
    private final ObjectState state = new ObjectState();

    public ManagedDomainObject(DomainFile file, boolean okToUpgrade, boolean okToRecover, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        this.state.obj = file.getDomainObject((Object)this.state, okToUpgrade, okToRecover, monitor);
        CLEANER.register(this, this.state);
    }

    @Override
    public void close() throws Exception {
        this.state.run();
    }

    public DomainObject get() {
        return this.state.get();
    }

    private static class ObjectState
    implements Runnable {
        private DomainObject obj;

        private ObjectState() {
        }

        @Override
        public synchronized void run() {
            if (this.obj.getConsumerList().contains(this)) {
                this.obj.release((Object)this);
            }
        }

        public synchronized DomainObject get() {
            if (!this.obj.getConsumerList().contains(this)) {
                throw new IllegalStateException("Domain object is closed");
            }
            return this.obj;
        }
    }
}

