/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api;

import generic.concurrent.ConcurrentQ;
import generic.concurrent.ConcurrentQBuilder;
import generic.concurrent.GThreadPool;
import generic.concurrent.QCallback;
import generic.concurrent.QResult;
import generic.lsh.LSHMemoryModel;
import generic.lsh.vector.LSHVectorFactory;
import generic.lsh.vector.VectorCompare;
import ghidra.feature.vt.api.BinningSystem;
import ghidra.feature.vt.api.FunctionNode;
import ghidra.feature.vt.api.FunctionNodeContainer;
import ghidra.feature.vt.api.FunctionPair;
import ghidra.feature.vt.api.NamespaceNeighborhood;
import ghidra.feature.vt.api.NeighborGenerator;
import ghidra.feature.vt.api.PotentialPair;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationManager;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;

public class BSimProgramCorrelatorMatching {
    private SortedSet<PotentialPair> implications;
    private FunctionNodeContainer sourceNodes;
    private FunctionNodeContainer destNodes;
    private LSHVectorFactory vectorFactory;
    private LinkedList<FunctionPair> matches;
    private Set<FunctionPair> seeds;
    private List<FunctionPair> discoveredMatches;
    private double confThreshold;
    private double impThreshold;
    private double potentialSimThreshold;
    private LSHMemoryModel memoryModel;
    private boolean useNamespaceNeighbors;
    private static final Comparator<FunctionPair> CONF_COMPARATOR = new Comparator<FunctionPair>(){

        @Override
        public int compare(FunctionPair o1, FunctionPair o2) {
            return Double.compare(o2.getConfResult(), o1.getConfResult());
        }
    };

    public BSimProgramCorrelatorMatching(FunctionNodeContainer sourceNodes, FunctionNodeContainer destNodes, LSHVectorFactory vFactory, double conf, double imp, double sim, boolean useNamespace, LSHMemoryModel model) {
        this.sourceNodes = sourceNodes;
        this.destNodes = destNodes;
        this.vectorFactory = vFactory;
        this.confThreshold = conf;
        this.impThreshold = imp;
        this.potentialSimThreshold = sim;
        this.useNamespaceNeighbors = useNamespace;
        this.memoryModel = model;
        this.implications = new TreeSet<PotentialPair>();
    }

    private void acceptMatch(FunctionPair bridge) {
        FunctionNode sourceNode = bridge.getSourceNode();
        FunctionNode destNode = bridge.getDestNode();
        sourceNode.setAcceptedMatch(true);
        destNode.setAcceptedMatch(true);
        this.matches.add(bridge);
        Iterator<Map.Entry<FunctionNode, FunctionPair>> iter = sourceNode.getAssociateIterator();
        while (iter.hasNext()) {
            iter.next().getKey().removeAssociate(sourceNode);
        }
        iter = destNode.getAssociateIterator();
        while (iter.hasNext()) {
            iter.next().getKey().removeAssociate(destNode);
        }
        sourceNode.clearAssociates();
        destNode.clearAssociates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discoverPotentialMatches(TaskMonitor monitor) throws Exception {
        Collection results;
        BinningSystem binning = new BinningSystem(this.memoryModel);
        monitor.setMessage("Binning source functions...");
        monitor.initialize((long)this.sourceNodes.size());
        binning.add(this.sourceNodes.iterator(), monitor);
        monitor.setMessage("Zealously over-pairing matches...");
        monitor.initialize((long)this.destNodes.size());
        GThreadPool pool = GThreadPool.getPrivateThreadPool((String)"BSimProgramCorrelatorMatching");
        MatchingCallback callback = new MatchingCallback(binning, this.potentialSimThreshold);
        ConcurrentQ queue = new ConcurrentQBuilder().setThreadPool(pool).setCollectResults(true).setMonitor(monitor).build((QCallback)callback);
        queue.add(this.destNodes.iterator());
        try {
            results = queue.waitForResults();
        }
        finally {
            queue.dispose();
        }
        this.discoveredMatches = new LinkedList<FunctionPair>();
        for (QResult result : results) {
            monitor.checkCancelled();
            List pieces = (List)result.getResult();
            if (pieces == null) continue;
            for (FunctionPair bridge : pieces) {
                monitor.checkCancelled();
                if (bridge == null) continue;
                FunctionNode sourceNode = bridge.getSourceNode();
                FunctionNode destNode = bridge.getDestNode();
                sourceNode.addAssociate(destNode, bridge);
                destNode.addAssociate(sourceNode, bridge);
                this.discoveredMatches.add(bridge);
            }
        }
    }

    private static int findIndexMatchingThreshold(ArrayList<FunctionPair> pairs, double threshold) {
        int min = 0;
        int max = pairs.size() - 1;
        while (min < max) {
            int mid = (min + max + 1) / 2;
            FunctionPair pair = pairs.get(mid);
            if (pair.getConfResult() < threshold) {
                max = mid - 1;
                continue;
            }
            min = mid;
        }
        return min;
    }

    private void chooseSeeds(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Generating seeds...");
        ArrayList<FunctionPair> finalPairs = new ArrayList<FunctionPair>();
        HashSet<FunctionNode> matchedSource = new HashSet<FunctionNode>();
        HashSet<FunctionNode> matchedDest = new HashSet<FunctionNode>();
        HashSetValuedHashMap sourceHoldOn = new HashSetValuedHashMap();
        HashSetValuedHashMap destHoldOn = new HashSetValuedHashMap();
        HashSetValuedHashMap sourceFormatted = new HashSetValuedHashMap();
        HashSetValuedHashMap destFormatted = new HashSetValuedHashMap();
        for (FunctionPair pair : this.discoveredMatches) {
            sourceFormatted.put((Object)pair.getSourceNode(), (Object)pair);
            destFormatted.put((Object)pair.getDestNode(), (Object)pair);
        }
        this.discoveredMatches = null;
        int keepLen = sourceFormatted.size();
        if (keepLen == 0) {
            return;
        }
        boolean changed = true;
        double ratioThresh = 0.5;
        while (changed) {
            monitor.checkCancelled();
            Collection values = sourceFormatted.values();
            monitor.initialize((long)values.size());
            for (FunctionPair entry : values) {
                double childRatio;
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
                if (!BSimProgramCorrelatorMatching.hasConflicts(entry, (MultiValuedMap<FunctionNode, FunctionPair>)sourceFormatted, (MultiValuedMap<FunctionNode, FunctionPair>)destFormatted)) {
                    finalPairs.add(entry);
                    matchedSource.add(entry.getSourceNode());
                    matchedDest.add(entry.getDestNode());
                    continue;
                }
                if (matchedSource.contains(entry.getSourceNode()) || matchedDest.contains(entry.getDestNode())) continue;
                double leftside = Math.min((double)entry.getSourceNode().getChildren().size(), (double)entry.getDestNode().getChildren().size());
                double rightside = Math.max((double)entry.getSourceNode().getChildren().size(), (double)entry.getDestNode().getChildren().size());
                double d = childRatio = rightside == 0.0 ? 0.0 : leftside / rightside;
                leftside = (double)entry.getSourceNode().getLen() / (double)entry.getDestNode().getLen();
                double lenRatio = Math.min(leftside, 1.0 / leftside);
                if (!(lenRatio > ratioThresh) || !(childRatio > ratioThresh)) continue;
                sourceHoldOn.put((Object)entry.getSourceNode(), (Object)entry);
                destHoldOn.put((Object)entry.getDestNode(), (Object)entry);
            }
            sourceFormatted = sourceHoldOn;
            destFormatted = destHoldOn;
            changed = keepLen != values.size();
            keepLen = sourceHoldOn.values().size();
            sourceHoldOn = new HashSetValuedHashMap();
            destHoldOn = new HashSetValuedHashMap();
            ratioThresh = (2.0 + ratioThresh) / 3.0;
        }
        if (finalPairs.isEmpty()) {
            return;
        }
        Collections.sort(finalPairs, CONF_COMPARATOR);
        double curConf = ((FunctionPair)finalPairs.get(0)).getConfResult();
        if (curConf < this.confThreshold) {
            Msg.warn((Object)this, (Object)("Initial value of seed confidence too high (" + this.confThreshold + ")...resetting seed confidence to " + curConf));
            this.confThreshold = curConf;
        }
        int lastIndex = BSimProgramCorrelatorMatching.findIndexMatchingThreshold(finalPairs, this.confThreshold);
        for (int i = 0; i < lastIndex + 1; ++i) {
            FunctionPair pair = finalPairs.get(i);
            this.seeds.add(pair);
        }
    }

    private static boolean hasConflicts(FunctionPair entry, MultiValuedMap<FunctionNode, FunctionPair> sourceFormatted, MultiValuedMap<FunctionNode, FunctionPair> destFormatted) {
        Collection sources = sourceFormatted.get((Object)entry.getSourceNode());
        if (sources != null && sources.size() > 1) {
            return true;
        }
        Collection dests = destFormatted.get((Object)entry.getDestNode());
        return dests != null && dests.size() > 1;
    }

    public boolean generateSeeds(VTMatchSet matchSet, boolean useAcceptedMatchesAsSeeds, TaskMonitor monitor) throws CancelledException {
        this.seeds = new HashSet<FunctionPair>();
        if (useAcceptedMatchesAsSeeds) {
            this.findAcceptedSeeds(matchSet, monitor);
        }
        this.chooseSeeds(monitor);
        return !this.seeds.isEmpty();
    }

    private NeighborGenerator[] buildNeighborGenerators(int round) {
        ArrayList<NeighborGenerator> generatorList = new ArrayList<NeighborGenerator>();
        if (round == 0) {
            generatorList.add(new NeighborGenerator.Children(this.vectorFactory, this.impThreshold));
            generatorList.add(new NeighborGenerator.Parents(this.vectorFactory, this.impThreshold));
            if (this.useNamespaceNeighbors) {
                generatorList.add(new NamespaceNeighborhood(this.vectorFactory, this.impThreshold, this.sourceNodes, this.destNodes));
            }
        } else {
            generatorList.add(new NeighborGenerator.Children(this.vectorFactory, this.impThreshold));
            generatorList.add(new NeighborGenerator.Parents(this.vectorFactory, this.impThreshold));
            generatorList.add(new NeighborGenerator.GrandChildren(this.vectorFactory, this.impThreshold));
            generatorList.add(new NeighborGenerator.Siblings(this.vectorFactory, this.impThreshold));
            generatorList.add(new NeighborGenerator.Spouses(this.vectorFactory, this.impThreshold));
            generatorList.add(new NeighborGenerator.GrandParents(this.vectorFactory, this.impThreshold));
            if (this.useNamespaceNeighbors) {
                generatorList.add(new NamespaceNeighborhood(this.vectorFactory, this.impThreshold, this.sourceNodes, this.destNodes));
            }
        }
        NeighborGenerator[] res = new NeighborGenerator[generatorList.size()];
        generatorList.toArray(res);
        return res;
    }

    public List<FunctionPair> doMatching(TaskMonitor monitor) throws CancelledException {
        this.matches = new LinkedList();
        block0: for (int round = 0; round < 2; ++round) {
            monitor.checkCancelled();
            NeighborGenerator[] generatorList = this.buildNeighborGenerators(round);
            if (round == 0) {
                monitor.setMessage("Matching round 1...");
                monitor.initialize((long)this.seeds.size());
                for (FunctionPair bridge : this.seeds) {
                    monitor.checkCancelled();
                    monitor.incrementProgress(1L);
                    this.acceptMatch(bridge);
                    impliedPair = this.analyze(bridge, generatorList);
                    if (impliedPair == null) continue;
                    this.implications.add(impliedPair);
                }
                this.seeds = null;
            } else {
                this.implications.clear();
                monitor.setMessage("Matching round 2...");
                monitor.initialize((long)this.matches.size());
                for (FunctionPair bridge : this.matches) {
                    monitor.checkCancelled();
                    monitor.incrementProgress(1L);
                    impliedPair = this.analyze(bridge, generatorList);
                    if (impliedPair == null) continue;
                    this.implications.add(impliedPair);
                }
            }
            monitor.setMessage("Gathering matches for round " + (round + 1) + "...");
            int maxSize = this.implications.size();
            monitor.initialize((long)(maxSize + 1));
            do {
                PotentialPair impliedPair;
                monitor.checkCancelled();
                int size = this.implications.size();
                if (size > maxSize) {
                    maxSize = size;
                    monitor.setMaximum((long)(maxSize + 1));
                }
                monitor.setProgress((long)(maxSize - size + 1));
                if (size == 0) continue block0;
                PotentialPair bestImplied = this.implications.last();
                this.implications.remove(bestImplied);
                FunctionPair bridge = bestImplied.getSource().findEdge(bestImplied.getDestination());
                if (bridge != null) {
                    this.acceptMatch(bridge);
                    impliedPair = this.analyze(bridge, generatorList);
                    if (impliedPair != null) {
                        this.implications.add(impliedPair);
                    }
                }
                if ((impliedPair = this.analyze(bestImplied.getOrigin(), generatorList)) == null) continue;
                this.implications.add(impliedPair);
            } while (!this.implications.isEmpty() && !(this.implications.last().getScore() < this.impThreshold));
        }
        LinkedList<FunctionPair> matchCopy = new LinkedList<FunctionPair>(this.matches);
        VectorCompare veccompare = new VectorCompare();
        monitor.setMessage("Patching holes...");
        monitor.initialize((long)this.matches.size());
        for (FunctionPair bridge : matchCopy) {
            FunctionNode dp;
            FunctionNode sp;
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            if (bridge.getSourceNode().getParents().size() != 1 || bridge.getDestNode().getParents().size() != 1 || (sp = bridge.getSourceNode().getParents().iterator().next()).findEdge(dp = bridge.getDestNode().getParents().iterator().next()) != null || sp.isAcceptedMatch() || dp.isAcceptedMatch()) continue;
            double similarity = sp.getVector().compare(dp.getVector(), veccompare);
            double confidence = this.vectorFactory.calculateSignificance(veccompare);
            FunctionPair rentBridge = new FunctionPair(sp, dp, similarity, confidence);
            this.acceptMatch(rentBridge);
        }
        return this.matches;
    }

    private void findAcceptedSeeds(VTMatchSet myMatchSet, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Using accepted matches as seeds...");
        VTSession session = myMatchSet.getSession();
        VTAssociationManager associationManager = session.getAssociationManager();
        int associationCount = associationManager.getAssociationCount();
        monitor.initialize((long)associationCount);
        List associations = associationManager.getAssociations();
        Program sourceProgram = this.sourceNodes.getProgram();
        Program destinationProgram = this.destNodes.getProgram();
        for (VTAssociation association : associations) {
            monitor.checkCancelled();
            if (association.getType().equals((Object)VTAssociationType.FUNCTION) && association.getStatus() == VTAssociationStatus.ACCEPTED) {
                FunctionPair bridge;
                FunctionNode dn;
                FunctionNode sn;
                Address sourceAddress = association.getSourceAddress();
                Function sourceFunction = sourceProgram.getListing().getFunctionAt(sourceAddress);
                Address destinationAddress = association.getDestinationAddress();
                Function destinationFunction = destinationProgram.getListing().getFunctionAt(destinationAddress);
                if (sourceFunction != null && destinationFunction != null && (sn = this.sourceNodes.get(sourceAddress)) != null && (dn = this.destNodes.get(destinationAddress)) != null && (bridge = sn.findEdge(dn)) != null) {
                    this.seeds.add(bridge);
                }
            }
            monitor.incrementProgress(1L);
        }
    }

    private PotentialPair analyze(FunctionPair pair, NeighborGenerator[] generatorList) {
        FunctionNode sourceNode = pair.getSourceNode();
        FunctionNode destNode = pair.getDestNode();
        double confResult = pair.getConfResult();
        double implicationScore = 0.0;
        PotentialPair bestImplied = null;
        for (NeighborGenerator generator : generatorList) {
            NeighborGenerator.NeighborhoodPair nPair = generator.generate(sourceNode, destNode);
            PotentialPair srcToDestPair = this.calculateBestNeighbor(nPair.srcNeighbors, nPair.destNeighbors, confResult);
            if (srcToDestPair.getScore() > implicationScore) {
                implicationScore = srcToDestPair.getScore();
                bestImplied = srcToDestPair;
            }
            PotentialPair destToSrcPair = this.calculateBestNeighbor(nPair.destNeighbors, nPair.srcNeighbors, confResult);
            destToSrcPair.swap();
            if (!(destToSrcPair.getScore() > implicationScore)) continue;
            implicationScore = destToSrcPair.getScore();
            bestImplied = destToSrcPair;
        }
        if (bestImplied != null) {
            bestImplied.setOrigin(pair);
        }
        return bestImplied;
    }

    private static PotentialPair unconflictedPair(ArrayList<PotentialPair> potentialPairs, int firstIndex, int lastIndex) {
        for (int i = firstIndex; i <= lastIndex; ++i) {
            FunctionNode myFrom = potentialPairs.get(i).getSource();
            FunctionNode myTo = potentialPairs.get(i).getDestination();
            boolean useMe = true;
            for (int j = firstIndex; j <= lastIndex; ++j) {
                if (i == j) continue;
                FunctionNode yourFrom = potentialPairs.get(j).getSource();
                FunctionNode yourTo = potentialPairs.get(j).getDestination();
                if (myFrom != yourFrom && myTo != yourTo) continue;
                useMe = false;
                break;
            }
            if (!useMe) continue;
            return potentialPairs.get(i);
        }
        return null;
    }

    private static double adjustConfidenceScore(double conf, FunctionNode a, FunctionNode b) {
        int childrenSize = b.getChildren().size();
        double ratio = childrenSize == 0 ? 0.0 : (double)a.getChildren().size() / (double)childrenSize;
        double kidRatio = Math.min(ratio, 1.0 / ratio);
        int parentsSize = b.getParents().size();
        ratio = parentsSize == 0 ? 0.0 : (double)a.getParents().size() / (double)parentsSize;
        double rentRatio = Math.min(ratio, 1.0 / ratio);
        ratio = (double)a.getLen() / (double)b.getLen();
        double lenRatio = Math.min(ratio, 1.0 / ratio);
        return 0.25 * conf * lenRatio * (1.0 + kidRatio) * (1.0 + rentRatio);
    }

    private static PotentialPair findFirstUnconflictedPair(ArrayList<PotentialPair> potentialPairs) {
        Collections.sort(potentialPairs);
        int lastIndex = potentialPairs.size() - 1;
        while (lastIndex >= 0) {
            int firstIndex;
            double score = potentialPairs.get(lastIndex).getScore();
            for (firstIndex = lastIndex - 1; firstIndex >= 0 && potentialPairs.get(firstIndex).getScore() >= score; --firstIndex) {
            }
            PotentialPair bestPair = BSimProgramCorrelatorMatching.unconflictedPair(potentialPairs, firstIndex + 1, lastIndex);
            if (bestPair != null) {
                return bestPair;
            }
            lastIndex = firstIndex;
        }
        return PotentialPair.EMPTY_PAIR;
    }

    private PotentialPair calculateBestNeighbor(Set<FunctionNode> aNeighbors, Set<FunctionNode> bNeighbors, double confResult) {
        ArrayList<PotentialPair> potentialPairs = new ArrayList<PotentialPair>();
        PotentialPair bestPair = PotentialPair.EMPTY_PAIR;
        int bestCount = 0;
        for (FunctionNode relative : aNeighbors) {
            if (relative.isAcceptedMatch()) continue;
            double bestAdjustedScore = 0.0;
            double relSum = 0.0;
            double bestOriginalScore = 0.0;
            FunctionNode bestRelAssoc = null;
            Iterator<Map.Entry<FunctionNode, FunctionPair>> iter = relative.getAssociateIterator();
            while (iter.hasNext()) {
                Map.Entry<FunctionNode, FunctionPair> entry = iter.next();
                FunctionNode associate = entry.getKey();
                double value = entry.getValue().getConfResult();
                if (!bNeighbors.contains(associate)) continue;
                double entryAdjusted = BSimProgramCorrelatorMatching.adjustConfidenceScore(value, relative, associate);
                relSum += entryAdjusted;
                if (!(entryAdjusted >= bestAdjustedScore)) continue;
                bestAdjustedScore = entryAdjusted;
                bestRelAssoc = associate;
                bestOriginalScore = value;
            }
            if (!(relSum > 0.0)) continue;
            double tempMax = (double)bNeighbors.size() * (bestOriginalScore + confResult) * bestAdjustedScore / relSum;
            PotentialPair newPair = new PotentialPair(relative, bestRelAssoc, tempMax);
            potentialPairs.add(newPair);
            if (tempMax > bestPair.getScore()) {
                bestPair = newPair;
                bestCount = 1;
                continue;
            }
            if (tempMax != bestPair.getScore()) continue;
            ++bestCount;
        }
        if (bestCount == 0 || bestPair.getScore() == 0.0) {
            return PotentialPair.EMPTY_PAIR;
        }
        if (bestCount == 1) {
            return bestPair;
        }
        return BSimProgramCorrelatorMatching.findFirstUnconflictedPair(potentialPairs);
    }

    private class MatchingCallback
    implements QCallback<FunctionNode, List<FunctionPair>> {
        private BinningSystem sourceBinning;
        private double simThreshold;

        MatchingCallback(BinningSystem sourceBinning, double simThreshold) {
            this.sourceBinning = sourceBinning;
            this.simThreshold = simThreshold;
        }

        public List<FunctionPair> process(FunctionNode queryNode, TaskMonitor monitor) throws Exception {
            monitor.checkCancelled();
            if (queryNode == null || queryNode.getVector() == null) {
                monitor.incrementProgress(1L);
                return null;
            }
            LinkedList<FunctionPair> associates = new LinkedList<FunctionPair>();
            this.findSimilarNodes(associates, queryNode, monitor);
            monitor.incrementProgress(1L);
            return associates;
        }

        private void findSimilarNodes(List<FunctionPair> results, FunctionNode queryNode, TaskMonitor monitor) throws CancelledException {
            Set<FunctionNode> neighbors = this.sourceBinning.lookup(queryNode);
            VectorCompare veccompare = new VectorCompare();
            for (FunctionNode neighbor : neighbors) {
                monitor.checkCancelled();
                double similarity = neighbor.getVector().compare(queryNode.getVector(), veccompare);
                if (similarity < this.simThreshold) continue;
                double confidence = BSimProgramCorrelatorMatching.this.vectorFactory.calculateSignificance(veccompare);
                FunctionPair newPair = new FunctionPair(neighbor, queryNode, similarity, confidence);
                results.add(newPair);
            }
        }
    }
}

