/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sarif;

import com.contrastsecurity.sarif.ImmutableState;
import com.contrastsecurity.sarif.InitialState;
import com.contrastsecurity.sarif.Message;
import com.contrastsecurity.sarif.PropertyBag;
import com.contrastsecurity.sarif.ThreadFlowLocation;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"id", "message", "initialState", "immutableState", "locations", "properties"})
public class ThreadFlow {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="An string that uniquely identifies the threadFlow within the codeFlow in which it occurs.")
    private String id;
    @JsonProperty(value="message")
    @JsonPropertyDescription(value="Encapsulates a message intended to be read by the end user.")
    private Message message;
    @JsonProperty(value="initialState")
    @JsonPropertyDescription(value="Values of relevant expressions at the start of the thread flow that may change during thread flow execution.")
    private InitialState initialState;
    @JsonProperty(value="immutableState")
    @JsonPropertyDescription(value="Values of relevant expressions at the start of the thread flow that remain constant.")
    private ImmutableState immutableState;
    @JsonProperty(value="locations")
    @JsonPropertyDescription(value="A temporally ordered array of 'threadFlowLocation' objects, each of which describes a location visited by the tool while producing the result.")
    private List<ThreadFlowLocation> locations = null;
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public ThreadFlow withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="message")
    public Message getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(Message message) {
        this.message = message;
    }

    public ThreadFlow withMessage(Message message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="initialState")
    public InitialState getInitialState() {
        return this.initialState;
    }

    @JsonProperty(value="initialState")
    public void setInitialState(InitialState initialState) {
        this.initialState = initialState;
    }

    public ThreadFlow withInitialState(InitialState initialState) {
        this.initialState = initialState;
        return this;
    }

    @JsonProperty(value="immutableState")
    public ImmutableState getImmutableState() {
        return this.immutableState;
    }

    @JsonProperty(value="immutableState")
    public void setImmutableState(ImmutableState immutableState) {
        this.immutableState = immutableState;
    }

    public ThreadFlow withImmutableState(ImmutableState immutableState) {
        this.immutableState = immutableState;
        return this;
    }

    @JsonProperty(value="locations")
    public List<ThreadFlowLocation> getLocations() {
        return this.locations;
    }

    @JsonProperty(value="locations")
    public void setLocations(List<ThreadFlowLocation> locations) {
        this.locations = locations;
    }

    public ThreadFlow withLocations(List<ThreadFlowLocation> locations) {
        this.locations = locations;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public ThreadFlow withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ThreadFlow.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(this.message == null ? "<null>" : this.message);
        sb.append(',');
        sb.append("initialState");
        sb.append('=');
        sb.append(this.initialState == null ? "<null>" : this.initialState);
        sb.append(',');
        sb.append("immutableState");
        sb.append('=');
        sb.append(this.immutableState == null ? "<null>" : this.immutableState);
        sb.append(',');
        sb.append("locations");
        sb.append('=');
        sb.append(this.locations == null ? "<null>" : this.locations);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.initialState == null ? 0 : this.initialState.hashCode());
        result = result * 31 + (this.immutableState == null ? 0 : this.immutableState.hashCode());
        result = result * 31 + (this.locations == null ? 0 : this.locations.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ThreadFlow)) {
            return false;
        }
        ThreadFlow rhs = (ThreadFlow)other;
        return (this.initialState == rhs.initialState || this.initialState != null && this.initialState.equals(rhs.initialState)) && (this.immutableState == rhs.immutableState || this.immutableState != null && this.immutableState.equals(rhs.immutableState)) && (this.locations == rhs.locations || this.locations != null && this.locations.equals(rhs.locations)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.message == rhs.message || this.message != null && this.message.equals(rhs.message)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties));
    }
}

