/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import ghidra.trace.database.target.ImmutableValueBox;
import ghidra.trace.database.target.ValueBox;
import ghidra.trace.database.target.ValueTriple;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.spatial.hyper.Dimension;
import ghidra.util.database.spatial.hyper.EuclideanHyperSpace;
import ghidra.util.database.spatial.hyper.HyperDirection;
import ghidra.util.database.spatial.hyper.LongDimension;
import ghidra.util.database.spatial.hyper.StringDimension;
import ghidra.util.database.spatial.hyper.ULongDimension;
import java.math.BigInteger;
import java.util.List;

enum ValueSpace implements EuclideanHyperSpace<ValueTriple, ValueBox>
{
    INSTANCE;

    static final List<Dimension<?, ValueTriple, ValueBox>> DIMENSIONS;
    static final ValueBox FULL;

    public List<Dimension<?, ValueTriple, ValueBox>> getDimensions() {
        return DIMENSIONS;
    }

    public ValueBox getFull() {
        return FULL;
    }

    public ValueTriple boxCenter(ValueBox box) {
        return new ValueTriple((Long)ParentKeyDimension.INSTANCE.boxMid(box), (Long)ChildKeyDimension.INSTANCE.boxMid(box), (String)EntryKeyDimension.INSTANCE.boxMid(box), (Long)SnapDimension.INSTANCE.boxMid(box), (DBCachedObjectStoreFactory.RecAddress)AddressDimension.INSTANCE.boxMid(box));
    }

    public ValueBox boxUnionBounds(ValueBox a, ValueBox b) {
        ValueTriple lc = new ValueTriple((Long)ParentKeyDimension.INSTANCE.unionLower(a, b), (Long)ChildKeyDimension.INSTANCE.unionLower(a, b), (String)EntryKeyDimension.INSTANCE.unionLower(a, b), (Long)SnapDimension.INSTANCE.unionLower(a, b), (DBCachedObjectStoreFactory.RecAddress)AddressDimension.INSTANCE.unionLower(a, b));
        ValueTriple uc = new ValueTriple((Long)ParentKeyDimension.INSTANCE.unionUpper(a, b), (Long)ChildKeyDimension.INSTANCE.unionUpper(a, b), (String)EntryKeyDimension.INSTANCE.unionUpper(a, b), (Long)SnapDimension.INSTANCE.unionUpper(a, b), (DBCachedObjectStoreFactory.RecAddress)AddressDimension.INSTANCE.unionUpper(a, b));
        return new ImmutableValueBox(lc, uc);
    }

    public ValueBox boxIntersection(ValueBox a, ValueBox b) {
        ValueTriple lc = new ValueTriple((Long)ParentKeyDimension.INSTANCE.intersectionLower(a, b), (Long)ChildKeyDimension.INSTANCE.intersectionLower(a, b), (String)EntryKeyDimension.INSTANCE.intersectionLower(a, b), (Long)SnapDimension.INSTANCE.intersectionLower(a, b), (DBCachedObjectStoreFactory.RecAddress)AddressDimension.INSTANCE.intersectionLower(a, b));
        ValueTriple uc = new ValueTriple((Long)ParentKeyDimension.INSTANCE.intersectionUpper(a, b), (Long)ChildKeyDimension.INSTANCE.intersectionUpper(a, b), (String)EntryKeyDimension.INSTANCE.intersectionUpper(a, b), (Long)SnapDimension.INSTANCE.intersectionUpper(a, b), (DBCachedObjectStoreFactory.RecAddress)AddressDimension.INSTANCE.intersectionUpper(a, b));
        return new ImmutableValueBox(lc, uc);
    }

    static {
        DIMENSIONS = List.of(ParentKeyDimension.INSTANCE, ChildKeyDimension.INSTANCE, EntryKeyDimension.INSTANCE, SnapDimension.INSTANCE, AddressDimension.INSTANCE);
        FULL = new ImmutableValueBox(new ValueTriple(ParentKeyDimension.INSTANCE.absoluteMin(), ChildKeyDimension.INSTANCE.absoluteMin(), EntryKeyDimension.INSTANCE.absoluteMin(), SnapDimension.INSTANCE.absoluteMin(), AddressDimension.INSTANCE.absoluteMin()), new ValueTriple(ParentKeyDimension.INSTANCE.absoluteMax(), ChildKeyDimension.INSTANCE.absoluteMax(), EntryKeyDimension.INSTANCE.absoluteMax(), SnapDimension.INSTANCE.absoluteMax(), AddressDimension.INSTANCE.absoluteMax()));
    }

    static enum ParentKeyDimension implements ULongDimension<ValueTriple, ValueBox>
    {
        INSTANCE;

        public static final HyperDirection FORWARD;
        public static final HyperDirection BACKWARD;

        public Long value(ValueTriple point) {
            return point.parentKey();
        }

        static {
            FORWARD = new HyperDirection(0, true);
            BACKWARD = new HyperDirection(0, false);
        }
    }

    static enum ChildKeyDimension implements ULongDimension<ValueTriple, ValueBox>
    {
        INSTANCE;

        public static final HyperDirection FORWARD;
        public static final HyperDirection BACKWARD;

        public Long value(ValueTriple point) {
            return point.childKey();
        }

        static {
            FORWARD = new HyperDirection(1, true);
            BACKWARD = new HyperDirection(1, false);
        }
    }

    static enum EntryKeyDimension implements StringDimension<ValueTriple, ValueBox>
    {
        INSTANCE;

        public static final HyperDirection FORWARD;
        public static final HyperDirection BACKWARD;

        public String value(ValueTriple point) {
            return point.entryKey();
        }

        static {
            FORWARD = new HyperDirection(2, true);
            BACKWARD = new HyperDirection(2, false);
        }
    }

    static enum SnapDimension implements LongDimension<ValueTriple, ValueBox>
    {
        INSTANCE;

        public static final HyperDirection FORWARD;
        public static final HyperDirection BACKWARD;

        public Long value(ValueTriple point) {
            return point.snap();
        }

        static {
            FORWARD = new HyperDirection(3, true);
            BACKWARD = new HyperDirection(3, false);
        }
    }

    static enum AddressDimension implements Dimension<DBCachedObjectStoreFactory.RecAddress, ValueTriple, ValueBox>
    {
        INSTANCE;

        static final BigInteger MASK_32;
        static final BigInteger MASK_64;
        public static final HyperDirection FORWARD;
        public static final HyperDirection BACKWARD;
        private static final DBCachedObjectStoreFactory.RecAddress MIN;
        private static final DBCachedObjectStoreFactory.RecAddress MAX;

        public DBCachedObjectStoreFactory.RecAddress value(ValueTriple point) {
            return point.address();
        }

        public int compare(DBCachedObjectStoreFactory.RecAddress a, DBCachedObjectStoreFactory.RecAddress b) {
            int c = Integer.compareUnsigned(a.spaceId(), b.spaceId());
            if (c != 0) {
                return c;
            }
            return Long.compareUnsigned(a.offset(), b.offset());
        }

        public double distance(DBCachedObjectStoreFactory.RecAddress a, DBCachedObjectStoreFactory.RecAddress b) {
            double result = b.spaceId() - a.spaceId();
            result *= Math.pow(2.0, 64.0);
            return result += (double)(b.offset() - a.offset());
        }

        static BigInteger addrToBigInt(DBCachedObjectStoreFactory.RecAddress a) {
            return BigInteger.valueOf(a.spaceId()).and(MASK_32).shiftLeft(64).add(BigInteger.valueOf(a.offset()).and(MASK_64));
        }

        static DBCachedObjectStoreFactory.RecAddress bigIntToAddr(BigInteger i) {
            return new DBCachedObjectStoreFactory.RecAddress(i.shiftRight(64).intValue(), i.longValue());
        }

        public DBCachedObjectStoreFactory.RecAddress mid(DBCachedObjectStoreFactory.RecAddress a, DBCachedObjectStoreFactory.RecAddress b) {
            BigInteger biA = AddressDimension.addrToBigInt(a);
            BigInteger biB = AddressDimension.addrToBigInt(b);
            BigInteger biMid = biA.add(biB.subtract(biA).shiftRight(1));
            return AddressDimension.bigIntToAddr(biMid);
        }

        public DBCachedObjectStoreFactory.RecAddress absoluteMin() {
            return MIN;
        }

        public DBCachedObjectStoreFactory.RecAddress absoluteMax() {
            return MAX;
        }

        static {
            MASK_32 = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
            MASK_64 = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
            FORWARD = new HyperDirection(4, true);
            BACKWARD = new HyperDirection(4, false);
            MIN = new DBCachedObjectStoreFactory.RecAddress(0, 0L);
            MAX = new DBCachedObjectStoreFactory.RecAddress(-1, -1L);
        }
    }
}

