/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.task;

import ghidra.framework.task.GScheduledTask;
import ghidra.framework.task.GTaskGroup;
import ghidra.framework.task.GTaskListener;
import ghidra.framework.task.GTaskResult;
import ghidra.util.exception.AssertException;

class MulticastTaskListener
implements GTaskListener {
    private GTaskListener a;
    private GTaskListener b;

    public MulticastTaskListener(GTaskListener a, GTaskListener b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public void taskStarted(GScheduledTask task) {
        this.a.taskStarted(task);
        this.b.taskStarted(task);
    }

    @Override
    public void taskCompleted(GScheduledTask task, GTaskResult result) {
        this.a.taskCompleted(task, result);
        this.b.taskCompleted(task, result);
    }

    @Override
    public void taskGroupScheduled(GTaskGroup group) {
        this.a.taskGroupScheduled(group);
        this.b.taskGroupScheduled(group);
    }

    @Override
    public void taskScheduled(GScheduledTask scheduledTask) {
        this.a.taskScheduled(scheduledTask);
        this.b.taskScheduled(scheduledTask);
    }

    @Override
    public void taskGroupStarted(GTaskGroup taskGroup) {
        this.a.taskGroupStarted(taskGroup);
        this.b.taskGroupStarted(taskGroup);
    }

    public GTaskListener removeListener(GTaskListener listener) {
        if (this.a == listener) {
            return this.b;
        }
        if (this.b == listener) {
            return this.a;
        }
        if (this.a instanceof MulticastTaskListener) {
            MulticastTaskListener ma = (MulticastTaskListener)this.a;
            this.a = ma.removeListener(listener);
        }
        if (this.b instanceof MulticastTaskListener) {
            MulticastTaskListener mb = (MulticastTaskListener)this.b;
            this.b = mb.removeListener(listener);
        }
        return this;
    }

    @Override
    public void initialize() {
        throw new AssertException("Initialize should not be called here.");
    }

    @Override
    public void taskGroupCompleted(GTaskGroup taskGroup) {
        this.a.taskGroupCompleted(taskGroup);
        this.b.taskGroupCompleted(taskGroup);
    }

    @Override
    public void suspendedStateChanged(boolean suspended) {
        this.a.suspendedStateChanged(suspended);
        this.b.suspendedStateChanged(suspended);
    }
}

