/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.ObjectKeyIndexer;
import ghidra.util.datastruct.Prime;
import ghidra.util.exception.NoValueException;

public class ObjectIntHashtable<T> {
    private ObjectKeyIndexer<T> indexer;
    private int[] values;
    private int capacity;

    public ObjectIntHashtable() {
        this(3);
    }

    public ObjectIntHashtable(int capacity) {
        this.capacity = capacity = Prime.nextPrime(capacity);
        this.indexer = new ObjectKeyIndexer(capacity);
        this.values = new int[capacity];
    }

    public void put(T key, int value) {
        int index = this.indexer.put(key);
        if (index >= this.capacity) {
            this.grow();
        }
        this.values[index] = value;
    }

    public int get(T key) throws NoValueException {
        int index = this.indexer.get(key);
        if (index < 0) {
            throw NoValueException.noValueException;
        }
        return this.values[index];
    }

    public boolean remove(T key) {
        return this.indexer.remove(key) >= 0;
    }

    public void removeAll() {
        this.indexer.clear();
    }

    public boolean contains(Object key) {
        return this.indexer.get(key) >= 0;
    }

    public int size() {
        return this.indexer.getSize();
    }

    public T[] getKeys(T[] keyArray) {
        return this.indexer.getKeys(keyArray);
    }

    private void grow() {
        this.capacity = this.indexer.getCapacity();
        int[] oldValues = this.values;
        this.values = new int[this.capacity];
        System.arraycopy(oldValues, 0, this.values, 0, oldValues.length);
    }
}

