/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.data.DataType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.trace.database.listing.AbstractBaseDBTraceCodeUnitsMemoryView;
import ghidra.trace.database.listing.DBTraceCodeManager;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.listing.DBTraceData;
import ghidra.trace.database.listing.DBTraceDataAdapter;
import ghidra.trace.database.listing.DBTraceDefinedDataView;
import ghidra.trace.database.listing.InternalTraceDefinedDataView;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class DBTraceDefinedDataMemoryView
extends AbstractBaseDBTraceCodeUnitsMemoryView<DBTraceData, DBTraceDefinedDataView>
implements InternalTraceDefinedDataView {
    public DBTraceDefinedDataMemoryView(DBTraceCodeManager manager) {
        super(manager);
    }

    @Override
    protected DBTraceDefinedDataView getView(DBTraceCodeSpace space) {
        return space.definedData;
    }

    @Override
    public void clear(Lifespan span, AddressRange range, boolean clearContext, TaskMonitor monitor) throws CancelledException {
        this.delegateDeleteV(range.getAddressSpace(), m -> m.clear(span, range, clearContext, monitor));
    }

    @Override
    public DBTraceDataAdapter create(Lifespan lifespan, Address address, TracePlatform platform, DataType dataType, int length) throws CodeUnitInsertionException {
        return this.delegateWrite(address.getAddressSpace(), m -> m.create(lifespan, address, platform, dataType, length));
    }

    @Override
    public DBTraceDataAdapter create(Lifespan lifespan, Address address, TracePlatform platform, DataType dataType) throws CodeUnitInsertionException {
        return this.delegateWrite(address.getAddressSpace(), m -> m.create(lifespan, address, platform, dataType));
    }
}

