/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;

public class SegmentedCallingConventionAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Segmented X86 Calling Conventions";
    private static final String DESCRIPTION = "Analyzes X86 programs with segmented address spaces to identify a calling convention for each function.  This analyzer looks at the type of return used for the function to identify the calling convention.";

    public SegmentedCallingConventionAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.FUNCTION_ANALYZER);
        this.setDefaultEnablement(true);
        this.setSupportsOneTimeAnalysis();
    }

    @Override
    public boolean canAnalyze(Program program) {
        return program.getMinAddress() instanceof SegmentedAddress && program.getLanguage().supportsPcode();
    }

    void checkReturn(Program program, Instruction instr) {
        String mnemonic = instr.getMnemonicString().toLowerCase();
        if (mnemonic.startsWith("ret")) {
            Function func;
            String convention = null;
            int b = 0;
            try {
                b = program.getMemory().getByte(instr.getMinAddress()) & 0xFF;
            }
            catch (MemoryAccessException e) {
                return;
            }
            switch (b) {
                case 202: {
                    convention = "__stdcall16far";
                    break;
                }
                case 203: {
                    convention = "__cdecl16far";
                    break;
                }
                case 195: {
                    convention = "__cdecl16near";
                    break;
                }
                case 194: {
                    convention = "__stdcall16near";
                }
            }
            if (convention != null && (func = program.getFunctionManager().getFunctionContaining(instr.getMinAddress())) != null) {
                try {
                    func.setCallingConvention(convention);
                }
                catch (InvalidInputException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                }
            }
            return;
        }
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        InstructionIterator instructions = program.getListing().getInstructions(set, true);
        while (instructions.hasNext()) {
            Instruction next = instructions.next();
            this.checkReturn(program, next);
        }
        return true;
    }
}

