/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.relocs;

import com.google.gson.JsonElement;
import ghidra.program.model.reloc.Relocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import sarif.export.AbstractExtWriter;
import sarif.export.SarifObject;
import sarif.export.relocs.ExtRelocation;
import sarif.managers.RelocationTableSarifMgr;

public class SarifRelocationWriter
extends AbstractExtWriter {
    List<Relocation> relocs;

    public SarifRelocationWriter(List<Relocation> request, Writer baseWriter) throws IOException {
        super(baseWriter);
        this.relocs = request;
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genRelocation(monitor);
        this.root.add("relocations", (JsonElement)this.objects);
    }

    private void genRelocation(TaskMonitor monitor) throws CancelledException, IOException {
        monitor.initialize((long)this.relocs.size());
        for (Relocation r : this.relocs) {
            ExtRelocation isf = new ExtRelocation(r);
            SarifObject sarif = new SarifObject(RelocationTableSarifMgr.SUBKEY, RelocationTableSarifMgr.KEY, this.getTree(isf), r.getAddress(), r.getAddress());
            this.objects.add(this.getTree(sarif));
            monitor.increment();
        }
    }
}

