/*
 * Decompiled with CFR 0.152.
 */
package generic.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;

public class QResult<I, R> {
    private final I item;
    private final R result;
    private final Exception error;

    public QResult(I item, Future<R> future) {
        Exception tempError;
        R tempResult;
        this.item = item;
        try {
            tempResult = future.get();
            tempError = null;
        }
        catch (Exception e) {
            tempError = e;
            tempResult = null;
        }
        this.result = tempResult;
        this.error = tempError;
    }

    public I getItem() {
        return this.item;
    }

    public R getResult() throws Exception {
        if (this.hasError()) {
            throw this.error;
        }
        return this.result;
    }

    public Exception getError() {
        return this.hasError() ? this.error : null;
    }

    public boolean hasError() {
        return this.error != null && !(this.error instanceof CancellationException);
    }

    public boolean isCancelled() {
        return this.error instanceof CancellationException;
    }
}

