/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;

public abstract class RecordNumber {
    public static final int T_NOTYPE = 0;
    public static final int T_VOID = 3;
    public static final RecordNumber NO_TYPE = new TypeRecordNumber(0);
    private final int number;

    public static RecordNumber typeRecordNumber(int number) {
        if (number == 0) {
            return NO_TYPE;
        }
        return new TypeRecordNumber(number);
    }

    public static RecordNumber itemRecordNumber(int number) {
        if (number == 0) {
            return NO_TYPE;
        }
        return new ItemRecordNumber(number);
    }

    public static RecordNumber make(RecordCategory cat, int number) {
        switch (cat) {
            case TYPE: {
                return RecordNumber.typeRecordNumber(number);
            }
            case ITEM: {
                return RecordNumber.itemRecordNumber(number);
            }
        }
        throw new IllegalArgumentException();
    }

    public static RecordNumber parse(AbstractPdb pdb, PdbByteReader reader, RecordCategory category, int size) throws PdbException {
        int number = reader.parseVarSizedInt(size);
        RecordNumber recordNumber = RecordNumber.make(category, number);
        pdb.getPdbReaderMetrics().witnessRecordNumber(recordNumber);
        return recordNumber;
    }

    public static RecordNumber parseNoWitness(AbstractPdb pdb, PdbByteReader reader, RecordCategory category, int size) throws PdbException {
        int number = reader.parseVarSizedInt(size);
        RecordNumber recordNumber = RecordNumber.make(category, number);
        return recordNumber;
    }

    protected RecordNumber(int number) {
        this.number = number;
    }

    public abstract RecordCategory getCategory();

    public int getNumber() {
        return this.number;
    }

    public boolean isNoType() {
        return this.number == 0;
    }

    public String toString() {
        return String.format("%s[%d]", this.getCategory().name(), this.getNumber());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.number;
        result = 31 * result + this.getCategory().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecordNumber other = (RecordNumber)obj;
        return this.number == other.number && this.getCategory() == other.getCategory();
    }

    private static class TypeRecordNumber
    extends RecordNumber {
        public TypeRecordNumber(int number) {
            super(number);
        }

        @Override
        public RecordCategory getCategory() {
            return RecordCategory.TYPE;
        }
    }

    private static class ItemRecordNumber
    extends RecordNumber {
        public ItemRecordNumber(int number) {
            super(number);
        }

        @Override
        public RecordCategory getCategory() {
            return RecordCategory.ITEM;
        }
    }
}

