#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-JEO3xVXdijOBxslij5jx5t
key:                  gitit-0.15.1.2-JEO3xVXdijOBxslij5jx5t
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  8691a7e4409b78b0b7b5e02b02d1e07b
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.6.6/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-JEO3xVXdijOBxslij5jx5t
depends:
    HStringTemplate-0.8.8-CWs29XuhsprBU4ERpSwFSJ
    HTTP-4000.4.1-3MTyhsag9CkG76BmGHJRVm
    SHA-1.6.4.4-KRZJCS52poaHfqPlW5b8Sg
    aeson-2.2.0.0-4qLATSA6nfj1RfgXH6DMKK base-4.18.2.1
    base64-bytestring-1.2.1.0-6srVB7ZKmzD1HZV2AV5j9d
    blaze-html-0.9.2.0-BSUXMYxgqldK7Fv9A0AXBj bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.8.5
    doctemplates-0.11.0.1-A0yNC6vskCsnuNlcpxplZ
    feed-1.3.2.1-580L4hxXjda4S8FyhvN35W filepath-1.4.300.1
    filestore-0.6.5.1-LTrK8PZCNVw3IAY6NOPbRa ghc-9.6.6
    ghc-paths-0.1.0.12-JSGGj7CcxjZ2Iy0LlOG5cZ
    happstack-server-7.9.3-4q9fV0qVGtU9VRGCvKTkCk
    hoauth2-2.14.0-AtFCvnWsDn067qVkYnPs3X
    hslogger-1.3.2.0-AztfaQnwD62z354lZ5jme
    http-client-tls-0.3.6.4-LhFztqm7Yl955SnS7vNn0b
    http-conduit-2.3.9.1-3cMmWLkkkkTQL61v9H7Y4
    json-0.10-7lFt8ItKbDgLMnqKq7Lbys mtl-2.3.1
    network-3.1.4.0-LsWsY6caX6uCNLTGwySDR3
    network-bsd-2.8.1.0-D7SZrPYxhMR2DXknTcXx6t
    network-uri-2.6.4.2-3U0FvLc2coZ6tqjF5PGDly
    old-locale-1.0.0.7-Gunit3UBy5P9OGDVFY5MhC
    old-time-1.1.0.4-3lD0LwNFkdkGhWCMuxpBlx
    pandoc-3.5-ECevCsGe5Y93NXYWFCHLgj
    pandoc-types-1.23.1-AOoNyo1PJrkKwLhWFhFLpF parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.19.0
    random-1.2.1.3-HzFGhfPSv5b3eeTVe0g48p
    recaptcha-0.1.0.4-3rmvN94la2h9xieddsUqT5
    safe-0.3.21-WYqCEMpsX24yfPdI1X0Hh
    skylighting-0.14.3-2QUCR90tlBBbTL4blHnSD
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8 syb-0.7.3-HezvxMxFoxE4YYIFSuLToH
    tagsoup-0.14.8-4wbuepjIYFCCy5VT0j43hw
    temporary-1.3-7FXkQQKerYU7UfmRyKNwo9 text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-5iiSPjSVMGB7CkzZIodsyK
    url-2.1.3-7Kl4E3eXP9D927NfHGnLmQ
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1
    uuid-1.3.16-8QPIjurlhvP3hDFUxOgViN xhtml-3000.2.2.1
    xml-1.3.14-3CsuYrgQlhu1X5fBOwcswt
    xml-conduit-1.9.1.4-7ee0415noOoF6jmR1KcA0M
    xml-types-0.3.8-ISf6rjkeTjSFXsXdIGBwau
    xss-sanitize-0.3.7.2-3ee871HD590A3csUfOkl8b
    zlib-0.7.0.0-AoTprguvpA33AfeZgt1J6J

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

