/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.AbstractModuleDescriptorParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.DescriptorParseContext;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.GradlePomModuleDescriptorBuilder;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.PomReader;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.data.MavenDependencyKey;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.data.PomDependencyMgt;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.MavenVersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenMutableModuleMetadataFactory;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.maven.MavenDependencyDescriptor;
import org.gradle.internal.component.external.model.maven.MutableMavenModuleResolveMetadata;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class GradlePomModuleDescriptorParser
extends AbstractModuleDescriptorParser<MutableMavenModuleResolveMetadata> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GradlePomModuleDescriptorParser.class);
    private static final String DEPENDENCY_IMPORT_SCOPE = "import";
    private final VersionSelectorScheme gradleVersionSelectorScheme;
    private final VersionSelectorScheme mavenVersionSelectorScheme;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final MavenMutableModuleMetadataFactory metadataFactory;

    public GradlePomModuleDescriptorParser(VersionSelectorScheme gradleVersionSelectorScheme, ImmutableModuleIdentifierFactory moduleIdentifierFactory, FileResourceRepository fileResourceRepository, MavenMutableModuleMetadataFactory metadataFactory) {
        super(fileResourceRepository);
        this.gradleVersionSelectorScheme = gradleVersionSelectorScheme;
        this.mavenVersionSelectorScheme = new MavenVersionSelectorScheme(gradleVersionSelectorScheme);
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.metadataFactory = metadataFactory;
    }

    @Override
    protected String getTypeName() {
        return "POM";
    }

    public String toString() {
        return "gradle pom parser";
    }

    @Override
    protected MetaDataParser.ParseResult<MutableMavenModuleResolveMetadata> doParseDescriptor(DescriptorParseContext parserSettings, LocallyAvailableExternalResource resource, boolean validate) throws IOException, ParseException, SAXException {
        PomReader pomReader = new PomReader(resource, this.moduleIdentifierFactory);
        GradlePomModuleDescriptorBuilder mdBuilder = new GradlePomModuleDescriptorBuilder(pomReader, this.gradleVersionSelectorScheme, this.mavenVersionSelectorScheme);
        this.doParsePom(parserSettings, mdBuilder, pomReader);
        List<MavenDependencyDescriptor> dependencies = mdBuilder.getDependencies();
        ModuleComponentIdentifier cid = mdBuilder.getComponentIdentifier();
        MutableMavenModuleResolveMetadata metadata = this.metadataFactory.create(cid, dependencies);
        metadata.setStatus(mdBuilder.getStatus());
        if (pomReader.getRelocation() != null) {
            metadata.setPackaging("pom");
            metadata.setRelocated(true);
        } else {
            metadata.setPackaging(pomReader.getPackaging());
            metadata.setRelocated(false);
        }
        return MetaDataParser.ParseResult.of(metadata, pomReader.hasGradleMetadataMarker());
    }

    private void doParsePom(DescriptorParseContext parserSettings, GradlePomModuleDescriptorBuilder mdBuilder, PomReader pomReader) throws IOException, SAXException {
        pomReader.resolveGAV();
        String groupId = pomReader.getGroupId();
        String artifactId = pomReader.getArtifactId();
        String version = pomReader.getVersion();
        if (pomReader.hasParent()) {
            String parentGroupId = pomReader.getParentGroupId();
            String parentArtifactId = pomReader.getParentArtifactId();
            String parentVersion = pomReader.getParentVersion();
            if (!(Objects.equals(parentGroupId, groupId) && Objects.equals(parentArtifactId, artifactId) && Objects.equals(parentVersion, version))) {
                ModuleComponentSelector parentId = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(parentGroupId, parentArtifactId), new DefaultImmutableVersionConstraint(parentVersion));
                PomReader parentPomReader = this.parsePomForSelector(parserSettings, parentId, pomReader.getAllPomProperties());
                pomReader.setPomParent(parentPomReader);
                pomReader.resolveGAV();
                groupId = pomReader.getGroupId();
                artifactId = pomReader.getArtifactId();
                version = pomReader.getVersion();
            }
        }
        mdBuilder.setModuleRevId(groupId, artifactId, version);
        ModuleVersionIdentifier relocation = pomReader.getRelocation();
        if (relocation != null) {
            if (groupId != null && artifactId != null && artifactId.equals(relocation.getName()) && groupId.equals(relocation.getGroup())) {
                LOGGER.error("POM relocation to an other version number is not fully supported in Gradle : {} relocated to {}.", (Object)mdBuilder.getComponentIdentifier(), (Object)relocation);
                LOGGER.warn("Please update your dependency to directly use the correct version '{}'.", (Object)relocation);
                LOGGER.warn("Resolution will only pick dependencies of the relocated element.  Artifacts and other metadata will be ignored.");
                PomReader relocatedModule = this.parsePomForId(parserSettings, DefaultModuleComponentIdentifier.newId(relocation), new HashMap<String, String>());
                this.addDependencies(mdBuilder, relocatedModule);
            } else {
                LOGGER.info(mdBuilder.getComponentIdentifier() + " is relocated to " + relocation + ". Please update your dependencies.");
                LOGGER.debug("Relocated module will be considered as a dependency");
                ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(relocation.getGroup(), relocation.getName()), new DefaultMutableVersionConstraint(relocation.getVersion()));
                mdBuilder.addDependencyForRelocation(selector);
            }
        } else {
            this.overrideDependencyMgtsWithImported(parserSettings, pomReader);
            this.addDependencies(mdBuilder, pomReader);
        }
    }

    private void addDependencies(GradlePomModuleDescriptorBuilder mdBuilder, PomReader pomReader) {
        for (PomDependencyMgt dependencyMgt : pomReader.getDependencyMgt().values()) {
            if (this.isDependencyImportScoped(dependencyMgt)) continue;
            mdBuilder.addConstraint(dependencyMgt);
        }
        for (PomReader.PomDependencyData dependency : pomReader.getDependencies().values()) {
            mdBuilder.addDependency(dependency);
        }
    }

    private void overrideDependencyMgtsWithImported(DescriptorParseContext parseContext, PomReader pomReader) throws IOException, SAXException {
        Map<MavenDependencyKey, PomDependencyMgt> importedDependencyMgts = this.parseImportedDependencyMgts(parseContext, pomReader.parseDependencyMgt());
        pomReader.addImportedDependencyMgts(importedDependencyMgts);
    }

    private Map<MavenDependencyKey, PomDependencyMgt> parseImportedDependencyMgts(DescriptorParseContext parseContext, Collection<PomDependencyMgt> currentDependencyMgts) throws IOException, SAXException {
        LinkedHashMap<MavenDependencyKey, PomDependencyMgt> importedDependencyMgts = new LinkedHashMap<MavenDependencyKey, PomDependencyMgt>();
        for (PomDependencyMgt currentDependencyMgt : currentDependencyMgts) {
            if (!this.isDependencyImportScoped(currentDependencyMgt)) continue;
            ModuleComponentSelector importedId = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(currentDependencyMgt.getGroupId(), currentDependencyMgt.getArtifactId()), new DefaultImmutableVersionConstraint(currentDependencyMgt.getVersion()));
            PomReader importedPom = this.parsePomForSelector(parseContext, importedId, new HashMap<String, String>());
            for (Map.Entry<MavenDependencyKey, PomDependencyMgt> entry : importedPom.getDependencyMgt().entrySet()) {
                if (importedDependencyMgts.containsKey(entry.getKey())) continue;
                importedDependencyMgts.put(entry.getKey(), entry.getValue());
            }
        }
        return importedDependencyMgts;
    }

    private boolean isDependencyImportScoped(PomDependencyMgt dependencyMgt) {
        return DEPENDENCY_IMPORT_SCOPE.equals(dependencyMgt.getScope());
    }

    private PomReader parsePomForId(DescriptorParseContext parseContext, ModuleComponentIdentifier identifier, Map<String, String> childProperties) throws IOException, SAXException {
        return this.parsePomResource(parseContext, parseContext.getMetaDataArtifact(identifier, ArtifactType.MAVEN_POM), childProperties);
    }

    private PomReader parsePomForSelector(DescriptorParseContext parseContext, ModuleComponentSelector selector, Map<String, String> childProperties) throws IOException, SAXException {
        VersionSelector acceptor = this.mavenVersionSelectorScheme.parseSelector(selector.getVersion());
        LocallyAvailableExternalResource localResource = parseContext.getMetaDataArtifact(selector, acceptor, ArtifactType.MAVEN_POM);
        return this.parsePomResource(parseContext, localResource, childProperties);
    }

    private PomReader parsePomResource(DescriptorParseContext parseContext, LocallyAvailableExternalResource localResource, Map<String, String> childProperties) throws SAXException, IOException {
        PomReader pomReader = new PomReader(localResource, this.moduleIdentifierFactory, childProperties);
        GradlePomModuleDescriptorBuilder mdBuilder = new GradlePomModuleDescriptorBuilder(pomReader, this.gradleVersionSelectorScheme, this.mavenVersionSelectorScheme);
        this.doParsePom(parseContext, mdBuilder, pomReader);
        return pomReader;
    }
}

