#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 storablevector
version:              0.2.13.2
visibility:           public
id:                   storablevector-0.2.13.2-4foRAtWzWtv6AvH9Vcvmuq
key:                  storablevector-0.2.13.2-4foRAtWzWtv6AvH9Vcvmuq
license:              BSD-3-Clause
maintainer:           Henning Thielemann <storablevector@henning-thielemann.de>
author:
    Spencer Janssen <sjanssen@cse.unl.edu>, Henning Thielemann <storablevector@henning-thielemann.de>

stability:            Experimental
homepage:             http://www.haskell.org/haskellwiki/Storable_Vector
synopsis:
    Fast, packed, strict storable arrays with a list interface like ByteString

description:
    Fast, packed, strict storable arrays
    with a list interface,
    a chunky lazy list interface with variable chunk size
    and an interface for write access via the @ST@ monad.
    This is much like @bytestring@ and @binary@
    but can be used for every '\''Foreign.Storable.Storable'\'' type.
    See also package
    <http://hackage.haskell.org/package/vector>
    with a similar intention.

    We do not provide advanced fusion optimization,
    since especially for lazy vectors
    this would either be incorrect or not applicable.
    However we provide fusion with lazy lists in the package
    <http://hackage.haskell.org/package/storablevector-streamfusion>.

category:             Data
abi:                  5cb5cc36cf0015ef944d37994ff57c57
exposed:              True
exposed-modules:
    Data.StorableVector Data.StorableVector.Base
    Data.StorableVector.Lazy Data.StorableVector.Lazy.Builder
    Data.StorableVector.Lazy.Pattern Data.StorableVector.Lazy.Pointer
    Data.StorableVector.Lazy.Typed Data.StorableVector.Pointer
    Data.StorableVector.ST.Lazy Data.StorableVector.ST.Strict

hidden-modules:
    Data.StorableVector.Memory Data.StorableVector.ST.Private
    Data.StorableVector.Lazy.PointerPrivate
    Data.StorableVector.Lazy.PointerPrivateIndex
    Data.StorableVector.Cursor

import-dirs:          /usr/lib/ghc-9.6.6/site-local/storablevector-0.2.13.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/storablevector-0.2.13.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/storablevector-0.2.13.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-storablevector
hs-libraries:         HSstorablevector-0.2.13.2-4foRAtWzWtv6AvH9Vcvmuq
depends:
    QuickCheck-2.15.0.1-6GEGPgW6PY5CA5PnU98uYH base-4.18.2.1
    deepseq-1.4.8.1 non-negative-0.1.2-9huYFJxuOBBLBgV0xW5wbG
    syb-0.7.3-HezvxMxFoxE4YYIFSuLToH transformers-0.6.1.0
    unsafe-0.0-BBDazQPXbQ7ErhLr2KtCI4
    utility-ht-0.0.17.2-HbCwTDUiMmdBgY2yAWi26t

haddock-interfaces:
    /usr/share/doc/haskell-storablevector/html/storablevector.haddock

haddock-html:         /usr/share/doc/haskell-storablevector/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

