/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.k2.codeinsight.intentions.ConvertReceiverParameterToContextParameterIntention;
import org.jetbrains.kotlin.idea.k2.codeinsight.intentions.contexts.ContextParameterUtils;
import org.jetbrains.kotlin.idea.k2.refactoring.UtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.changeSignature.KotlinChangeInfo;
import org.jetbrains.kotlin.idea.k2.refactoring.changeSignature.KotlinChangeSignatureProcessor;
import org.jetbrains.kotlin.idea.k2.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertReceiverParameterToContextParameterIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "startInWriteAction", "", "isApplicableTo", "element", "caretOffset", "", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "configureChangeInfo", "changeInfo", "Lorg/jetbrains/kotlin/idea/k2/refactoring/changeSignature/KotlinChangeInfo;", "renameLastContextParameter", "ktCallable", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "intellij.kotlin.codeInsight.intentions"})
@SourceDebugExtension(value={"SMAP\nConvertReceiverParameterToContextParameterIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertReceiverParameterToContextParameterIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertReceiverParameterToContextParameterIntention\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,63:1\n249#2:64\n*S KotlinDebug\n*F\n+ 1 ConvertReceiverParameterToContextParameterIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertReceiverParameterToContextParameterIntention\n*L\n35#1:64\n*E\n"})
public final class ConvertReceiverParameterToContextParameterIntention
extends SelfTargetingIntention<KtTypeReference>
implements LowPriorityAction {
    public ConvertReceiverParameterToContextParameterIntention() {
        super(KtTypeReference.class, KotlinBundle.messagePointer((String)"convert.receiver.parameter.to.context.parameter", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public boolean isApplicableTo(@NotNull KtTypeReference element, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)element).supportsFeature(LanguageFeature.ContextParameters)) {
            return false;
        }
        PsiElement psiElement = element.getParent();
        KtNamedFunction ktNamedFunction = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
        return Intrinsics.areEqual((Object)(ktNamedFunction != null ? ktNamedFunction.getReceiverTypeReference() : null), (Object)element);
    }

    @Override
    public void applyTo(@NotNull KtTypeReference element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
        boolean $i$f$getStrictParentOfType = false;
        KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallableDeclaration.class, (boolean)true);
        if (ktCallableDeclaration == null) {
            return;
        }
        KtCallableDeclaration ktCallable = ktCallableDeclaration;
        KotlinChangeInfo kotlinChangeInfo = ContextParameterUtils.INSTANCE.createChangeInfo(ktCallable);
        if (kotlinChangeInfo == null) {
            return;
        }
        KotlinChangeInfo changeInfo = kotlinChangeInfo;
        if (!this.configureChangeInfo(changeInfo)) {
            return;
        }
        Object object = element.getProject();
        Object it = object = new KotlinChangeSignatureProcessor(changeInfo, element, this, ktCallable, editor, (Project)object){
            final /* synthetic */ KtTypeReference $element;
            final /* synthetic */ ConvertReceiverParameterToContextParameterIntention this$0;
            final /* synthetic */ KtCallableDeclaration $ktCallable;
            final /* synthetic */ Editor $editor;
            {
                this.$element = $element;
                this.this$0 = $receiver;
                this.$ktCallable = $ktCallable;
                this.$editor = $editor;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1, $changeInfo);
            }

            protected void performRefactoring(UsageInfo[] usages2) {
                Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
                super.performRefactoring(usages2);
                Project project = this.$element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                DumbService.Companion.getInstance(project).smartInvokeLater(() -> applyTo.1.performRefactoring$lambda$0(this.this$0, this.$ktCallable, this.$editor));
            }

            private static final void performRefactoring$lambda$0(ConvertReceiverParameterToContextParameterIntention this$0, KtCallableDeclaration $ktCallable, Editor $editor) {
                ConvertReceiverParameterToContextParameterIntention.access$renameLastContextParameter(this$0, $ktCallable, $editor);
            }
        };
        boolean bl = false;
        it.setPrepareSuccessfulSwingThreadCallback(ConvertReceiverParameterToContextParameterIntention::applyTo$lambda$0$0);
        object.run();
    }

    private final boolean configureChangeInfo(KotlinChangeInfo changeInfo) {
        KotlinParameterInfo kotlinParameterInfo = changeInfo.getOldReceiverInfo();
        if (kotlinParameterInfo == null) {
            return false;
        }
        KotlinParameterInfo oldReceiverInfo = kotlinParameterInfo;
        changeInfo.setReceiverParameterInfo((KotlinParameterInfo)null);
        oldReceiverInfo.setContextParameter(true);
        return true;
    }

    private final void renameLastContextParameter(KtCallableDeclaration ktCallable, Editor editor) {
        if (!ktCallable.isValid() || editor == null || editor.isDisposed()) {
            return;
        }
        KtParameter ktParameter = ContextParameterUtils.INSTANCE.getContextParameters(ktCallable);
        if (ktParameter == null || (ktParameter = (KtParameter)CollectionsKt.lastOrNull(ktParameter)) == null) {
            return;
        }
        KtParameter lastContextParameter = ktParameter;
        UtilsKt.renameParameter(lastContextParameter, editor);
    }

    private static final void applyTo$lambda$0$0() {
    }

    public static final /* synthetic */ void access$renameLastContextParameter(ConvertReceiverParameterToContextParameterIntention $this, KtCallableDeclaration ktCallable, Editor editor) {
        $this.renameLastContextParameter(ktCallable, editor);
    }
}

