/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.ReplaceCallFixUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.ReplaceImplicitReceiverCallFix;
import org.jetbrains.kotlin.idea.quickfix.ReplaceInfixOrOperatorCallFix;
import org.jetbrains.kotlin.idea.quickfix.ReplaceWithSafeCallFix;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceWithSafeCallFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
public final class ReplaceWithSafeCallFixFactory
extends KotlinSingleIntentionActionFactory {
    @NotNull
    public static final ReplaceWithSafeCallFixFactory INSTANCE = new ReplaceWithSafeCallFixFactory();

    private ReplaceWithSafeCallFixFactory() {
    }

    @Override
    @Nullable
    protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
        KtDotQualifiedExpression qualifiedExpression;
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement = diagnostic.getPsiElement();
        PsiElement psiElement2 = psiElement.getParent();
        KtDotQualifiedExpression ktDotQualifiedExpression = qualifiedExpression = psiElement2 instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement2 : null;
        if (qualifiedExpression != null) {
            KtCallExpression call2 = UtilsKt.getCallExpression((KtQualifiedExpression)qualifiedExpression);
            if (call2 != null) {
                BindingContext context2 = ResolutionUtils.analyze((KtElement)qualifiedExpression, BodyResolveMode.PARTIAL);
                Project project = psiElement.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
                Object[] objectArray = new Object[]{qualifiedExpression.getReceiverExpression(), call2};
                KtExpression safeQualifiedExpression = CreateByPatternKt.createExpressionByPattern((KtPsiFactory)psiFactory, (String)"$0?.$1", (Object[])objectArray, (boolean)false);
                BindingContext newContext = ExtendedResolutionApiKt.analyzeAsReplacement$default(safeQualifiedExpression, (KtExpression)qualifiedExpression, context2, null, null, null, 28, null);
                ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)safeQualifiedExpression), (BindingContext)newContext);
                boolean bl = resolvedCall != null ? UtilsKt.canBeReplacedWithInvokeCall((ResolvedCall<? extends CallableDescriptor>)resolvedCall) : false;
                if (bl) {
                    return new ReplaceInfixOrOperatorCallFix((KtExpression)call2, ReplaceCallFixUtilsKt.shouldHaveNotNullType((KtExpression)call2), null, 4, null).asIntention();
                }
            }
            return new ReplaceWithSafeCallFix(qualifiedExpression, ReplaceCallFixUtilsKt.shouldHaveNotNullType((KtExpression)qualifiedExpression)).asIntention();
        }
        if (!(psiElement instanceof KtNameReferenceExpression)) {
            return null;
        }
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)psiElement), (BindingContext)ResolutionUtils.analyze$default((KtElement)psiElement, null, 1, null));
        if ((resolvedCall != null ? ResolvedCallUtilKt.getImplicitReceiverValue((ResolvedCall)resolvedCall) : null) != null) {
            PsiElement psiElement3 = ((KtNameReferenceExpression)psiElement).getParent();
            KtCallExpression ktCallExpression = psiElement3 instanceof KtCallExpression ? (KtCallExpression)psiElement3 : null;
            KtExpression expressionToReplace = ktCallExpression != null ? (KtExpression)ktCallExpression : (KtExpression)psiElement;
            return new ReplaceImplicitReceiverCallFix(expressionToReplace, ReplaceCallFixUtilsKt.shouldHaveNotNullType(expressionToReplace)).asIntention();
        }
        return null;
    }
}

