/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.branch.BranchStorage;
import com.intellij.dvcs.branch.BranchType;
import com.intellij.dvcs.branch.DvcsBranchInfo;
import com.intellij.dvcs.branch.DvcsBranchSettings;
import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsBranchManager<T extends Repository> {
    private static final Logger LOG = Logger.getInstance(DvcsBranchManager.class);
    private final AbstractRepositoryManager<T> myRepositoryManager;
    @NotNull
    private final DvcsBranchSettings myBranchSettings;
    @NotNull
    private final Map<BranchType, Collection<String>> myPredefinedFavoriteBranches;
    @NotNull
    protected final Project myProject;
    @NotNull
    public static final Topic<DvcsBranchManagerListener> DVCS_BRANCH_SETTINGS_CHANGED = Topic.create((String)"Branch settings changed", DvcsBranchManagerListener.class);

    protected DvcsBranchManager(@NotNull Project project, @NotNull DvcsBranchSettings settings, BranchType @NotNull [] branchTypes, @NotNull AbstractRepositoryManager<T> repositoryManager) {
        if (project == null) {
            DvcsBranchManager.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            DvcsBranchManager.$$$reportNull$$$0(1);
        }
        if (repositoryManager == null) {
            DvcsBranchManager.$$$reportNull$$$0(2);
        }
        if (branchTypes == null) {
            DvcsBranchManager.$$$reportNull$$$0(3);
        }
        this.myPredefinedFavoriteBranches = new HashMap<BranchType, Collection<String>>();
        this.myProject = project;
        this.myBranchSettings = settings;
        this.myRepositoryManager = repositoryManager;
        for (BranchType type : branchTypes) {
            Collection predefinedFavoriteBranches = this.myPredefinedFavoriteBranches.computeIfAbsent(type, __ -> new HashSet());
            for (String branchName : this.getDefaultBranchNames(type)) {
                if (StringUtil.isEmptyOrSpaces((String)branchName)) continue;
                predefinedFavoriteBranches.add(branchName);
            }
            this.myPredefinedFavoriteBranches.put(type, predefinedFavoriteBranches);
        }
    }

    protected Collection<String> getDefaultBranchNames(@NotNull BranchType type) {
        if (type == null) {
            DvcsBranchManager.$$$reportNull$$$0(4);
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isFavorite(@Nullable BranchType branchType, @Nullable Repository repository, @NotNull String branchName) {
        VirtualFile root;
        if (branchName == null) {
            DvcsBranchManager.$$$reportNull$$$0(5);
        }
        if (branchType == null) {
            return false;
        }
        String branchTypeName = branchType.getName();
        VirtualFile virtualFile = root = repository == null ? null : repository.getRoot();
        if (this.myBranchSettings.getFavorites().contains(branchTypeName, root, branchName)) {
            return true;
        }
        if (this.myBranchSettings.getExcludedFavorites().contains(branchTypeName, root, branchName)) {
            return false;
        }
        return this.isPredefinedAsFavorite(branchType, branchName);
    }

    @NotNull
    public @NotNull Set<@NotNull String> getFavoriteRefs(@NotNull BranchType refType, @NotNull Repository repository) {
        if (refType == null) {
            DvcsBranchManager.$$$reportNull$$$0(6);
        }
        if (repository == null) {
            DvcsBranchManager.$$$reportNull$$$0(7);
        }
        HashSet<String> result = new HashSet<String>(this.myPredefinedFavoriteBranches.getOrDefault(refType, Collections.emptyList()));
        Map favorites = this.myBranchSettings.getFavorites().getBranches();
        Map excludedFavorites = this.myBranchSettings.getExcludedFavorites().getBranches();
        String repoPath = DvcsBranchUtil.getPathFor(repository);
        for (DvcsBranchInfo info : ContainerUtil.notNullize((List)((List)favorites.get(refType.getName())))) {
            if (!info.repoPath.equals(repoPath)) continue;
            result.add(info.sourceName);
        }
        for (DvcsBranchInfo info : ContainerUtil.notNullize((List)((List)excludedFavorites.get(refType.getName())))) {
            if (!info.repoPath.equals(repoPath)) continue;
            result.remove(info.sourceName);
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            DvcsBranchManager.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    public @NotNull Map<@NotNull T, @NotNull Set<@NotNull String>> getFavoriteBranches(@NotNull BranchType branchType) {
        if (branchType == null) {
            DvcsBranchManager.$$$reportNull$$$0(9);
        }
        Map<T, List<String>> favorites = this.collectBranchesByRoot(this.myBranchSettings.getFavorites(), branchType);
        Map<T, List<String>> excludedFavorites = this.collectBranchesByRoot(this.myBranchSettings.getExcludedFavorites(), branchType);
        Collection<String> predefinedFavorites = this.myPredefinedFavoriteBranches.get(branchType);
        HashMap result = new HashMap();
        for (Repository repo : this.myRepositoryManager.getRepositories()) {
            HashSet<String> branches = new HashSet<String>();
            if (predefinedFavorites != null) {
                branches.addAll(predefinedFavorites);
            }
            List repoExcludedFavorites = ContainerUtil.notNullize(excludedFavorites.get(repo));
            for (String repoExcludedFavorite : repoExcludedFavorites) {
                branches.remove(repoExcludedFavorite);
            }
            List repoFavorites = ContainerUtil.notNullize(favorites.get(repo));
            branches.addAll(repoFavorites);
            result.put(repo, branches);
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            DvcsBranchManager.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    @NotNull
    private Map<T, List<String>> collectBranchesByRoot(@NotNull BranchStorage storage, @NotNull BranchType branchType) {
        if (storage == null) {
            DvcsBranchManager.$$$reportNull$$$0(11);
        }
        if (branchType == null) {
            DvcsBranchManager.$$$reportNull$$$0(12);
        }
        List infos = ContainerUtil.notNullize((List)((List)storage.getBranches().get(branchType.getName())));
        HashMap<String, List> infoByPath = new HashMap<String, List>();
        for (DvcsBranchInfo info : infos) {
            List list2 = infoByPath.computeIfAbsent(info.repoPath, key -> new ArrayList());
            list2.add(info.sourceName);
        }
        HashMap<Repository, List> infoByRepo = new HashMap<Repository, List>();
        List<T> allRepos = this.myRepositoryManager.getRepositories();
        List allRepoFavorites = ContainerUtil.notNullize((List)((List)infoByPath.remove(DvcsBranchUtil.getPathFor(null))));
        if (!allRepoFavorites.isEmpty()) {
            for (Repository repo : allRepos) {
                List repoList = infoByRepo.computeIfAbsent(repo, key -> new ArrayList());
                repoList.addAll(allRepoFavorites);
            }
        }
        infoByPath.forEach((repoPath, list) -> {
            T repo = this.myRepositoryManager.getRepositoryForRootQuick(VcsUtil.getFilePath((String)repoPath, (boolean)true));
            if (repo == null) {
                return;
            }
            List repoList = infoByRepo.computeIfAbsent((Repository)repo, key -> new ArrayList());
            repoList.addAll(list);
        });
        HashMap<Repository, List> hashMap = infoByRepo;
        if (hashMap == null) {
            DvcsBranchManager.$$$reportNull$$$0(13);
        }
        return hashMap;
    }

    private boolean isPredefinedAsFavorite(@NotNull BranchType type, @NotNull String branchName) {
        Collection<String> predefinedNames;
        if (type == null) {
            DvcsBranchManager.$$$reportNull$$$0(14);
        }
        if (branchName == null) {
            DvcsBranchManager.$$$reportNull$$$0(15);
        }
        return (predefinedNames = this.myPredefinedFavoriteBranches.get(type)) != null && predefinedNames.contains(branchName);
    }

    public void setFavorite(@Nullable BranchType branchType, @Nullable T repository, @NotNull String branchName, boolean shouldBeFavorite) {
        VirtualFile root;
        if (branchName == null) {
            DvcsBranchManager.$$$reportNull$$$0(16);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Changing favorite state of %s(%s) to %s in %s".formatted(branchName, branchType != null ? branchType.getName() : "", shouldBeFavorite, repository));
        }
        if (branchType == null) {
            return;
        }
        String branchTypeName = branchType.getName();
        VirtualFile virtualFile = root = repository == null ? null : repository.getRoot();
        if (shouldBeFavorite) {
            this.myBranchSettings.getExcludedFavorites().remove(branchTypeName, root, branchName);
            if (!this.isPredefinedAsFavorite(branchType, branchName)) {
                this.myBranchSettings.getFavorites().add(branchTypeName, root, branchName);
            }
        } else {
            this.myBranchSettings.getFavorites().remove(branchTypeName, root, branchName);
            if (this.isPredefinedAsFavorite(branchType, branchName)) {
                this.myBranchSettings.getExcludedFavorites().add(branchTypeName, root, branchName);
            }
        }
        this.notifyFavoriteSettingsChanged(repository);
    }

    protected void notifyFavoriteSettingsChanged(@Nullable T repository) {
        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myProject, () -> ((DvcsBranchManagerListener)this.myProject.getMessageBus().syncPublisher(DVCS_BRANCH_SETTINGS_CHANGED)).branchFavoriteSettingsChanged());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchTypes";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/branch/DvcsBranchManager";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/branch/DvcsBranchManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavoriteRefs";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavoriteBranches";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "collectBranchesByRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultBranchNames";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFavorite";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFavoriteRefs";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFavoriteBranches";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectBranchesByRoot";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedAsFavorite";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setFavorite";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10, 13 -> new IllegalStateException(string);
        };
    }

    public static interface DvcsBranchManagerListener {
        default public void branchFavoriteSettingsChanged() {
        }

        default public void branchGroupingSettingsChanged(@NotNull GroupingKey key, boolean state) {
            if (key == null) {
                DvcsBranchManagerListener.$$$reportNull$$$0(0);
            }
        }

        default public void showTagsSettingsChanged(boolean state) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/dvcs/branch/DvcsBranchManager$DvcsBranchManagerListener", "branchGroupingSettingsChanged"));
        }
    }
}

