/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.GenericDomValue;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenBuildIssueHandler;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.externalSystemIntegration.output.LogMessageType;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLogEntryReader;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLoggedEventParser;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenParsingContext;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenSpyLoggedEventParser;
import org.jetbrains.idea.maven.externalSystemIntegration.output.importproject.MavenImportLoggedEventParser;
import org.jetbrains.idea.maven.externalSystemIntegration.output.parsers.MavenEventType;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.Maven4ModelVersionErrorParser;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.Maven4ModelVersionErrorParserKt;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.PathNavigatable;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.UpdateVersionQuickFix;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B=\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fB\t\b\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0010J\u0012\u0010\u0016\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J8\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0006\b\u0000\u0012\u00020$0#H\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020%H\u0016J&\u0010&\u001a\u0010\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)\u0018\u00010'2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\tH\u0002J0\u0010,\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020(2\u000e\u0010\"\u001a\n\u0012\u0006\b\u0000\u0012\u00020$0#H\u0016J\u001a\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u001e\u001a\u00020(2\u0006\u0010*\u001a\u00020\u0006H\u0002J'\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020(2\u0006\u0010+\u001a\u00020\t2\b\u00101\u001a\u0004\u0018\u00010)H\u0002\u00a2\u0006\u0002\u00102J2\u0010,\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020(2\b\u00103\u001a\u0004\u0018\u0001042\u000e\u0010\"\u001a\n\u0012\u0006\b\u0000\u0012\u00020$0#H\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00065"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/Maven4ModelVersionErrorParser;", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenLoggedEventParser;", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenSpyLoggedEventParser;", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/importproject/MavenImportLoggedEventParser;", "eventHandlerProvider", "Lkotlin/Function1;", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/idea/maven/buildtool/MavenBuildIssueHandler;", "pathChecker", "Ljava/nio/file/Path;", "", "triggers", "", "Lkotlin/text/Regex;", "<init>", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Ljava/util/List;)V", "()V", "getEventHandlerProvider", "()Lkotlin/jvm/functions/Function1;", "getPathChecker", "getTriggers", "()Ljava/util/List;", "supportsType", "type", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/LogMessageType;", "checkLogLine", "parentId", "", "parsingContext", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext;", "logLine", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenLogEntryReader$MavenLogEntry;", "logEntryReader", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenLogEntryReader;", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/parsers/MavenEventType;", "getModelFromPath", "Lkotlin/Pair;", "", "", "project", "path", "processLogLine", "createBuildIssue", "Lcom/intellij/build/issue/BuildIssue;", "newBuildIssue", "line", "offset", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/lang/Integer;)Lcom/intellij/build/issue/BuildIssue;", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "intellij.maven"})
@ApiStatus.Internal
public final class Maven4ModelVersionErrorParser
implements MavenLoggedEventParser,
MavenSpyLoggedEventParser,
MavenImportLoggedEventParser {
    @NotNull
    private final Function1<Project, MavenBuildIssueHandler> eventHandlerProvider;
    @NotNull
    private final Function1<Path, Boolean> pathChecker;
    @NotNull
    private final List<Regex> triggers;

    public Maven4ModelVersionErrorParser(@NotNull Function1<? super Project, ? extends MavenBuildIssueHandler> eventHandlerProvider, @NotNull Function1<? super Path, Boolean> pathChecker, @NotNull List<Regex> triggers) {
        Intrinsics.checkNotNullParameter(eventHandlerProvider, (String)"eventHandlerProvider");
        Intrinsics.checkNotNullParameter(pathChecker, (String)"pathChecker");
        Intrinsics.checkNotNullParameter(triggers, (String)"triggers");
        this.eventHandlerProvider = eventHandlerProvider;
        this.pathChecker = pathChecker;
        this.triggers = triggers;
    }

    @NotNull
    public final Function1<Project, MavenBuildIssueHandler> getEventHandlerProvider() {
        return this.eventHandlerProvider;
    }

    @NotNull
    public final Function1<Path, Boolean> getPathChecker() {
        return this.pathChecker;
    }

    @NotNull
    public final List<Regex> getTriggers() {
        return this.triggers;
    }

    public Maven4ModelVersionErrorParser() {
        this((Function1<? super Project, ? extends MavenBuildIssueHandler>)((Function1)Maven4ModelVersionErrorParser::_init_$lambda$0), (Function1<? super Path, Boolean>)((Function1)Maven4ModelVersionErrorParser::_init_$lambda$1), SystemInfo.isWindows ? Maven4ModelVersionErrorParserKt.getTRIGGER_LINES_WINDOWS() : Maven4ModelVersionErrorParserKt.getTRIGGER_LINES_UNIX());
    }

    @Override
    public boolean supportsType(@Nullable LogMessageType type) {
        return true;
    }

    @Override
    public boolean checkLogLine(@NotNull Object parentId, @NotNull MavenParsingContext parsingContext, @NotNull MavenLogEntryReader.MavenLogEntry logLine, @NotNull MavenLogEntryReader logEntryReader, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)parsingContext, (String)"parsingContext");
        Intrinsics.checkNotNullParameter((Object)logLine, (String)"logLine");
        Intrinsics.checkNotNullParameter((Object)logEntryReader, (String)"logEntryReader");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        String string = logLine.getLine();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLine(...)");
        return this.processLogLine(parentId, parsingContext, string, messageConsumer);
    }

    @Override
    public boolean supportsType(@NotNull MavenEventType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return true;
    }

    private final Pair<String, Integer> getModelFromPath(Project project, Path path) {
        VirtualFile virtualFile = VfsUtil.findFile((Path)path, (boolean)false);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        return (Pair)com.intellij.openapi.progress.CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends String, ? extends Integer>>, Object>(project, virtualFile2, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.$project = $project;
                this.$virtualFile = $virtualFile;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.readAction(() -> getModelFromPath.1.invokeSuspend$lambda$0(this.$project, this.$virtualFile), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Pair<String, Integer>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Pair invokeSuspend$lambda$0(Project $project, VirtualFile $virtualFile) {
                GenericDomValue<String> genericDomValue = MavenDomUtil.getMavenDomProjectModel($project, $virtualFile);
                if (genericDomValue == null || (genericDomValue = genericDomValue.getModelVersion()) == null) {
                    return null;
                }
                GenericDomValue<String> modelVersion = genericDomValue;
                String string = (String)modelVersion.getValue();
                if (string == null) {
                    return null;
                }
                String value = string;
                XmlElement xmlElement = modelVersion.getXmlElement();
                int offset = xmlElement != null && (xmlElement = xmlElement.getNavigationElement()) != null ? xmlElement.getTextOffset() : 0;
                return TuplesKt.to((Object)value, (Object)offset);
            }
        }));
    }

    @Override
    public boolean processLogLine(@NotNull Object parentId, @NotNull MavenParsingContext parsingContext, @NotNull String logLine, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)parsingContext, (String)"parsingContext");
        Intrinsics.checkNotNullParameter((Object)logLine, (String)"logLine");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        BuildIssue buildIssue2 = this.createBuildIssue(logLine, parsingContext.getIdeaProject());
        if (buildIssue2 == null) {
            return false;
        }
        BuildIssue buildIssue3 = buildIssue2;
        messageConsumer.accept((BuildEvent)new BuildIssueEventImpl(parentId, buildIssue3, MessageEvent.Kind.ERROR));
        return true;
    }

    private final BuildIssue createBuildIssue(String logLine, Project project) {
        for (Regex trigger : this.triggers) {
            Pair<String, Integer> modelAndOffset;
            Path path;
            MatchResult match = Regex.find$default((Regex)trigger, (CharSequence)logLine, (int)0, (int)2, null);
            if (match == null) continue;
            String fileName = (String)match.getGroupValues().get(1);
            Intrinsics.checkNotNullExpressionValue((Object)Paths.get(fileName, new String[0]), (String)"get(...)");
            if (!((Boolean)this.pathChecker.invoke((Object)path)).booleanValue() || (modelAndOffset = this.getModelFromPath(project, path)) != null && !Intrinsics.areEqual((Object)modelAndOffset.getFirst(), (Object)"4.0.0")) continue;
            Pair<String, Integer> pair = modelAndOffset;
            return this.newBuildIssue(logLine, path, pair != null ? (Integer)pair.getSecond() : null);
        }
        return null;
    }

    private final BuildIssue newBuildIssue(String line, Path path, Integer offset) {
        return new BuildIssue(line, path, offset){
            final /* synthetic */ String $line;
            final /* synthetic */ Path $path;
            final /* synthetic */ Integer $offset;
            {
                this.$line = $line;
                this.$path = $path;
                this.$offset = $offset;
            }

            public String getTitle() {
                String string = SyncBundle.message("maven.sync.incorrect.model.version", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public String getDescription() {
                Object[] objectArray = new Object[]{((Object)StringsKt.trim((CharSequence)this.$line)).toString(), "maven_model_ver_update_410"};
                String string = SyncBundle.message("maven.sync.incorrect.model.version.desc", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public List<BuildIssueQuickFix> getQuickFixes() {
                return CollectionsKt.listOf((Object)new UpdateVersionQuickFix(this.$path));
            }

            public PathNavigatable getNavigatable(Project project) {
                PathNavigatable pathNavigatable;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Integer n = this.$offset;
                if (n != null) {
                    Integer n2 = n;
                    Path path = this.$path;
                    int it = ((Number)n2).intValue();
                    boolean bl = false;
                    pathNavigatable = new PathNavigatable(project, path, it);
                } else {
                    pathNavigatable = null;
                }
                return pathNavigatable;
            }
        };
    }

    @Override
    public boolean processLogLine(@NotNull Project project, @NotNull String logLine, @Nullable BuildOutputInstantReader reader, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)logLine, (String)"logLine");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        BuildIssue buildIssue2 = this.createBuildIssue(logLine, project);
        if (buildIssue2 == null) {
            return false;
        }
        BuildIssue buildIssue3 = buildIssue2;
        MavenBuildIssueHandler console = (MavenBuildIssueHandler)this.eventHandlerProvider.invoke((Object)project);
        MessageEvent.Kind kind = MessageEvent.Kind.WARNING;
        console.addBuildIssue(buildIssue3, kind);
        return true;
    }

    private static final MavenBuildIssueHandler _init_$lambda$0(Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MavenSyncConsole mavenSyncConsole = MavenProjectsManager.getInstance(it).getSyncConsole();
        Intrinsics.checkNotNullExpressionValue((Object)mavenSyncConsole, (String)"getSyncConsole(...)");
        return mavenSyncConsole;
    }

    private static final boolean _init_$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }
}

