/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class SpellcheckerConfigCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("spellchecker.settings.project", 2);
    private static final EventId1<Boolean> ALL_BUNDLED_ENABLED = GROUP.registerEvent("all.bundled.enabled", (EventField)EventFields.Boolean((String)"value"));
    private static final EventId1<Integer> MAX_SPELLCHECKER_SUGGESTIONS = GROUP.registerEvent("max.spellchecker.suggestions", (EventField)EventFields.Int((String)"value"));
    private static final EventId1<Integer> CUSTOM_DIC_COUNT = GROUP.registerEvent("custom.dict.count", (EventField)EventFields.Count);
    private static final EventId1<Boolean> USE_SINGLE_DICT_TO_SAVE = GROUP.registerEvent("use.single.dict.to.save", (EventField)EventFields.Enabled);
    private static final EventId1<String> DEFAULT_DICT_TO_SAVE = GROUP.registerEvent("default.dict.to.save", (EventField)EventFields.String((String)"value", List.of("project-level", "application-level")));

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            SpellcheckerConfigCollector.$$$reportNull$$$0(0);
        }
        SpellCheckerSettings settings = SpellCheckerSettings.getInstance(project);
        HashSet result = ContainerUtil.newHashSet((Object[])new MetricEvent[]{ALL_BUNDLED_ENABLED.metric((Object)true), MAX_SPELLCHECKER_SUGGESTIONS.metric((Object)5), CUSTOM_DIC_COUNT.metric((Object)settings.getCustomDictionariesPaths().size()), USE_SINGLE_DICT_TO_SAVE.metric((Object)settings.isUseSingleDictionaryToSave())});
        if (settings.isUseSingleDictionaryToSave()) {
            result.add(DEFAULT_DICT_TO_SAVE.metric((Object)settings.getDictionaryToSave()));
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            SpellcheckerConfigCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/statistics/SpellcheckerConfigCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/statistics/SpellcheckerConfigCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

