/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.task;

import org.jsampler.CC;
import org.jsampler.JSI18n;
import org.jsampler.task.EnhancedTask;
import org.linuxsampler.lscp.Client;
import org.linuxsampler.lscp.DbDirectoryInfo;
import org.linuxsampler.lscp.DbInstrumentInfo;
import org.linuxsampler.lscp.DbSearchQuery;
import org.linuxsampler.lscp.ScanJobInfo;

public class InstrumentsDb {
    private InstrumentsDb() {
    }

    public static class Format
    extends EnhancedTask {
        public Format() {
            this.setTitle("InstrumentsDb.Format_task");
            String string = JSI18n.i18n.getMessage("InstrumentsDb.Format.desc");
            this.setDescription(string);
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().formatInstrumentsDb();
        }
    }

    public static class GetScanJobInfo
    extends EnhancedTask<ScanJobInfo> {
        private int jobId;

        public GetScanJobInfo(int n) {
            this.setTitle("InstrumentsDb.GetScanJobInfo_task");
            this.setDescription(JSI18n.i18n.getMessage("InstrumentsDb.GetScanJobInfo.desc"));
            this.jobId = n;
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().getDbInstrumentsJobInfo(this.jobId));
        }

        public int getJobId() {
            return this.jobId;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof GetScanJobInfo)) {
                return false;
            }
            return ((GetScanJobInfo)object).getJobId() == this.getJobId();
        }
    }

    public static class SetInstrumentFilePath
    extends EnhancedTask {
        private String oldPath;
        private String newPath;

        public SetInstrumentFilePath(String string, String string2) {
            this.setTitle("InstrumentsDb.SetInstrumentFilePath_task");
            this.setDescription(JSI18n.i18n.getMessage("InstrumentsDb.SetInstrumentFilePath.desc"));
            this.oldPath = string;
            this.newPath = string2;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setDbInstrumentFilePath(this.oldPath, this.newPath);
        }
    }

    public static class FindLostInstrumentFiles
    extends EnhancedTask<String[]> {
        public FindLostInstrumentFiles() {
            this.setTitle("InstrumentsDb.FindLostInstrumentFiles_task");
            this.setDescription(JSI18n.i18n.getMessage("InstrumentsDb.FindLostInstrumentFiles.desc"));
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().findLostDbInstrumentFiles());
        }
    }

    public static class Copy
    extends EnhancedTask {
        private DbDirectoryInfo[] directories;
        private DbInstrumentInfo[] instruments;
        private String dest;

        public Copy(DbDirectoryInfo[] dbDirectoryInfoArray, DbInstrumentInfo[] dbInstrumentInfoArray, String string) {
            super(true);
            this.setTitle("InstrumentsDb.Copy_task");
            this.setDescription(JSI18n.i18n.getMessage("InstrumentsDb.Copy.desc"));
            this.directories = dbDirectoryInfoArray;
            this.instruments = dbInstrumentInfoArray;
            this.dest = string;
        }

        @Override
        public void exec() throws Exception {
            this.copyInstruments();
            this.copyDirectories();
        }

        private void copyInstruments() throws Exception {
            if (this.instruments == null || this.instruments.length == 0) {
                return;
            }
            if (this.instruments.length == 1) {
                String string = this.instruments[0].getInstrumentPath();
                CC.getClient().copyDbInstrument(string, this.dest);
            } else {
                String[] stringArray = new String[this.instruments.length];
                for (int i = 0; i < this.instruments.length; ++i) {
                    stringArray[i] = this.instruments[i].getInstrumentPath();
                }
                CC.getClient().copyDbInstruments(stringArray, this.dest);
            }
        }

        private void copyDirectories() throws Exception {
            if (this.directories == null || this.directories.length == 0) {
                return;
            }
            if (this.directories.length == 1) {
                String string = this.directories[0].getDirectoryPath();
                CC.getClient().copyDbDirectory(string, this.dest);
            } else {
                String[] stringArray = new String[this.directories.length];
                for (int i = 0; i < this.directories.length; ++i) {
                    stringArray[i] = this.directories[i].getDirectoryPath();
                }
                CC.getClient().copyDbDirectories(stringArray, this.dest);
            }
        }
    }

    public static class Move
    extends EnhancedTask {
        private DbDirectoryInfo[] directories;
        private DbInstrumentInfo[] instruments;
        private String dest;

        public Move(DbDirectoryInfo[] dbDirectoryInfoArray, DbInstrumentInfo[] dbInstrumentInfoArray, String string) {
            super(true);
            this.setTitle("InstrumentsDb.Move_task");
            this.setDescription(JSI18n.i18n.getMessage("InstrumentsDb.Move.desc"));
            this.directories = dbDirectoryInfoArray;
            this.instruments = dbInstrumentInfoArray;
            this.dest = string;
        }

        @Override
        public void exec() throws Exception {
            this.moveInstruments();
            this.moveDirectories();
        }

        private void moveInstruments() throws Exception {
            if (this.instruments == null || this.instruments.length == 0) {
                return;
            }
            if (this.instruments.length == 1) {
                String string = this.instruments[0].getInstrumentPath();
                CC.getClient().moveDbInstrument(string, this.dest);
            } else {
                String[] stringArray = new String[this.instruments.length];
                for (int i = 0; i < this.instruments.length; ++i) {
                    stringArray[i] = this.instruments[i].getInstrumentPath();
                }
                CC.getClient().moveDbInstruments(stringArray, this.dest);
            }
        }

        private void moveDirectories() throws Exception {
            if (this.directories == null || this.directories.length == 0) {
                return;
            }
            if (this.directories.length == 1) {
                String string = this.directories[0].getDirectoryPath();
                CC.getClient().moveDbDirectory(string, this.dest);
            } else {
                String[] stringArray = new String[this.directories.length];
                for (int i = 0; i < this.directories.length; ++i) {
                    stringArray[i] = this.directories[i].getDirectoryPath();
                }
                CC.getClient().moveDbDirectories(stringArray, this.dest);
            }
        }
    }

    public static class AddInstrumentsNonrecursive
    extends EnhancedTask<Integer> {
        private String dbDir;
        private String fsDir;
        private boolean insDir;

        public AddInstrumentsNonrecursive(String string, String string2) {
            this(string, string2, false);
        }

        public AddInstrumentsNonrecursive(String string, String string2, boolean bl) {
            this.setTitle("InstrumentsDb.AddInstrumentsNonrecursive_task");
            String string3 = JSI18n.i18n.getMessage("InstrumentsDb.AddInstrumentsNonrecursive.desc");
            this.setDescription(string3);
            this.dbDir = string;
            this.fsDir = string2;
            this.insDir = bl;
        }

        @Override
        public void exec() throws Exception {
            int n = CC.getClient().addDbInstruments(Client.ScanMode.NON_RECURSIVE, this.dbDir, this.fsDir, true, this.insDir);
            this.setResult(n);
        }
    }

    public static class AddInstruments
    extends EnhancedTask<Integer> {
        private String dbDir;
        private String fsDir;
        private boolean flat;
        private boolean insDir;

        public AddInstruments(String string, String string2) {
            this(string, string2, false);
        }

        public AddInstruments(String string, String string2, boolean bl) {
            this(string, string2, bl, false);
        }

        public AddInstruments(String string, String string2, boolean bl, boolean bl2) {
            this.setTitle("InstrumentsDb.AddInstruments_task");
            String string3 = JSI18n.i18n.getMessage("InstrumentsDb.AddInstruments.desc");
            this.setDescription(string3);
            this.dbDir = string;
            this.fsDir = string2;
            this.flat = bl;
            this.insDir = bl2;
        }

        @Override
        public void exec() throws Exception {
            Client.ScanMode scanMode = this.flat ? Client.ScanMode.FLAT : Client.ScanMode.RECURSIVE;
            int n = CC.getClient().addDbInstruments(scanMode, this.dbDir, this.fsDir, true, this.insDir);
            this.setResult(n);
        }
    }

    public static class AddInstrumentsFromFile
    extends EnhancedTask<Integer> {
        private String dbDir;
        private String filePath;
        private int instrIndex;

        public AddInstrumentsFromFile(String string, String string2) {
            this(string, string2, -1);
        }

        public AddInstrumentsFromFile(String string, String string2, int n) {
            this.setTitle("InstrumentsDb.AddInstrumentsFromFile_task");
            String string3 = JSI18n.i18n.getMessage("InstrumentsDb.AddInstrumentsFromFile.desc");
            this.setDescription(string3);
            this.dbDir = string;
            this.filePath = string2;
            this.instrIndex = n;
        }

        @Override
        public void exec() throws Exception {
            int n = this.instrIndex != -1 ? CC.getClient().addDbInstrument(this.dbDir, this.filePath, this.instrIndex, true) : CC.getClient().addDbInstruments(this.dbDir, this.filePath, true);
            this.setResult(n);
        }
    }

    public static class RemoveInstruments
    extends EnhancedTask {
        private DbInstrumentInfo[] instruments;

        public RemoveInstruments(DbInstrumentInfo[] dbInstrumentInfoArray) {
            super(true);
            this.setTitle("InstrumentsDb.RemoveInstruments_task");
            this.setDescription(JSI18n.i18n.getMessage("InstrumentsDb.RemoveInstruments.desc"));
            this.instruments = dbInstrumentInfoArray;
        }

        @Override
        public void exec() throws Exception {
            this.removeInstruments();
        }

        private void removeInstruments() throws Exception {
            if (this.instruments == null || this.instruments.length == 0) {
                return;
            }
            if (this.instruments.length == 1) {
                String string = this.instruments[0].getInstrumentPath();
                CC.getClient().removeDbInstrument(string);
            } else {
                String[] stringArray = new String[this.instruments.length];
                for (int i = 0; i < this.instruments.length; ++i) {
                    stringArray[i] = this.instruments[i].getInstrumentPath();
                }
                CC.getClient().removeDbInstruments(stringArray);
            }
        }
    }

    public static class SetInstrumentDescription
    extends EnhancedTask {
        private String instr;
        private String desc;

        public SetInstrumentDescription(String string, String string2) {
            this.setTitle("InstrumentsDb.SetInstrumentDescription_task");
            String string3 = JSI18n.i18n.getMessage("InstrumentsDb.SetInstrumentDescription.desc");
            this.setDescription(string3);
            this.instr = string;
            this.desc = string2;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setDbInstrumentDescription(this.instr, this.desc);
        }
    }

    public static class RenameInstrument
    extends EnhancedTask {
        private String instr;
        private String newName;

        public RenameInstrument(String string, String string2) {
            this.setTitle("InstrumentsDb.RenameInstrument_task");
            this.setDescription(JSI18n.i18n.getMessage("InstrumentsDb.RenameInstrument.desc"));
            this.instr = string;
            this.newName = string2;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().renameDbInstrument(this.instr, this.newName);
        }
    }

    public static class FindInstruments
    extends EnhancedTask<DbInstrumentInfo[]> {
        private String dir;
        private DbSearchQuery query;

        public FindInstruments(String string, DbSearchQuery dbSearchQuery) {
            this.setTitle("InstrumentsDb.FindInstruments_task");
            this.setDescription(JSI18n.i18n.getMessage("InstrumentsDb.FindInstruments.desc"));
            this.dir = string;
            this.query = dbSearchQuery;
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().findDbInstruments(this.dir, this.query));
        }
    }

    public static class GetInstrument
    extends EnhancedTask<DbInstrumentInfo> {
        private String instr;

        public GetInstrument(String string) {
            this.setTitle("InstrumentsDb.GetInstrument_task");
            this.setDescription(JSI18n.i18n.getMessage("InstrumentsDb.GetInstrument.desc"));
            this.instr = string;
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().getDbInstrumentInfo(this.instr));
        }
    }

    public static class GetInstruments
    extends EnhancedTask<DbInstrumentInfo[]> {
        private String dir;

        public GetInstruments(String string) {
            super(true);
            this.setTitle("InstrumentsDb.GetInstruments_task");
            this.setDescription(JSI18n.i18n.getMessage("InstrumentsDb.GetInstruments.desc"));
            this.dir = string;
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().getDbInstruments(this.dir));
        }

        public String getDirectory() {
            return this.dir;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof GetInstruments)) {
                return false;
            }
            String string = ((GetInstruments)object).getDirectory();
            if (this.getDirectory() == null) {
                return string == null;
            }
            return this.getDirectory().equals(string);
        }
    }

    public static class FindDirectories
    extends EnhancedTask<DbDirectoryInfo[]> {
        private String dir;
        private DbSearchQuery query;

        public FindDirectories(String string, DbSearchQuery dbSearchQuery) {
            this.setTitle("InstrumentsDb.FindDirectories_task");
            this.setDescription(JSI18n.i18n.getMessage("InstrumentsDb.FindDirectories.desc"));
            this.dir = string;
            this.query = dbSearchQuery;
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().findDbDirectories(this.dir, this.query));
        }
    }

    public static class RemoveDirectories
    extends EnhancedTask {
        private DbDirectoryInfo[] directories;

        public RemoveDirectories(DbDirectoryInfo[] dbDirectoryInfoArray) {
            super(true);
            this.setTitle("InstrumentsDb.RemoveDirectories_task");
            this.setDescription(JSI18n.i18n.getMessage("InstrumentsDb.RemoveDirectories.desc"));
            this.directories = dbDirectoryInfoArray;
        }

        @Override
        public void exec() throws Exception {
            this.removeDirectories();
        }

        private void removeDirectories() throws Exception {
            if (this.directories == null || this.directories.length == 0) {
                return;
            }
            if (this.directories.length == 1) {
                String string = this.directories[0].getDirectoryPath();
                CC.getClient().removeDbDirectory(string, true);
            } else {
                String[] stringArray = new String[this.directories.length];
                for (int i = 0; i < this.directories.length; ++i) {
                    stringArray[i] = this.directories[i].getDirectoryPath();
                }
                CC.getClient().removeDbDirectories(stringArray, true);
            }
        }
    }

    public static class SetDirectoryDescription
    extends EnhancedTask {
        private String dir;
        private String desc;

        public SetDirectoryDescription(String string, String string2) {
            this.setTitle("InstrumentsDb.SetDirectoryDescription_task");
            String string3 = JSI18n.i18n.getMessage("InstrumentsDb.SetDirectoryDescription.desc");
            this.setDescription(string3);
            this.dir = string;
            this.desc = string2;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setDbDirectoryDescription(this.dir, this.desc);
        }
    }

    public static class RenameDirectory
    extends EnhancedTask {
        private String dir;
        private String newName;

        public RenameDirectory(String string, String string2) {
            this.setTitle("InstrumentsDb.RenameDirectory_task");
            this.setDescription(JSI18n.i18n.getMessage("InstrumentsDb.RenameDirectory.desc"));
            this.dir = string;
            this.newName = string2;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().renameDbDirectory(this.dir, this.newName);
        }
    }

    public static class CreateDirectory
    extends EnhancedTask {
        private String dir;

        public CreateDirectory(String string) {
            this.setTitle("InstrumentsDb.CreateDirectory_task");
            this.setDescription(JSI18n.i18n.getMessage("InstrumentsDb.CreateDirectory.desc"));
            this.dir = string;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().addDbDirectory(this.dir);
        }
    }

    public static class GetDrectory
    extends EnhancedTask<DbDirectoryInfo> {
        private String dir;

        public GetDrectory(String string) {
            this.setTitle("InstrumentsDb.GetDrectory_task");
            this.setDescription(JSI18n.i18n.getMessage("InstrumentsDb.GetDrectory.desc"));
            this.dir = string;
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().getDbDirectoryInfo(this.dir));
        }
    }

    public static class GetDrectories
    extends EnhancedTask<DbDirectoryInfo[]> {
        private String dir;

        public GetDrectories(String string) {
            this.setTitle("InstrumentsDb.GetDrectories_task");
            this.setDescription(JSI18n.i18n.getMessage("InstrumentsDb.GetDrectories.desc"));
            this.dir = string;
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().getDbDirectories(this.dir));
        }

        public String getDirectory() {
            return this.dir;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof GetDrectories)) {
                return false;
            }
            String string = ((GetDrectories)object).getDirectory();
            if (this.getDirectory() == null) {
                return string == null;
            }
            return this.getDirectory().equals(string);
        }
    }

    public static class GetInstrumentCount
    extends EnhancedTask<Integer> {
        private String dir;
        private boolean recursive;

        public GetInstrumentCount(String string, boolean bl) {
            this.setTitle("InstrumentsDb.GetInstrumentCount_task");
            this.setDescription(JSI18n.i18n.getMessage("InstrumentsDb.GetInstrumentCount.desc"));
            this.dir = string;
            this.recursive = bl;
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().getDbInstrumentCount(this.dir, this.recursive));
        }
    }

    public static class GetDirectoryCount
    extends EnhancedTask<Integer> {
        private String dir;
        private boolean recursive;

        public GetDirectoryCount(String string, boolean bl) {
            this.setTitle("InstrumentsDb.GetDirectoryCount_task");
            this.setDescription(JSI18n.i18n.getMessage("InstrumentsDb.GetDirectoryCount.desc"));
            this.dir = string;
            this.recursive = bl;
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().getDbDirectoryCount(this.dir, this.recursive));
        }
    }
}

