/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants;

import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oid4vc.issuance.OID4VCAuthorizationDetailsResponse;
import org.keycloak.protocol.oid4vc.issuance.credentialoffer.CredentialOfferStorage;
import org.keycloak.protocol.oid4vc.model.CredentialsOffer;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.grants.OAuth2GrantType;
import org.keycloak.protocol.oidc.grants.OAuth2GrantTypeBase;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.util.DefaultClientSessionContext;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.MediaType;

public class PreAuthorizedCodeGrantType
extends OAuth2GrantTypeBase {
    private static final Logger LOGGER = Logger.getLogger(PreAuthorizedCodeGrantType.class);
    public static final String VC_ISSUANCE_FLOW = "VC-Issuance-Flow";

    public Response process(OAuth2GrantType.Context context) {
        AccessTokenResponse tokenResponse;
        LOGGER.debug((Object)"Process grant request for preauthorized.");
        this.setContext(context);
        String code = (String)this.formParams.getFirst((Object)"pre-authorized_code");
        if (code == null) {
            String errorMessage = "Missing parameter: pre-authorized_code";
            this.event.detail("reason", errorMessage).error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_request", errorMessage, Response.Status.BAD_REQUEST);
        }
        CredentialOfferStorage offerStorage = (CredentialOfferStorage)this.session.getProvider(CredentialOfferStorage.class);
        CredentialOfferStorage.CredentialOfferState offerState = offerStorage.findOfferStateByCode(this.session, code);
        if (offerState == null) {
            String errorMessage = "No credential offer state for code: " + code;
            this.event.detail("reason", errorMessage).error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_request", errorMessage, Response.Status.BAD_REQUEST);
        }
        if (offerState.isExpired()) {
            this.event.error("expired_code");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Code is expired", Response.Status.BAD_REQUEST);
        }
        CredentialsOffer credOffer = offerState.getCredentialsOffer();
        String appUserId = offerState.getUserId();
        UserModel userModel = this.session.users().getUserById(this.realm, appUserId);
        if (userModel == null) {
            String errorMessage = "No user with ID: " + appUserId;
            this.event.detail("reason", errorMessage).error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_request", errorMessage, Response.Status.BAD_REQUEST);
        }
        if (!userModel.isEnabled()) {
            String errorMessage = "User '" + userModel.getUsername() + "' disabled";
            this.event.detail("reason", errorMessage).error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_request", errorMessage, Response.Status.BAD_REQUEST);
        }
        String appClientId = offerState.getClientId();
        ClientModel clientModel = this.realm.getClientByClientId(appClientId);
        if (clientModel == null) {
            String errorMessage = "No client model for: " + appClientId;
            this.event.detail("reason", errorMessage).error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_request", errorMessage, Response.Status.BAD_REQUEST);
        }
        UserSessionModel userSession = this.session.sessions().createUserSession(null, this.realm, userModel, userModel.getUsername(), null, "pre-authorized-code", false, null, null, UserSessionModel.SessionPersistenceState.PERSISTENT);
        AuthenticatedClientSessionModel clientSession = this.session.sessions().createClientSession(this.realm, clientModel, userSession);
        String credentialConfigurationIds = JsonSerialization.valueAsString(credOffer.getCredentialConfigurationIds());
        clientSession.setNote("CREDENTIAL_CONFIGURATION_IDS", credentialConfigurationIds);
        clientSession.setNote("iss", credOffer.getCredentialIssuer());
        clientSession.setNote(VC_ISSUANCE_FLOW, "urn:ietf:params:oauth:grant-type:pre-authorized_code");
        DefaultClientSessionContext sessionContext = DefaultClientSessionContext.fromClientSessionAndScopeParameter(clientSession, "openid", this.session);
        sessionContext.setAttribute("grant_type", "urn:ietf:params:oauth:grant-type:pre-authorized_code");
        this.session.getContext().setClient(clientModel);
        List<Object> authorizationDetailsResponses = this.processAuthorizationDetails(userSession, sessionContext);
        LOGGER.infof("Initial authorization_details processing result: %s", authorizationDetailsResponses);
        if (authorizationDetailsResponses == null || authorizationDetailsResponses.isEmpty()) {
            authorizationDetailsResponses = this.handleMissingAuthorizationDetails(userSession, sessionContext);
        }
        if ((authorizationDetailsResponses = Optional.ofNullable(authorizationDetailsResponses).orElse(List.of())).size() != 1) {
            boolean emptyAuthDetails = authorizationDetailsResponses.isEmpty();
            String errorMessage = (emptyAuthDetails ? "No" : "Multiple") + " authorization details";
            this.event.detail("reason", errorMessage).error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_request", errorMessage, Response.Status.BAD_REQUEST);
        }
        OID4VCAuthorizationDetailsResponse authDetails = (OID4VCAuthorizationDetailsResponse)((Object)authorizationDetailsResponses.get(0));
        offerState.setAuthorizationDetails(authDetails);
        offerStorage.replaceOfferState(this.session, offerState);
        AccessToken accessToken = this.tokenManager.createClientAccessToken(this.session, clientSession.getRealm(), clientSession.getClient(), userSession.getUser(), userSession, sessionContext);
        accessToken.setOtherClaims("authorization_details", authorizationDetailsResponses);
        TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(clientSession.getRealm(), clientSession.getClient(), this.event, this.session, userSession, sessionContext).accessToken(accessToken);
        try {
            tokenResponse = responseBuilder.build();
            tokenResponse.setOtherClaims("authorization_details", authorizationDetailsResponses);
        }
        catch (RuntimeException re) {
            String errorMessage = "Cannot get encryption KEK";
            if (errorMessage.equals(re.getMessage())) {
                throw new CorsErrorResponseException(this.cors, "invalid_request", errorMessage, Response.Status.BAD_REQUEST);
            }
            throw re;
        }
        this.event.success();
        return this.cors.allowAllOrigins().add(Response.ok((Object)tokenResponse).type(MediaType.APPLICATION_JSON_TYPE));
    }

    public EventType getEventType() {
        return EventType.CODE_TO_TOKEN;
    }
}

