/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiBroadcaster;
import java.time.Duration;

public class MultiBroadcast<T> {
    private final Multi<T> upstream;
    private boolean cancelWhenNoOneIsListening;
    private Duration delayAfterLastDeparture;

    public MultiBroadcast(Multi<T> upstream) {
        this.upstream = upstream;
    }

    @CheckReturnValue
    public Multi<T> toAllSubscribers() {
        return Infrastructure.onMultiCreation(MultiBroadcaster.publish(this.upstream, 0, this.cancelWhenNoOneIsListening, this.delayAfterLastDeparture));
    }

    @CheckReturnValue
    public Multi<T> toAtLeast(int numberOfSubscribers) {
        ParameterValidation.positive(numberOfSubscribers, "numberOfSubscribers");
        return Infrastructure.onMultiCreation(MultiBroadcaster.publish(this.upstream, numberOfSubscribers, this.cancelWhenNoOneIsListening, this.delayAfterLastDeparture));
    }

    @CheckReturnValue
    public MultiBroadcast<T> withCancellationAfterLastSubscriberDeparture() {
        this.cancelWhenNoOneIsListening = true;
        return this;
    }

    @CheckReturnValue
    public MultiBroadcast<T> withCancellationAfterLastSubscriberDeparture(Duration delay) {
        this.delayAfterLastDeparture = ParameterValidation.validate(delay, "delay");
        this.withCancellationAfterLastSubscriberDeparture();
        return this;
    }
}

