/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc;

import org.keycloak.broker.jwtauthorizationgrant.JWTAuthorizationGrantConfig;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.RealmModel;

public class OIDCIdentityProviderConfig
extends OAuth2IdentityProviderConfig
implements JWTAuthorizationGrantConfig {
    public static final String JWKS_URL = "jwksUrl";
    public static final String USE_JWKS_URL = "useJwksUrl";
    public static final String VALIDATE_SIGNATURE = "validateSignature";
    public static final String IS_ACCESS_TOKEN_JWT = "isAccessTokenJWT";
    public static final String SUPPORTS_CLIENT_ASSERTIONS = "supportsClientAssertions";
    public static final String SUPPORTS_CLIENT_ASSERTION_REUSE = "supportsClientAssertionReuse";

    public OIDCIdentityProviderConfig(IdentityProviderModel identityProviderModel) {
        super(identityProviderModel);
    }

    public OIDCIdentityProviderConfig() {
    }

    public void setPrompt(String prompt) {
        this.getConfig().put("prompt", prompt);
    }

    public String getLogoutUrl() {
        return (String)this.getConfig().get("logoutUrl");
    }

    public void setLogoutUrl(String url) {
        this.getConfig().put("logoutUrl", url);
    }

    public boolean isSendClientIdOnLogout() {
        return Boolean.parseBoolean(this.getConfig().getOrDefault("sendClientIdOnLogout", Boolean.FALSE.toString()));
    }

    public void setSendClientOnLogout(boolean value) {
        this.getConfig().put("sendClientIdOnLogout", String.valueOf(value));
    }

    public boolean isSendIdTokenOnLogout() {
        return Boolean.parseBoolean(this.getConfig().getOrDefault("sendIdTokenOnLogout", Boolean.TRUE.toString()));
    }

    public void setSendIdTokenOnLogout(boolean value) {
        this.getConfig().put("sendIdTokenOnLogout", String.valueOf(value));
    }

    public boolean isValidateSignature() {
        return Boolean.parseBoolean((String)this.getConfig().get(VALIDATE_SIGNATURE));
    }

    public void setValidateSignature(boolean validateSignature) {
        this.getConfig().put(VALIDATE_SIGNATURE, String.valueOf(validateSignature));
    }

    public void setAccessTokenJwt(boolean accessTokenJwt) {
        this.getConfig().put(IS_ACCESS_TOKEN_JWT, String.valueOf(accessTokenJwt));
    }

    public boolean isAccessTokenJwt() {
        return Boolean.parseBoolean((String)this.getConfig().get(IS_ACCESS_TOKEN_JWT));
    }

    public boolean isBackchannelSupported() {
        return Boolean.parseBoolean((String)this.getConfig().get("backchannelSupported"));
    }

    public void setBackchannelSupported(boolean backchannel) {
        this.getConfig().put("backchannelSupported", String.valueOf(backchannel));
    }

    public boolean isDisableUserInfoService() {
        String disableUserInfo = (String)this.getConfig().get("disableUserInfo");
        return Boolean.parseBoolean(disableUserInfo);
    }

    public void setDisableUserInfoService(boolean disable) {
        this.getConfig().put("disableUserInfo", String.valueOf(disable));
    }

    public boolean isDisableNonce() {
        return Boolean.parseBoolean((String)this.getConfig().get("disableNonce"));
    }

    public void setDisableNonce(boolean disableNonce) {
        if (disableNonce) {
            this.getConfig().put("disableNonce", Boolean.TRUE.toString());
        } else {
            this.getConfig().remove("disableNonce");
        }
    }

    public int getAllowedClockSkew() {
        String allowedClockSkew = (String)this.getConfig().get("allowedClockSkew");
        if (allowedClockSkew == null || allowedClockSkew.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt((String)this.getConfig().get("allowedClockSkew"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public boolean isDisableTypeClaimCheck() {
        return Boolean.parseBoolean((String)this.getConfig().get("disableTypeClaimCheck"));
    }

    public void setDisableTypeClaimCheck(boolean disableTypeClaimCheck) {
        if (disableTypeClaimCheck) {
            this.getConfig().put("disableTypeClaimCheck", Boolean.TRUE.toString());
        } else {
            this.getConfig().remove("disableTypeClaimCheck");
        }
    }

    public boolean isSupportsClientAssertions() {
        return Boolean.parseBoolean((String)this.getConfig().get(SUPPORTS_CLIENT_ASSERTIONS));
    }

    public void setSupportsClientAssertions(boolean supportsClientAssertions) {
        this.getConfig().put(SUPPORTS_CLIENT_ASSERTIONS, String.valueOf(supportsClientAssertions));
    }

    public boolean isSupportsClientAssertionReuse() {
        return Boolean.parseBoolean((String)this.getConfig().get(SUPPORTS_CLIENT_ASSERTION_REUSE));
    }

    @Override
    public void validate(RealmModel realm) {
        super.validate(realm);
        SslRequired sslRequired = realm.getSslRequired();
        UriUtils.checkUrl((SslRequired)sslRequired, (String)this.getJwksUrl(), (String)"jwks_url");
        UriUtils.checkUrl((SslRequired)sslRequired, (String)this.getLogoutUrl(), (String)"logout_url");
        if (this.isValidateSignature() || this.isJWTAuthorizationGrantEnabled() || this.isSupportsClientAssertions()) {
            String optionText;
            String string = this.isValidateSignature() ? "Validate signatures" : (optionText = this.isJWTAuthorizationGrantEnabled() ? "JWT Authorization Grant" : "Supports client assertions");
            if (this.isUseJwksUrl()) {
                if (this.getJwksUrl() == null) {
                    throw new IllegalArgumentException(String.format("JWKS URL is required when '%s' enabled and 'Use JWKS URL' enabled", optionText));
                }
            } else if (this.getPublicKeySignatureVerifier() == null) {
                throw new IllegalArgumentException(String.format("The 'Validating public key' is required when '%s' enabled and 'Use JWKS URL' disabled", optionText));
            }
        }
    }
}

