/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.util.IntSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.DoubleCacheStream;
import org.infinispan.IntCacheStream;
import org.infinispan.LongCacheStream;
import org.infinispan.commons.util.IntSet;
import org.infinispan.stream.impl.DistributedIntCacheStream;
import org.infinispan.stream.impl.IntermediateCacheStream;
import org.infinispan.stream.impl.IntermediateCacheStreamSupplier;
import org.infinispan.stream.impl.IntermediateDoubleCacheStream;
import org.infinispan.stream.impl.IntermediateLongCacheStream;
import org.infinispan.stream.impl.IntermediateType;
import org.infinispan.stream.impl.local.LocalIntCacheStream;

public class IntermediateIntCacheStream
implements IntCacheStream {
    private BaseCacheStream remoteStream;
    private final IntermediateType type;
    private LocalIntCacheStream localIntStream;
    private final IntermediateCacheStreamSupplier supplier;

    public IntermediateIntCacheStream(DistributedIntCacheStream remoteStream) {
        this.remoteStream = remoteStream;
        this.type = IntermediateType.INT;
        this.supplier = new IntermediateCacheStreamSupplier(this.type, remoteStream);
        this.localIntStream = new LocalIntCacheStream(this.supplier, remoteStream.parallel, remoteStream.registry);
    }

    public IntermediateIntCacheStream(BaseCacheStream remoteStream, IntermediateType type, LocalIntCacheStream localIntStream, IntermediateCacheStreamSupplier supplier) {
        this.remoteStream = remoteStream;
        this.type = type;
        this.localIntStream = localIntStream;
        this.supplier = supplier;
    }

    @Override
    public IntCacheStream sequentialDistribution() {
        this.remoteStream = this.remoteStream.sequentialDistribution();
        return this;
    }

    @Override
    public IntCacheStream parallelDistribution() {
        this.remoteStream = this.remoteStream.parallelDistribution();
        return this;
    }

    @Override
    public IntCacheStream filterKeySegments(IntSet segments) {
        this.remoteStream = this.remoteStream.filterKeySegments(segments);
        return this;
    }

    @Override
    public IntCacheStream filterKeys(Set<?> keys) {
        this.remoteStream = this.remoteStream.filterKeys(keys);
        return this;
    }

    @Override
    public IntCacheStream distributedBatchSize(int batchSize) {
        this.remoteStream = this.remoteStream.distributedBatchSize(batchSize);
        return this;
    }

    @Override
    public IntCacheStream segmentCompletionListener(BaseCacheStream.SegmentCompletionListener listener) {
        throw new UnsupportedOperationException("Segment completion listener is only supported when no intermediate operation is provided (sorted, distinct, limit, skip)");
    }

    @Override
    public IntCacheStream disableRehashAware() {
        this.remoteStream = this.remoteStream.disableRehashAware();
        return this;
    }

    @Override
    public IntCacheStream timeout(long timeout, TimeUnit unit) {
        this.remoteStream = this.remoteStream.timeout(timeout, unit);
        return this;
    }

    @Override
    public boolean isParallel() {
        return this.localIntStream.isParallel();
    }

    @Override
    public IntCacheStream sorted() {
        this.localIntStream = this.localIntStream.sorted();
        return this;
    }

    @Override
    public IntCacheStream limit(long maxSize) {
        this.localIntStream = this.localIntStream.limit(maxSize);
        return this;
    }

    @Override
    public IntCacheStream skip(long n) {
        this.localIntStream = this.localIntStream.skip(n);
        return this;
    }

    @Override
    public IntCacheStream peek(IntConsumer action) {
        this.localIntStream = this.localIntStream.peek(action);
        return this;
    }

    @Override
    public IntCacheStream distinct() {
        this.localIntStream = this.localIntStream.distinct();
        return this;
    }

    @Override
    public IntCacheStream filter(IntPredicate predicate) {
        this.localIntStream = this.localIntStream.filter(predicate);
        return this;
    }

    @Override
    public IntCacheStream map(IntUnaryOperator mapper) {
        this.localIntStream.map(mapper);
        return this;
    }

    @Override
    public <U> CacheStream<U> mapToObj(IntFunction<? extends U> mapper) {
        return new IntermediateCacheStream(this.remoteStream, this.type, this.localIntStream.mapToObj((IntFunction)mapper), this.supplier);
    }

    @Override
    public LongCacheStream mapToLong(IntToLongFunction mapper) {
        return new IntermediateLongCacheStream(this.remoteStream, this.type, this.localIntStream.mapToLong(mapper), this.supplier);
    }

    @Override
    public DoubleCacheStream mapToDouble(IntToDoubleFunction mapper) {
        return new IntermediateDoubleCacheStream(this.remoteStream, this.type, this.localIntStream.mapToDouble(mapper), this.supplier);
    }

    @Override
    public IntCacheStream flatMap(IntFunction<? extends IntStream> mapper) {
        this.localIntStream.flatMap((IntFunction)mapper);
        return this;
    }

    @Override
    public IntCacheStream parallel() {
        this.remoteStream = (BaseCacheStream)this.remoteStream.parallel();
        this.localIntStream = (LocalIntCacheStream)this.localIntStream.parallel();
        return this;
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return this.localIntStream.iterator();
    }

    @Override
    public Spliterator.OfInt spliterator() {
        return this.localIntStream.spliterator();
    }

    @Override
    public IntCacheStream sequential() {
        this.remoteStream = (BaseCacheStream)this.remoteStream.sequential();
        this.localIntStream = (LocalIntCacheStream)this.localIntStream.sequential();
        return this;
    }

    @Override
    public IntCacheStream unordered() {
        this.localIntStream = (LocalIntCacheStream)this.localIntStream.unordered();
        return this;
    }

    @Override
    public void forEach(IntConsumer action) {
        this.localIntStream.forEach(action);
    }

    @Override
    public <K, V> void forEach(ObjIntConsumer<Cache<K, V>> action) {
        this.localIntStream.forEach(action);
    }

    @Override
    public void forEachOrdered(IntConsumer action) {
        this.localIntStream.forEachOrdered(action);
    }

    @Override
    public int[] toArray() {
        return this.localIntStream.toArray();
    }

    @Override
    public int reduce(int identity, IntBinaryOperator op) {
        return this.localIntStream.reduce(identity, op);
    }

    @Override
    public OptionalInt reduce(IntBinaryOperator op) {
        return this.localIntStream.reduce(op);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.localIntStream.collect(supplier, accumulator, combiner);
    }

    @Override
    public int sum() {
        return this.localIntStream.sum();
    }

    @Override
    public OptionalInt min() {
        return this.localIntStream.min();
    }

    @Override
    public OptionalInt max() {
        return this.localIntStream.max();
    }

    @Override
    public long count() {
        return this.localIntStream.count();
    }

    @Override
    public OptionalDouble average() {
        return this.localIntStream.average();
    }

    @Override
    public IntSummaryStatistics summaryStatistics() {
        return this.localIntStream.summaryStatistics();
    }

    @Override
    public boolean anyMatch(IntPredicate predicate) {
        return this.localIntStream.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(IntPredicate predicate) {
        return this.localIntStream.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(IntPredicate predicate) {
        return this.localIntStream.noneMatch(predicate);
    }

    @Override
    public OptionalInt findFirst() {
        return this.localIntStream.findFirst();
    }

    @Override
    public OptionalInt findAny() {
        return this.localIntStream.findAny();
    }

    @Override
    public CacheStream<Integer> boxed() {
        return this.mapToObj(Integer::valueOf);
    }

    @Override
    public DoubleCacheStream asDoubleStream() {
        return this.mapToDouble(l -> l);
    }

    @Override
    public LongCacheStream asLongStream() {
        return this.mapToLong(l -> l);
    }

    @Override
    public IntCacheStream onClose(Runnable closeHandler) {
        this.remoteStream = (BaseCacheStream)this.remoteStream.onClose(closeHandler);
        return this;
    }

    @Override
    public void close() {
        this.localIntStream.close();
        this.remoteStream.close();
    }
}

