/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree.filter.provider;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.compositeindex.datacube.Dimension;
import org.opensearch.index.mapper.CompositeDataCubeFieldType;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.startree.StarTreeQueryHelper;
import org.opensearch.search.startree.filter.DimensionFilter;
import org.opensearch.search.startree.filter.StarTreeFilter;
import org.opensearch.search.startree.filter.provider.BoolStarTreeFilterProvider;
import org.opensearch.search.startree.filter.provider.DimensionFilterMapper;
import org.opensearch.search.startree.filter.provider.StarTreeRangeQuery;

@ExperimentalApi
public interface StarTreeFilterProvider {
    public static final StarTreeFilterProvider MATCH_ALL_PROVIDER = (context, rawFilter, compositeFieldType) -> new StarTreeFilter(Collections.emptyMap());

    public StarTreeFilter getFilter(SearchContext var1, QueryBuilder var2, CompositeDataCubeFieldType var3) throws IOException;

    public static class RangeStarTreeFilterProvider
    implements StarTreeFilterProvider {
        @Override
        public StarTreeFilter getFilter(SearchContext context, QueryBuilder rawFilter, CompositeDataCubeFieldType compositeFieldType) throws IOException {
            DimensionFilterMapper dimensionFilterMapper;
            StarTreeRangeQuery rangeQuery = new StarTreeRangeQuery(rawFilter);
            String field = rangeQuery.fieldName();
            Dimension matchedDimension = StarTreeQueryHelper.getMatchingDimensionOrNull(field, compositeFieldType.getDimensions());
            MappedFieldType mappedFieldType = context.mapperService().fieldType(field);
            DimensionFilterMapper dimensionFilterMapper2 = dimensionFilterMapper = mappedFieldType == null ? null : DimensionFilterMapper.Factory.fromMappedFieldType(mappedFieldType, context);
            if (matchedDimension == null || mappedFieldType == null || dimensionFilterMapper == null) {
                return null;
            }
            DimensionFilter dimensionFilter = dimensionFilterMapper.getRangeMatchFilter(mappedFieldType, rangeQuery);
            if (dimensionFilter == null) {
                return null;
            }
            return new StarTreeFilter(Map.of(field, List.of(dimensionFilter)));
        }
    }

    public static class TermsStarTreeFilterProvider
    implements StarTreeFilterProvider {
        @Override
        public StarTreeFilter getFilter(SearchContext context, QueryBuilder rawFilter, CompositeDataCubeFieldType compositeFieldType) throws IOException {
            DimensionFilterMapper dimensionFilterMapper;
            TermsQueryBuilder termsQueryBuilder = (TermsQueryBuilder)rawFilter;
            String field = termsQueryBuilder.fieldName();
            Dimension matchedDimension = StarTreeQueryHelper.getMatchingDimensionOrNull(field, compositeFieldType.getDimensions());
            MappedFieldType mappedFieldType = context.mapperService().fieldType(field);
            DimensionFilterMapper dimensionFilterMapper2 = dimensionFilterMapper = mappedFieldType != null ? DimensionFilterMapper.Factory.fromMappedFieldType(mappedFieldType, context) : null;
            if (matchedDimension == null || mappedFieldType == null || dimensionFilterMapper == null) {
                return null;
            }
            DimensionFilter dimensionFilter = dimensionFilterMapper.getExactMatchFilter(mappedFieldType, termsQueryBuilder.values());
            return dimensionFilter == null ? null : new StarTreeFilter(Map.of(field, List.of(dimensionFilter)));
        }
    }

    public static class TermStarTreeFilterProvider
    implements StarTreeFilterProvider {
        @Override
        public StarTreeFilter getFilter(SearchContext context, QueryBuilder rawFilter, CompositeDataCubeFieldType compositeFieldType) throws IOException {
            TermQueryBuilder termQueryBuilder = (TermQueryBuilder)rawFilter;
            String field = termQueryBuilder.fieldName();
            MappedFieldType mappedFieldType = context.mapperService().fieldType(field);
            DimensionFilterMapper dimensionFilterMapper = mappedFieldType != null ? DimensionFilterMapper.Factory.fromMappedFieldType(mappedFieldType, context) : null;
            Dimension matchedDimension = StarTreeQueryHelper.getMatchingDimensionOrNull(field, compositeFieldType.getDimensions());
            if (matchedDimension == null || mappedFieldType == null || dimensionFilterMapper == null) {
                return null;
            }
            DimensionFilter dimensionFilter = dimensionFilterMapper.getExactMatchFilter(mappedFieldType, List.of(termQueryBuilder.value()));
            return dimensionFilter == null ? null : new StarTreeFilter(Map.of(field, List.of(dimensionFilter)));
        }
    }

    public static class SingletonFactory {
        private static final Map<String, StarTreeFilterProvider> QUERY_BUILDERS_TO_STF_PROVIDER = Map.of("match_all", MATCH_ALL_PROVIDER, "term", new TermStarTreeFilterProvider(), "terms", new TermsStarTreeFilterProvider(), "range", new RangeStarTreeFilterProvider(), "bool", new BoolStarTreeFilterProvider());

        public static StarTreeFilterProvider getProvider(QueryBuilder query) {
            if (query != null) {
                return QUERY_BUILDERS_TO_STF_PROVIDER.get(query.getName());
            }
            return MATCH_ALL_PROVIDER;
        }
    }
}

