/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerRetryPolicy;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class ContainerRetryContext {
    public static final int RETRY_FOREVER = -1;
    public static final int RETRY_INVALID = -1000;
    public static final ContainerRetryContext NEVER_RETRY_CONTEXT = ContainerRetryContext.newInstance(ContainerRetryPolicy.NEVER_RETRY, null, 0, 0);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ContainerRetryContext newInstance(ContainerRetryPolicy retryPolicy, Set<Integer> errorCodes, int maxRetries, int retryInterval, long failuresValidityInterval) {
        ContainerRetryContext containerRetryContext = Records.newRecord(ContainerRetryContext.class);
        containerRetryContext.setRetryPolicy(retryPolicy);
        containerRetryContext.setErrorCodes(errorCodes);
        containerRetryContext.setMaxRetries(maxRetries);
        containerRetryContext.setRetryInterval(retryInterval);
        containerRetryContext.setFailuresValidityInterval(failuresValidityInterval);
        return containerRetryContext;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ContainerRetryContext newInstance(ContainerRetryPolicy retryPolicy, Set<Integer> errorCodes, int maxRetries, int retryInterval) {
        return ContainerRetryContext.newInstance(retryPolicy, errorCodes, maxRetries, retryInterval, -1L);
    }

    public abstract ContainerRetryPolicy getRetryPolicy();

    public abstract void setRetryPolicy(ContainerRetryPolicy var1);

    public abstract Set<Integer> getErrorCodes();

    public abstract void setErrorCodes(Set<Integer> var1);

    public abstract int getMaxRetries();

    public abstract void setMaxRetries(int var1);

    public abstract int getRetryInterval();

    public abstract void setRetryInterval(int var1);

    public abstract long getFailuresValidityInterval();

    public abstract void setFailuresValidityInterval(long var1);
}

