/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.intermediate;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.options.InternalProperties;
import org.eclipse.elk.alg.mrtree.options.MrTreeOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class LevelProcessor
implements ILayoutProcessor<TGraph> {
    private Map<Integer, Integer> gloLevelMap = new HashMap<Integer, Integer>();

    @Override
    public void process(TGraph tGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Processor compute fanout", 1.0f);
        List<TNode> roots = tGraph.getNodes().stream().filter(x -> x.getProperty(InternalProperties.ROOT)).collect(Collectors.toList());
        this.setLevel(roots, 0);
        for (TNode tNode : tGraph.getNodes()) {
            int level = this.gloLevelMap.get(tNode.id) != null ? this.gloLevelMap.get(tNode.id) : 0;
            tNode.setProperty(MrTreeOptions.TREE_LEVEL, (Object)level);
        }
        progressMonitor.done();
    }

    private void setLevel(List<TNode> currentLevel, int level) {
        if (!currentLevel.isEmpty()) {
            LinkedList<TNode> nextLevel = new LinkedList<TNode>();
            for (TNode tNode : currentLevel) {
                this.gloLevelMap.put(tNode.id, level);
                for (TNode tChild : tNode.getChildren()) {
                    nextLevel.add(tChild);
                }
            }
            this.setLevel(nextLevel, level + 1);
        }
    }
}

