/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class FileLoader {
    public static ThreadLocal<ClassLoader> binderClassLoader = new ThreadLocal();

    public static String readFileToString(File file) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (FileReader fileReader = new FileReader(file);){
            FileLoader.readToStringBuilder(fileReader, stringBuilder);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file, String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        FileInputStream fileInputStream = new FileInputStream(file);
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string);){
            FileLoader.readToStringBuilder(inputStreamReader, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public static String readInputStreamToString(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        FileLoader.readInputStreamToStringBuilder(inputStream, stringBuilder);
        return stringBuilder.toString();
    }

    public static String readResourceToString(Class clazz, String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        FileLoader.readResourceToStringBuilder(clazz, string, stringBuilder);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readResourceToStringBuilder(Class clazz, String string, StringBuilder stringBuilder) throws IOException {
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException(string);
        }
        try {
            FileLoader.readInputStreamToStringBuilder(inputStream, stringBuilder);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static void readInputStreamToStringBuilder(InputStream inputStream, StringBuilder stringBuilder) throws IOException {
        int n2;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        while ((n2 = inputStreamReader.read(cArray, 0, 1024)) != -1) {
            stringBuilder.append(cArray, 0, n2);
        }
    }

    private static void readToStringBuilder(Reader reader, StringBuilder stringBuilder) throws IOException {
        int n2;
        char[] cArray = new char[1024];
        while ((n2 = reader.read(cArray, 0, 1024)) != -1) {
            stringBuilder.append(cArray, 0, n2);
        }
    }

    public static byte[] readInputStreamToByteArray(InputStream inputStream) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray, 0, 1024)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

