/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.security.cert.X509Certificate;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import oracle.jdbc.SecurityInformation;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.nt.DNVerifier;
import oracle.net.nt.SocketChannelWrapper;

@DefaultLogger(value="oracle.net")
@Supports(value={Feature.NET})
public class SSLSocketChannel
extends SocketChannelWrapper {
    private final SSLEngine sslEngine;
    private ByteBuffer localUnwrapBuffer;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private boolean isClosed;
    private boolean isHandshakeDone;
    private final ByteBuffer EMPTY_BUFFER;
    private final DNVerifier dnVerifier;
    private SecurityInformation.DNMatchStatus dnMatchStatus;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;

    public SSLSocketChannel(SocketChannel channel, SSLEngine engine, DNVerifier dnVerifier) throws IOException {
        super(channel);
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$31, null, channel, engine, dnVerifier);
            }
            this.isClosed = false;
            this.isHandshakeDone = false;
            this.EMPTY_BUFFER = ByteBuffer.allocate(0);
            this.dnMatchStatus = SecurityInformation.DNMatchStatus.NOT_VERIFIED;
            this.socketChannel = channel;
            this.sslEngine = engine;
            this.dnVerifier = dnVerifier;
            this.initializeBuffers();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$31, null);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$31, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$31, null, throwable2);
            }
            throw throwable;
        }
    }

    public SSLSocketChannel(SocketChannel channel, SSLEngine engine) throws IOException {
        this(channel, engine, null);
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$32, null, channel, engine);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$32, null);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$32, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$32, null, throwable2);
            }
            throw throwable;
        }
    }

    public SecurityInformation.DNMatchStatus getDnMatchStatus() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$0, this, new Object[0]);
            }
            SecurityInformation.DNMatchStatus dNMatchStatus = this.dnMatchStatus;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$0, this, (Object)dNMatchStatus);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$0, this, null);
            }
            return dNMatchStatus;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            int readBytesCount;
            void dstBuffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$1, this, byteBuffer);
            }
            if (this.isClosed()) {
                int n2 = -1;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$1, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$1, this, null);
                }
                return -1;
            }
            if (dstBuffer == null || !dstBuffer.hasRemaining()) {
                int n3 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$1, this, n3);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$1, this, null);
                }
                return 0;
            }
            if (!this.isHandshakeDone) {
                this.doSSLHandshake();
            }
            if ((readBytesCount = this.readFromLocalUnwrapBuffer((ByteBuffer)dstBuffer)) == 0) {
                int dstBufferInitialPosition = dstBuffer.position();
                this.fillAndUnwrap((ByteBuffer)dstBuffer);
                readBytesCount = dstBuffer.position() - dstBufferInitialPosition;
            }
            int n4 = readBytesCount;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$1, this, n4);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$1, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void srcBuffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$2, this, byteBuffer);
            }
            if (this.isClosed()) {
                ClosedChannelException closedChannelException = new ClosedChannelException();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$2, this, closedChannelException);
                }
                throw closedChannelException;
            }
            if (!this.isHandshakeDone) {
                this.doSSLHandshake();
            }
            if (!this.writeToSocket()) {
                int n2 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$2, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$2, this, null);
                }
                return 0;
            }
            int initialPosition = srcBuffer.position();
            this.wrapAndWriteToSocket((ByteBuffer)srcBuffer);
            if (this.writeBuffer.hasRemaining() && !srcBuffer.hasRemaining()) {
                boolean flushSuccessful = false;
                for (int attemptCount = 0; !flushSuccessful && attemptCount < 10; ++attemptCount) {
                    flushSuccessful = this.writeToSocket();
                }
                if (!flushSuccessful) {
                    IOException iOException = new IOException("Unable to write to the socket");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$2, this, iOException);
                    }
                    throw iOException;
                }
            }
            int n3 = initialPosition - srcBuffer.position();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$2, this, n3);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$2, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void wrapAndWriteToSocket(ByteBuffer byteBuffer) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void srcBuffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$3, this, byteBuffer);
            }
            boolean wrapSuccessful = false;
            this.writeBuffer.clear();
            while (srcBuffer.hasRemaining()) {
                SSLEngineResult result = this.wrap((ByteBuffer)srcBuffer);
                if (result.getStatus() != SSLEngineResult.Status.OK) {
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        if (wrapSuccessful) {
                            if (!this.flushWriteBuffer()) break;
                            this.writeBuffer.clear();
                            continue;
                        }
                        IOException iOException = new IOException("Write error '" + (Object)((Object)result.getStatus()) + '\'');
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$3, this, iOException);
                        }
                        throw iOException;
                    }
                    this.shutdown();
                    IOException iOException = new IOException("Write error '" + (Object)((Object)result.getStatus()) + '\'');
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$3, this, iOException);
                    }
                    throw iOException;
                }
                wrapSuccessful = true;
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                this.runTasks();
            }
            this.flushWriteBuffer();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    private boolean flushWriteBuffer() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$4, this, new Object[0]);
            }
            this.writeBuffer.flip();
            if (this.writeToSocket()) {
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$4, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$4, this, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$4, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$4, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean hasRemaining() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$5, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.readBuffer.hasRemaining() || this.localUnwrapBuffer.hasRemaining();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$5, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$5, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean fillAndUnwrap(ByteBuffer byteBuffer) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean unwrapSuccessful;
            void dstBuffer;
            boolean readFromSocket;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$6, this, byteBuffer);
            }
            SSLEngineResult wrapResult = null;
            boolean useLocalUnwrapBuffer = false;
            boolean bl2 = readFromSocket = !this.readBuffer.hasRemaining();
            while (wrapResult == null || wrapResult.getStatus() != SSLEngineResult.Status.OK) {
                if (readFromSocket) {
                    if (this.fillReadBuffer()) {
                        readFromSocket = false;
                    } else {
                        boolean bl3 = false;
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$6, this, bl3);
                            ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$6, this, null);
                        }
                        return false;
                    }
                }
                if ((wrapResult = useLocalUnwrapBuffer ? this.unwrapToLocalBuffer() : this.unwrapData((ByteBuffer)dstBuffer)).getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    if (useLocalUnwrapBuffer) {
                        IOException iOException = new IOException("Read error '" + (Object)((Object)wrapResult.getStatus()) + '\'');
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$6, this, iOException);
                        }
                        throw iOException;
                    }
                    useLocalUnwrapBuffer = true;
                    readFromSocket = false;
                    continue;
                }
                if (wrapResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                readFromSocket = true;
            }
            boolean bl4 = unwrapSuccessful = wrapResult != null && wrapResult.getStatus() == SSLEngineResult.Status.OK;
            if (unwrapSuccessful && useLocalUnwrapBuffer) {
                this.readFromLocalUnwrapBuffer((ByteBuffer)dstBuffer);
            }
            boolean bl5 = unwrapSuccessful;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$6, this, bl5);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$6, this, null);
            }
            return bl5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    private SSLEngineResult unwrapToLocalBuffer() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$7, this, new Object[0]);
            }
            if (!$assertionsDisabled && this.localUnwrapBuffer.hasRemaining()) {
                AssertionError assertionError = new AssertionError();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$7, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.localUnwrapBuffer.clear();
            SSLEngineResult result = this.unwrapData(this.localUnwrapBuffer);
            this.localUnwrapBuffer.flip();
            SSLEngineResult sSLEngineResult = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$7, this, sSLEngineResult);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$7, this, null);
            }
            return sSLEngineResult;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    private boolean fillReadBuffer() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$8, this, new Object[0]);
            }
            if (this.readBuffer.hasRemaining()) {
                this.readBuffer.compact();
            } else {
                this.readBuffer.clear();
            }
            int readBytes = this.readFromSocket();
            this.readBuffer.flip();
            boolean bl3 = bl2 = readBytes > 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$8, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$8, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private SSLEngineResult unwrapData(ByteBuffer byteBuffer) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void dstBuffer;
            SSLEngineResult result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$9, this, byteBuffer);
            }
            if ((result = this.unwrap(this.readBuffer, (ByteBuffer)dstBuffer)).getStatus() == SSLEngineResult.Status.CLOSED) {
                this.shutdown();
                IOException iOException = new IOException("Read error '" + (Object)((Object)result.getStatus()) + '\'');
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$9, this, iOException);
                }
                throw iOException;
            }
            if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.runTasks();
            }
            SSLEngineResult sSLEngineResult = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$9, this, sSLEngineResult);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$9, this, null);
            }
            return sSLEngineResult;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    private void shutdown() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$10, this, new Object[0]);
            }
            if (this.isClosed) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$10, this);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$10, this, null);
                }
                return;
            }
            this.isClosed = true;
            try {
                if (!this.sslEngine.isOutboundDone()) {
                    this.sslEngine.closeOutbound();
                    this.writeBuffer.clear();
                    this.wrap(this.EMPTY_BUFFER);
                    this.writeBuffer.flip();
                    this.writeToSocket();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.closeUnderlyingChannel();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    private void closeUnderlyingChannel() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$11, this, new Object[0]);
            }
            try {
                if (this.socketChannel instanceof SocketChannelWrapper) {
                    ((SocketChannelWrapper)this.socketChannel).disconnect();
                } else {
                    this.socketChannel.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int readFromLocalUnwrapBuffer(ByteBuffer byteBuffer) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void dstBuffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$12, this, byteBuffer);
            }
            if (!this.localUnwrapBuffer.hasRemaining()) {
                int n2 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$12, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$12, this, null);
                }
                return 0;
            }
            int bytesToCopy = Math.min(this.localUnwrapBuffer.remaining(), dstBuffer.remaining());
            for (int i2 = 0; i2 < bytesToCopy; ++i2) {
                dstBuffer.put(this.localUnwrapBuffer.get());
            }
            int n3 = bytesToCopy;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$12, this, n3);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$12, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    private void initializeBuffers() throws SSLException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$13, this, new Object[0]);
            }
            SSLSession sslSession = this.sslEngine.getSession();
            this.localUnwrapBuffer = ByteBuffer.allocate(sslSession.getApplicationBufferSize());
            this.readBuffer = ByteBuffer.allocate(sslSession.getPacketBufferSize());
            this.writeBuffer = ByteBuffer.allocate(sslSession.getPacketBufferSize());
            this.localUnwrapBuffer.limit(0);
            this.readBuffer.limit(0);
            this.writeBuffer.limit(0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    private void doSSLHandshake() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$14, this, new Object[0]);
            }
            if (this.isHandshakeDone) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$14, this);
                    ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$14, this, null);
                }
                return;
            }
            this.sslEngine.beginHandshake();
            SSLEngineResult.HandshakeStatus handShakeStatus = this.sslEngine.getHandshakeStatus();
            block8: while (!this.isHandshakeDone && !this.isClosed) {
                switch (handShakeStatus) {
                    case NEED_TASK: {
                        handShakeStatus = this.runTasks();
                        continue block8;
                    }
                    case NEED_UNWRAP: {
                        handShakeStatus = this.unwrapHandshakeMessage();
                        continue block8;
                    }
                    case NEED_WRAP: {
                        handShakeStatus = this.wrapHandshakeMessage();
                        continue block8;
                    }
                    case FINISHED: {
                        this.isHandshakeDone = true;
                        if (this.dnVerifier == null || this.dnVerifier.isWeakDNMatchAllowed()) continue block8;
                        this.verifyDN();
                        continue block8;
                    }
                }
                IllegalStateException illegalStateException = new IllegalStateException("Unexpected handshake status '" + (Object)((Object)handShakeStatus) + '\'');
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$14, this, illegalStateException);
                }
                throw illegalStateException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    CompletionStage<Void> doSSLHandshakeAsync(Executor executor) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void asyncExecutor;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$15, this, executor);
            }
            if (this.isHandshakeDone) {
                CompletableFuture<Void> completableFuture = CompletionStageUtil.VOID_COMPLETED_FUTURE;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$15, this, completableFuture);
                    ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$15, this, null);
                }
                return completableFuture;
            }
            try {
                this.sslEngine.beginHandshake();
            }
            catch (SSLException beginHandshakeFailure) {
                CompletionStage<Void> completionStage = CompletionStageUtil.failedStage(beginHandshakeFailure);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$15, this, completionStage);
                    ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$15, this, null);
                }
                return completionStage;
            }
            CompletionStage<Void> completionStage = this.chainAsyncHandshakeIO((Executor)asyncExecutor);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$15, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$15, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    private CompletionStage<Void> chainAsyncHandshakeIO(Executor var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SSLEngineResult.HandshakeStatus wrapHandshakeMessage() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$17, this, new Object[0]);
            }
            this.writeBuffer.clear();
            SSLEngineResult result = this.wrap(this.EMPTY_BUFFER);
            SSLEngineResult.HandshakeStatus handShakeStatus = result.getHandshakeStatus();
            if (result.getStatus() != SSLEngineResult.Status.OK) {
                IOException iOException = new IOException("Handshake failed : " + (Object)((Object)result.getStatus()));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$17, this, iOException);
                }
                throw iOException;
            }
            this.writeBuffer.flip();
            this.writeToSocket();
            SSLEngineResult.HandshakeStatus handshakeStatus = handShakeStatus;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$17, this, (Object)handshakeStatus);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$17, this, null);
            }
            return handshakeStatus;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    private SSLEngineResult.HandshakeStatus unwrapHandshakeMessage() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            SSLEngineResult.HandshakeStatus handShakeStatus;
            SSLEngineResult result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$18, this, new Object[0]);
            }
            if (!this.readBuffer.hasRemaining()) {
                this.readBuffer.clear();
                while (this.readFromSocket() == 0) {
                }
                this.readBuffer.flip();
            }
            do {
                this.localUnwrapBuffer.clear();
                result = this.unwrap(this.readBuffer, this.localUnwrapBuffer);
                handShakeStatus = result.getHandshakeStatus();
                if (result.getStatus() == SSLEngineResult.Status.OK) {
                    this.readBuffer.compact();
                    this.readBuffer.flip();
                    this.localUnwrapBuffer.flip();
                    continue;
                }
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    this.readBuffer.compact();
                    if (this.readBuffer.position() == this.readBuffer.capacity()) {
                        IOException iOException = new IOException("Handshake failed : SSL packet is too big to hold in the read buffer");
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$18, this, iOException);
                        }
                        throw iOException;
                    }
                    while (this.readFromSocket() == 0) {
                    }
                    this.readBuffer.flip();
                    continue;
                }
                IOException iOException = new IOException("Handshake failed : " + (Object)((Object)result.getStatus()));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$18, this, iOException);
                }
                throw iOException;
            } while (result.getStatus() != SSLEngineResult.Status.OK);
            SSLEngineResult.HandshakeStatus handshakeStatus = handShakeStatus;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$18, this, (Object)handshakeStatus);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$18, this, null);
            }
            return handshakeStatus;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            SSLEngineResult sSLEngineResult;
            block10: {
                void destbuffer;
                void srcBuffer;
                block8: {
                    SSLEngineResult sSLEngineResult2;
                    block9: {
                        SSLEngineResult sSLEngineResult3;
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$19, this, byteBuffer, byteBuffer2);
                        }
                        try {
                            if (!this.isEmptyTLSPacket((ByteBuffer)srcBuffer)) break block8;
                            sSLEngineResult2 = sSLEngineResult3 = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 5, 0);
                            if (!bl) break block9;
                        }
                        catch (Exception e2) {
                            IOException iOException = (IOException)new IOException("IO Error " + e2.getMessage()).initCause(e2);
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$19, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$19, this, iOException);
                            }
                            throw iOException;
                        }
                        ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$19, this, sSLEngineResult3);
                        ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$19, this, null);
                    }
                    return sSLEngineResult2;
                }
                sSLEngineResult = this.sslEngine.unwrap((ByteBuffer)srcBuffer, (ByteBuffer)destbuffer);
                if (!bl) break block10;
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$19, this, sSLEngineResult);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$19, this, null);
            }
            return sSLEngineResult;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isEmptyTLSPacket(ByteBuffer byteBuffer) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void srcBuffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$20, this, byteBuffer);
            }
            if (srcBuffer.remaining() >= 5) {
                int initialPosition = srcBuffer.position();
                byte recordType = srcBuffer.get();
                short tlsVersion = srcBuffer.getShort();
                short length = srcBuffer.getShort();
                if (recordType == 23 && length == 0) {
                    boolean bl2 = true;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$20, this, bl2);
                        ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$20, this, null);
                    }
                    return true;
                }
                srcBuffer.position(initialPosition);
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$20, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$20, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private SSLEngineResult wrap(ByteBuffer byteBuffer) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            SSLEngineResult sSLEngineResult;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$21, this, byteBuffer);
                }
                try {
                    void srcBuffer;
                    sSLEngineResult = this.sslEngine.wrap((ByteBuffer)srcBuffer, this.writeBuffer);
                    if (!bl) break block7;
                }
                catch (Exception e2) {
                    IOException iOException = (IOException)new IOException("IO Error " + e2.getMessage()).initCause(e2);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$21, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$21, this, iOException);
                    }
                    throw iOException;
                }
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$21, this, sSLEngineResult);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$21, this, null);
            }
            return sSLEngineResult;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    private int readFromSocket() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block14: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$22, this, new Object[0]);
                }
                if (!this.readBuffer.hasRemaining()) {
                    IOException iOException = new IOException("IO Error : No room left in the read buffer");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$22, this, iOException);
                    }
                    throw iOException;
                }
                try {
                    int bytesRead = this.socketChannel.read(this.readBuffer);
                    if (bytesRead < 0) {
                        IOException iOException = new IOException("Connection closed");
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$22, this, iOException);
                        }
                        throw iOException;
                    }
                    n2 = bytesRead;
                    if (!bl) break block14;
                }
                catch (IOException x2) {
                    try {
                        if (!this.sslEngine.isInboundDone()) {
                            this.sslEngine.closeInbound();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.shutdown();
                    IOException iOException = x2;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$22, this, iOException);
                    }
                    throw iOException;
                }
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$22, this, n2);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$22, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    private boolean writeToSocket() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            boolean bl3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$23, this, new Object[0]);
            }
            try {
                this.socketChannel.write(this.writeBuffer);
                bl2 = bl3 = !this.writeBuffer.hasRemaining();
            }
            catch (IOException x2) {
                this.shutdown();
                IOException iOException = x2;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$23, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$23, this, iOException);
                }
                throw iOException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$23, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$23, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    private boolean isClosed() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$24, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.isClosed || !this.socketChannel.isOpen() || this.socketChannel.socket().isInputShutdown() || this.socketChannel.socket().isOutputShutdown();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$24, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$24, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    private SSLEngineResult.HandshakeStatus runTasks() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            SSLEngineResult.HandshakeStatus handshakeStatus;
            block8: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$25, this, new Object[0]);
                }
                try {
                    Runnable runnable;
                    while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
                        runnable.run();
                    }
                    handshakeStatus = this.sslEngine.getHandshakeStatus();
                    if (!bl) break block8;
                }
                catch (Exception e2) {
                    IOException iOException = (IOException)new IOException("IO Error " + e2.getMessage()).initCause(e2);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$25, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$25, this, iOException);
                    }
                    throw iOException;
                }
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$25, this, (Object)handshakeStatus);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$25, this, null);
            }
            return handshakeStatus;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    void verifyDN() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$26, this, new Object[0]);
            }
            if (this.dnVerifier != null) {
                this.dnMatchStatus = this.dnVerifier.verify((X509Certificate)this.sslEngine.getSession().getPeerCertificates()[0]);
            } else if (bl) {
                this.debug($$$loggerRef$$$26, Level.FINEST, $$$methodRef$$$26, "Server DN verification is disabled and connection is not secure.Enable DN verification through Connection Property 'oracle.net.ssl_server_dn_match' or through URL parameter 'SSL_SERVER_DN_MATCH'");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$26, this);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$26, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void disconnect() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$27, this, new Object[0]);
            }
            if (this.isClosed) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$27, this);
                    ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$27, this, null);
                }
                return;
            }
            this.shutdown();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public String toString() {
        return "SSLSocketChannel[" + this.socket().toString() + "]";
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ CompletionStage lambda$chainAsyncHandshakeIO$2(Executor executor, Void void_) throws Exception {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void asyncExecutor;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$28, this, executor, void_);
            }
            this.unwrapHandshakeMessage();
            CompletionStage<Void> completionStage = this.chainAsyncHandshakeIO((Executor)asyncExecutor);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$28, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$28, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$chainAsyncHandshakeIO$1(Executor executor, CompletableFuture completableFuture, Throwable throwable) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void ioFuture;
            void error;
            Executor asyncExecutor;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$29, null, executor, completableFuture, throwable);
            }
            asyncExecutor.execute(() -> SSLSocketChannel.lambda$null$0((Throwable)error, (CompletableFuture)ioFuture));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$29, null);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$29, null, null);
            }
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$29, null, throwable3);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$null$0(Throwable throwable, CompletableFuture completableFuture) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void ioFuture;
            Throwable error;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$30, null, throwable, completableFuture);
            }
            if (error == null) {
                ioFuture.complete(null);
            } else {
                ioFuture.completeExceptionally(error);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$30, null);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$30, null, null);
            }
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, SSLSocketChannel.class, $$$methodRef$$$30, null, throwable3);
            }
            throw throwable2;
        }
    }

    static {
        try {
            $$$methodRef$$$32 = SSLSocketChannel.class.getDeclaredConstructor(SocketChannel.class, SSLEngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$31 = SSLSocketChannel.class.getDeclaredConstructor(SocketChannel.class, SSLEngine.class, DNVerifier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$30 = SSLSocketChannel.class.getDeclaredMethod("lambda$null$0", Throwable.class, CompletableFuture.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$29 = SSLSocketChannel.class.getDeclaredMethod("lambda$chainAsyncHandshakeIO$1", Executor.class, CompletableFuture.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$28 = SSLSocketChannel.class.getDeclaredMethod("lambda$chainAsyncHandshakeIO$2", Executor.class, Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$27 = SSLSocketChannel.class.getDeclaredMethod("disconnect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$26 = SSLSocketChannel.class.getDeclaredMethod("verifyDN", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$25 = SSLSocketChannel.class.getDeclaredMethod("runTasks", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$24 = SSLSocketChannel.class.getDeclaredMethod("isClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$23 = SSLSocketChannel.class.getDeclaredMethod("writeToSocket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$22 = SSLSocketChannel.class.getDeclaredMethod("readFromSocket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$21 = SSLSocketChannel.class.getDeclaredMethod("wrap", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$20 = SSLSocketChannel.class.getDeclaredMethod("isEmptyTLSPacket", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$19 = SSLSocketChannel.class.getDeclaredMethod("unwrap", ByteBuffer.class, ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$18 = SSLSocketChannel.class.getDeclaredMethod("unwrapHandshakeMessage", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$17 = SSLSocketChannel.class.getDeclaredMethod("wrapHandshakeMessage", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$16 = SSLSocketChannel.class.getDeclaredMethod("chainAsyncHandshakeIO", Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$15 = SSLSocketChannel.class.getDeclaredMethod("doSSLHandshakeAsync", Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$14 = SSLSocketChannel.class.getDeclaredMethod("doSSLHandshake", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$13 = SSLSocketChannel.class.getDeclaredMethod("initializeBuffers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$12 = SSLSocketChannel.class.getDeclaredMethod("readFromLocalUnwrapBuffer", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$11 = SSLSocketChannel.class.getDeclaredMethod("closeUnderlyingChannel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$10 = SSLSocketChannel.class.getDeclaredMethod("shutdown", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$9 = SSLSocketChannel.class.getDeclaredMethod("unwrapData", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$8 = SSLSocketChannel.class.getDeclaredMethod("fillReadBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$7 = SSLSocketChannel.class.getDeclaredMethod("unwrapToLocalBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$6 = SSLSocketChannel.class.getDeclaredMethod("fillAndUnwrap", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$5 = SSLSocketChannel.class.getDeclaredMethod("hasRemaining", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$4 = SSLSocketChannel.class.getDeclaredMethod("flushWriteBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$3 = SSLSocketChannel.class.getDeclaredMethod("wrapAndWriteToSocket", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$2 = SSLSocketChannel.class.getDeclaredMethod("write", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$1 = SSLSocketChannel.class.getDeclaredMethod("read", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$0 = SSLSocketChannel.class.getDeclaredMethod("getDnMatchStatus", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
    }
}

