/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.index;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.lucene.index.MergePolicy;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.index.DefaultMergePolicyFactory;
import org.apache.solr.index.MergePolicyFactory;
import org.apache.solr.index.MergePolicyFactoryArgs;
import org.apache.solr.schema.IndexSchema;

public abstract class WrapperMergePolicyFactory
extends MergePolicyFactory {
    private static final String CLASS = "class";
    protected static final String[] NO_SUB_PACKAGES = new String[0];
    static final String WRAPPED_PREFIX = "wrapped.prefix";
    private final MergePolicyFactoryArgs wrappedMergePolicyArgs = this.filterWrappedMergePolicyFactoryArgs("wrapped.prefix");
    private final String wrappedMergePolicyClassName;

    protected WrapperMergePolicyFactory(SolrResourceLoader resourceLoader, MergePolicyFactoryArgs args, IndexSchema schema) {
        super(resourceLoader, args, schema);
        if (this.wrappedMergePolicyArgs == null) {
            this.wrappedMergePolicyClassName = null;
        } else {
            this.wrappedMergePolicyClassName = (String)this.wrappedMergePolicyArgs.remove(CLASS);
            if (this.wrappedMergePolicyClassName == null) {
                throw new IllegalArgumentException("Class name not defined for wrapped MergePolicyFactory!");
            }
        }
        if (this.wrappedMergePolicyArgs != null) {
            HashSet<String> overshadowedWrappedMergePolicyArgs = new HashSet<String>(this.wrappedMergePolicyArgs.keys());
            overshadowedWrappedMergePolicyArgs.retainAll(args.keys());
            if (!overshadowedWrappedMergePolicyArgs.isEmpty()) {
                throw new IllegalArgumentException("Wrapping and wrapped merge policy args overlap! " + String.valueOf(overshadowedWrappedMergePolicyArgs));
            }
        }
    }

    protected MergePolicy getDefaultWrappedMergePolicy() {
        DefaultMergePolicyFactory mpf = new DefaultMergePolicyFactory();
        return ((MergePolicyFactory)mpf).getMergePolicy();
    }

    protected final MergePolicy getWrappedMergePolicy() {
        if (this.wrappedMergePolicyArgs == null) {
            return this.getDefaultWrappedMergePolicy();
        }
        MergePolicyFactory mpf = this.resourceLoader.newInstance(this.wrappedMergePolicyClassName, MergePolicyFactory.class, NO_SUB_PACKAGES, new Class[]{SolrResourceLoader.class, MergePolicyFactoryArgs.class, IndexSchema.class}, new Object[]{this.resourceLoader, this.wrappedMergePolicyArgs, this.schema});
        return mpf.getMergePolicy();
    }

    protected abstract MergePolicy getMergePolicyInstance(MergePolicy var1);

    @Override
    public final MergePolicy getMergePolicy() {
        MergePolicy wrappedMP = this.getWrappedMergePolicy();
        MergePolicy mp = this.getMergePolicyInstance(wrappedMP);
        this.args.invokeSetters(mp);
        return mp;
    }

    protected MergePolicyFactoryArgs filterWrappedMergePolicyFactoryArgs(String wrappedPrefix) {
        String wrappedPolicyPrefix = (String)this.args.remove(wrappedPrefix);
        if (wrappedPolicyPrefix == null) {
            return null;
        }
        String baseArgsPrefix = wrappedPolicyPrefix + ".";
        int baseArgsPrefixLength = baseArgsPrefix.length();
        MergePolicyFactoryArgs wrappedArgs = new MergePolicyFactoryArgs();
        Iterator<String> iter = this.args.keys().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.startsWith(baseArgsPrefix)) continue;
            wrappedArgs.add(key.substring(baseArgsPrefixLength), this.args.get(key));
            iter.remove();
        }
        return wrappedArgs;
    }
}

